/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.utils;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.addon.imsurvey.services.ClientDetailsService;
import com.imcode.imcms.addon.imsurvey.services.RightsChecker;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ImSurveyUtils {
    private ClientDetailsService clientDetailsService;
    private RightsChecker rightsChecker;
    private static ImSurveyUtils imsurveyUtils;

    @Inject
    public ImSurveyUtils(@Named(value="propertiesPath") String propertiesPath, ClientDetailsService clientDetailsService, RightsChecker rightsChecker) {
        this.clientDetailsService = clientDetailsService;
        this.rightsChecker = rightsChecker;
        imsurveyUtils = this;
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propertiesPath));
            SystemProperties.ONEFLOW_SECURITY_TOKEN = props.getProperty("OneflowSecurityToken");
            SystemProperties.ONEFLOW_CURRENT_POSITION = props.getProperty("OneflowCurrentPosition");
            SystemProperties.ONEFLOW_CREATOR_POSITION = props.getProperty("OneflowCreatorPosition");
            SystemProperties.ONEFLOW_CREATOR_TYPE = props.getProperty("OneflowCreatorType");
            SystemProperties.ONEFLOW_SYSTEM_POSITION = props.getProperty("OneflowSystemPosition");
            SystemProperties.currentAPI = Utils.getAPI(props.getProperty("ActiveAPI"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public User getClientUser(HttpServletRequest request) {
        return this.clientDetailsService.getClient(request);
    }

    public TextDocument getClientDoc(HttpServletRequest request) {
        return this.clientDetailsService.getClientDoc(request);
    }

    public Category getClientCategory(HttpServletRequest request) {
        return this.clientDetailsService.getCategory(request);
    }

    public String getClientTitle(HttpServletRequest request) {
        return this.clientDetailsService.getClientTitle(request);
    }

    public String getClientDescription(HttpServletRequest request) {
        return this.clientDetailsService.getClientDescription(request);
    }

    public boolean currentUserCanAdminSurvey(Document document, ServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        User currentUser = cms.getCurrentUser();
        return this.userCanAdminSurvey(document, currentUser, request);
    }

    public boolean userCanAdminSurvey(Document document, User user, ServletRequest request) {
        return this.rightsChecker.userCanAdminSurvey(document, user, request);
    }

    public static ImSurveyUtils getUtils() {
        return imsurveyUtils;
    }
}

