package com.imcode.imcms.addon.imsurvey.oneflow;

import java.util.HashMap;
import java.util.Map;

/**
 * Possible Oneflow delivery channels
 * Created by dmizem from Ubrainians for ImCode on 17.01.17
 *
 * @author dmizem
 */
public enum DeliveryChannel {
    EMAIL(0), SMS(1), SAME_UNIT(2), NONE(4);

    private final int id;

    private static Map<Integer, DeliveryChannel> map = new HashMap<Integer, DeliveryChannel>();

    static {
        for (DeliveryChannel deliveryChannel : DeliveryChannel.values()) {
            map.put(deliveryChannel.id, deliveryChannel);
        }
    }

    DeliveryChannel(int id) {
        this.id = id;
    }

    public int getValue() {
        return id;
    }

    public static DeliveryChannel valueOf(int id) {
        return map.get(id);
    }

    public static boolean isMember(String value) {
        for (DeliveryChannel field : map.values())
            if (field.name().equals(value.toUpperCase()))
                return true;
        return false;
    }
}