package com.imcode.imcms.addon.imsurvey;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: tomull
 * Date: 2007-jun-25
 */

public class DateField {
	private String fieldName ;
	private String fieldValue ;
	private boolean fieldReadonly ;
	private String contextPath ;

	public DateField( String fieldName, Date fieldValue, boolean fieldReadonly, String contextPath ) {
		this(fieldName, fieldValue == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(fieldValue), fieldReadonly, contextPath);
	}
	public DateField( String fieldName, String fieldValue, boolean fieldReadonly, String contextPath ) {
		this.fieldName     = fieldName ;
		this.fieldValue    = fieldValue ;
		this.fieldReadonly = fieldReadonly ;
		this.contextPath   = contextPath ;
	}
	public DateField( String fieldName ) {
		this.fieldName     = fieldName ;
	}
	public String getInputField() {
		if (fieldReadonly) {
			return
		    "<input type=\"text\" size=\"11\" maxlength=\"10\" class=\"formText\" style=\"width:6em;\" value=\"" + fieldValue + "\" readonly=\"readonly\">"
		    + "<input type=\"hidden\" id=\"" + fieldName + "\" name=\"" + fieldName + "\" value=\"" + fieldValue + "\">"
		    + "</td>\n" +
		    "		<td><img src=\"" + contextPath + "/imcms/jscalendar/images/img.gif\"" +
		    " class=\"calBtn\" style=\"cursor:default; filter:alpha(opacity=50); -moz-opacity:0.5;\"" +
		    " alt=\"\" title=\"\" />" ;
		} else {
			return
		    "<input type=\"text\" id=\"" + fieldName + "\" name=\"" + fieldName + "\" size=\"11\" maxlength=\"10\" class=\"formText\" style=\"width:6em;\" value=\"" + fieldValue + "\"></td>\n" +
		    "		<td><img src=\"" + contextPath + "/imcms/jscalendar/images/img.gif\" id=\"" + fieldName + "_btn\"" +
		    " class=\"calBtn\" style=\"cursor:pointer;\"" +
		    " onmouseover=\"this.style.backgroundColor='#000099';\"" +
		    " onmouseout=\"this.style.backgroundColor=''\"" +
		    " alt=\"\" title=\"Visa kalender\" />" ;
		}
	}
	public String getJS() {
		return "Calendar.setup({\n" +
		       "	inputField  : \"" + fieldName + "\",\n" +
		       "	showsTime  : false,\n" +
		       "	button   : \"" + fieldName + "_btn\"\n" +
		       "})" ;
	}
}
