package com.imcode.imcms.addon.imsurvey.services;

import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;

import javax.servlet.http.HttpServletRequest;

public interface ClientDetailsService {

    /**
     * Users with company name that matches this user's company name can become account admins.
     *
     * @param request
     * @return Owner of this ImSurvey account
     */
    User getClient(HttpServletRequest request);


    /**
     * This document is used to associate account's default settings such as notifcation email addresses, Scrive credential etc.
     * Also used as the destination for left menu's "Client page" link.
     *
     * @param request
     * @return Document representing ImSurvey account
     */
    TextDocument getClientDoc(HttpServletRequest request);


    /**
     * Marks client's survey documents
     *
     * @param request
     * @return
     */
    Category getCategory(HttpServletRequest request);


    /**
     * Displayed in survey admin pages' header
     *
     * @param request
     * @return
     */
    String getClientTitle(HttpServletRequest request);


    /**
     * Displayed in survey admin pages' header
     *
     * @param request
     * @return
     */
    String getClientDescription(HttpServletRequest request);
}
