package com.imcode.imcms.addon.imsurvey.oneflow;

import java.util.ArrayList;
import java.util.List;

/**
 * Document entity for Oneflow API
 * Created by dmizem from Ubrainians for ImCode
 *
 * @author dmizem
 */
public class Document {
    private String title;
    private String id;
    private boolean deleted;
    private List<Field> fields = new ArrayList<Field>();

    public Document(String id, String title) {
        this.title = title;
        this.id = id;
    }

    public Document() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Field> getFields() {
        return fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<Field> getCheckboxes() {
        List<Field> checkboxes = new ArrayList<Field>();

        for (Field f : getFields()) {
            if (f.isCheckbox()) {
                checkboxes.add(f);
            }
        }

        return checkboxes;
    }

    public List<Field> getTextFields() {
        List<Field> checkboxes = new ArrayList<Field>();

        for (Field f : getFields()) {
            if (!f.isCheckbox()) {
                checkboxes.add(f);
            }
        }

        return checkboxes;
    }

    public List<Field> getTemplates() {
        List<Field> templates = new ArrayList<Field>();

        for (Field f : getFields()) {
            if (f.isTemplate()) {
                templates.add(f);
            }
        }
        return templates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Document template = (Document) o;

        if (id != null ? !id.equals(template.id) : template.id != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "Template{" +
                "title='" + title + '\'' +
                ", id='" + id + '\'' +
                '}';
    }
}