package com.imcode.imcms.addon.imsurvey.oneflow;

/**
 * Field entity for Oneflow API
 * Created by dmizem from Ubrainians for ImCode
 *
 * @author dmizem
 */
public class Field {
    private Type type;
    private String name;
    private String externalKey;

    public enum Type {
        CHECKBOX, TEXT, TEMPLATE, USER, USER_FIELD
    }

    public Field() {
    }

    public Field(Type type, String name) {
        this.type = type;
        this.name = name;
        this.externalKey = "";
    }

    public Field(Type type, String name, String externalKey) {
        this.type = type;
        this.name = name;
        this.externalKey = externalKey;
    }

    public boolean isCheckbox() {
        return Type.CHECKBOX == getType();
    }

    public boolean isTemplate() {
        return Type.TEMPLATE == getType();
    }

    public boolean isUser() {
        return Type.USER == getType();
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExternalKey() {
        return externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }
}