package com.imcode.imcms.addon.imsurvey.services;

import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.api.*;

import javax.servlet.ServletRequest;

public class RightsCheckerImpl implements RightsChecker {

    public boolean userCanAdminSurvey(Document doc, User user, ServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest(request);
        UserService userService = imcmsSystem.getUserService();
        if (user == null || user.isDefaultUser()) {
            return false;
        } else if (user.isSuperAdmin()) {
            return true;
        }
        try {
            if (doc.getPublisher().getId() == user.getId()) {
                return true;
            }
        } catch (Exception e) {
            /* Ignore */
        }

        String client = "";
        try {
            DocumentService documentService = imcmsSystem.getDocumentService();
            CategoryType clientCategoryType = Utils.getClientCategoryType(documentService);
            Category clientCategory = doc.getCategoriesOfType(clientCategoryType)[0];
            client = clientCategory.getName();
        } catch (Exception e) {
            /* Ignore */
        }

        if (client.isEmpty() || client.equalsIgnoreCase(user.getCompany())) {
            if (user.hasRole(Utils.getClientAdminRole(userService)) || user.hasRole(Utils.getServiceAdminRole(userService))) {
                return true;
            }
        }

        return false;
    }
}
