package com.imcode.imcms.addon.imsurvey;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.utils.API;
import com.imcode.imcms.api.*;
import com.imcode.util.MultipartHttpServletRequest;
import imcode.server.Imcms;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import java.io.*;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class Utils {
    public static final String ACCOUNT_CATEGORY_TYPE_NAME = "imSurvey_AccountCategories";
    public static final String CLIENT_CATEGORY_TYPE_NAME = "client";
    public static final String SERVICE_CATEGORY_TYPE_NAME = "service";

    //This should be "imsurvey_surveypage". May need a better solution in the future
    public static final String SURVEY_TEMPLATE_NAME = "imsurvey_surveypage_babs";

    public static final String SURVEY_ADMIN_TEMPLATE_NAME = "service_imsurvey";
    public static final String SURVEY_ADMIN_PAGE_ALIAS = "imsurvey";
    public final static String FORM_CATEGORY_NAME = "imSurvey_surveypage";
    public final static String IMSURVEY_ROLE_NAME = "imsurvey";


    //SQL queries
    //Insert queries
    private static final String ADD_FORM_ELEMENT = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements" +
            " (meta_id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, el_maxlength," +
            " el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type ) " +
            "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    private static final String ADD_FORM_ELEMENT_OPTION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements_options" +
            " (el_id, el_value, el_text, el_selected, el_sort, el_export_label) " +
            "VALUES (?, ?, ?, ?, ?, ?)";

    private static final String ADD_FORM_VALIDATION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_validation" +
            " (item_id, type, value, group_with) " +
            "VALUES (?, ?, ?, ?)";

    private static final String ADD_CONDITION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "conditions ( parent_question_id, question_id, all_values_required, text) VALUES (?, ?, ?, ?)";

    private static final String ADD_CONDITION_VALUE = "INSERT INTO " + FormEngine.TABLE_PREFIX + "condition_values ( condition_id, option_id ) VALUES (?,?)";

    private static final String ADD_SCRIVE_FIELD = "INSERT INTO " + FormEngine.TABLE_PREFIX + "element_scrive_fields ( element_id, template_id, field_name, oneflow_field ) VALUES (?,?,?,?)";

    private static final String ADD_SCRIVE_FIELD_OPTION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields(option_id, template_id, field_name) VALUES(?, ?, ?)";

    private static final String ADD_FORM_SETTING = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_settings (meta_id, id, setting) " +
            "VALUES (?, ?, ?)";

    //Select queries
    private static final String GET_SETTINGS = "SELECT id, setting FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";

    private static final String GET_FORM_ELEMENTS = "SELECT id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, " +
            "el_maxlength, el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, " +
            "depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type " +
            "FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";

    private static final String GET_FORM_ELEMENT_OPTIONS = "SELECT el_value, el_text, el_selected, el_sort, id, el_export_label " +
            "FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id = ?";

    private static final String GET_MAX_ID_FORM_ELEMENTS = "SELECT MAX(id) FROM " + FormEngine.TABLE_PREFIX + "form_elements";

    private static final String GET_FORM_VALIDATIONS = "SELECT type, value, group_with FROM " + FormEngine.TABLE_PREFIX + "form_validation WHERE item_id = ?";

    private static final String GET_OLD_DEPENDENCIES = "SELECT c.condition_id, c.parent_question_id, c.question_id, c.all_values_required, c.text " +
            "FROM " + FormEngine.TABLE_PREFIX + "conditions c LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON c.parent_question_id = e.id WHERE e.meta_id = ?";

    private static final String GET_OLD_DEPENDENCIES_OPTIONS = "SELECT v.condition_id, v.option_id, c.condition_id, c.question_id, e.id, e.meta_id " +
            "FROM " + FormEngine.TABLE_PREFIX + "condition_values v " +
            "LEFT JOIN " + FormEngine.TABLE_PREFIX + "conditions c ON v.condition_id = c.condition_id " +
            "LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON c.question_id = e.id " +
            "WHERE e.meta_id = ?";

    private static final String GET_OLD_FIELDS = "SELECT f.element_id, f.template_id, f.field_name, f.oneflow_field " +
            "FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields f " +
            "LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON f.element_id = e.id " +
            "WHERE e.meta_id = ?";

    //Delete queries
    private static final String DELETE_FORM_SETTING = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";

    private static final String DELETE_FORM_ELEMENTS = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id IN (SELECT id FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?)";

    private static final String DELETE_FORM_ELEMENTS_OPTIONS = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";


    public static void copySurvey(int from_meta, int meta_id, HttpServletRequest request, JspWriter out) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest(request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);

        TextDocument toDoc = documentService.getTextDocument(meta_id);
        TextDocument fromDoc = documentService.getTextDocument(from_meta);

        toDoc.setHtmlTextField((SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 301), fromDoc.getTextField(SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 301).getText());
        toDoc.setHtmlTextField((SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 302), fromDoc.getTextField(SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 302).getText());

        dbUtil.sqlUpdateQuery(DELETE_FORM_SETTING, new String[]{toDoc.getId() + ""});

        // Get new settings from selected form
        String[][] arrNewSettings = dbUtil.sqlQueryMulti(GET_SETTINGS, new String[]{String.valueOf(from_meta)});

        String oldMailFromElementId = "";
        // Insert new settings into this form
        if (arrNewSettings != null) {
            for (String[] arrNewSetting : arrNewSettings) {
                try {
                    String id = arrNewSetting[0];
                    String setting = arrNewSetting[1];

                    if (id.equals(FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "")) {
                        oldMailFromElementId = setting;
                        continue;
                    }

                    dbUtil.sqlUpdateQuery(ADD_FORM_SETTING, new String[]{toDoc.getId() + "", id, setting});
                } catch (Exception e) {
                    writeLog("Error inserting new settings: " + e.toString());
                }
            }
        }

        try {
            // Remove old form element options from this form
            dbUtil.sqlUpdateQuery(DELETE_FORM_ELEMENTS_OPTIONS, new String[]{toDoc.getId() + ""});

            // Remove old form elements from this form
            dbUtil.sqlUpdateQuery(DELETE_FORM_ELEMENTS, new String[]{toDoc.getId() + ""});
        } catch (Exception e) {
            writeLog("Error clearing out old elements or options: " + e.toString());
        }

        String[][] arrNewFormElements = null;

        try {
            // Get new form elements from selected form
            arrNewFormElements = dbUtil.sqlQueryMulti(GET_FORM_ELEMENTS, new String[]{String.valueOf(from_meta)});
        } catch (Exception e) {
            writeLog("Error getting old form elements: " + e.toString());
        }

        if (arrNewFormElements != null) {
            Map elementsMap = new HashMap<Integer, Integer>();
            Map conditionsMap = new HashMap<Integer, Integer>();
            Map optionsMap = new HashMap<Integer, Integer>();

            for (String[] arrNewFormElement : arrNewFormElements) {
                String id = arrNewFormElement[0];
                String el_type = arrNewFormElement[1];
                String el_sort = arrNewFormElement[2];
                String el_count = arrNewFormElement[3];
                String el_tablerows = arrNewFormElement[4];
                String el_size = arrNewFormElement[5];
                String el_rows = arrNewFormElement[6];
                String el_maxlength = arrNewFormElement[7];
                String el_multiple = arrNewFormElement[8];
                String el_label = arrNewFormElement[9];
                String el_label_fullwidth = arrNewFormElement[10];
                String tab_nbr = arrNewFormElement[11];

                String export_label = arrNewFormElement[12];
                String depends_on_show = arrNewFormElement[13];
                String depends_on_all_required = arrNewFormElement[14];

                String el_hidden_val = arrNewFormElement[15];
                String el_default_val = arrNewFormElement[16];
                String el_default_del = arrNewFormElement[17];
                String el_infotext = arrNewFormElement[18];
                String el_infotext_type = arrNewFormElement[19];

                try {
                    Connection connection = databaseService.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(ADD_FORM_ELEMENT, Statement.RETURN_GENERATED_KEYS);

                    preparedStatement.setInt(1, toDoc.getId());
                    preparedStatement.setString(2, el_type);
                    preparedStatement.setInt(3, Integer.parseInt(el_sort));
                    preparedStatement.setInt(4, Integer.parseInt(el_count));
                    preparedStatement.setInt(5, Integer.parseInt(el_tablerows));
                    preparedStatement.setInt(6, Integer.parseInt(el_size));
                    preparedStatement.setInt(7, Integer.parseInt(el_rows));
                    preparedStatement.setInt(8, Integer.parseInt(el_maxlength));
                    preparedStatement.setInt(9, Integer.parseInt((el_multiple.matches("true|1|-1") ? "1" : "0")));
                    preparedStatement.setString(10, el_label);
                    preparedStatement.setInt(11, Integer.parseInt(el_label_fullwidth.matches("true|1|-1") ? "1" : "0"));
                    preparedStatement.setString(12, tab_nbr);
                    preparedStatement.setString(13, export_label);
                    preparedStatement.setString(14, depends_on_show);
                    preparedStatement.setString(15, depends_on_all_required);
                    preparedStatement.setString(16, el_hidden_val);
                    preparedStatement.setString(17, el_default_val);
                    preparedStatement.setInt(18, el_default_del != null ? Integer.parseInt((el_default_del.matches("true|1|-1") ? "1" : "0")) : 0);
                    preparedStatement.setString(19, el_infotext);
                    preparedStatement.setInt(20, el_infotext_type != null ? Integer.parseInt((el_infotext_type.matches("true|1|-1") ? "1" : "0")) : 0);

                    preparedStatement.executeUpdate();

                    ResultSet resultSet = preparedStatement.getGeneratedKeys();
                    if (resultSet.next()) {
                        int newID = resultSet.getInt(1);

                        elementsMap.put(Integer.parseInt(id), newID);
                        if (oldMailFromElementId.equals(id)) {
                            dbUtil.sqlUpdateQuery(ADD_FORM_SETTING, new String[]{toDoc.getId() + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "", "" + newID});
                        }
                    }
                    resultSet.close();
                    preparedStatement.close();
                    connection.close();
                } catch (Exception e) {
                    writeLog("Error copying form elements: " + e.toString());
                    return;
                }

                try {
                    // Get new form element options from selected form item - If exists
                    String[][] arrNewFormElementsOptions = dbUtil.sqlQueryMulti(GET_FORM_ELEMENT_OPTIONS, new String[]{id});
                    if (arrNewFormElementsOptions != null && arrNewFormElementsOptions.length > 0) {
                        // Get new element-ID
                        String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);

                        for (String[] arrNewFormElementsOption : arrNewFormElementsOptions) {
                            try {
                                String op_value = arrNewFormElementsOption[0];
                                String op_text = arrNewFormElementsOption[1];
                                String op_selected = arrNewFormElementsOption[2];
                                String op_sort = arrNewFormElementsOption[3];
                                String op_id = arrNewFormElementsOption[4];
                                String op_export_label = arrNewFormElementsOption[5];
                                Connection connection = databaseService.getConnection();
                                PreparedStatement preparedStatement = connection.prepareStatement(ADD_FORM_ELEMENT_OPTION, Statement.RETURN_GENERATED_KEYS);

                                preparedStatement.setInt(1, Integer.parseInt(insertedElementId));
                                preparedStatement.setString(2, op_value);
                                preparedStatement.setString(3, op_text);
                                preparedStatement.setBoolean(4, (op_selected.matches("true|1|-1")));
                                preparedStatement.setInt(5, Integer.parseInt(op_sort));
                                preparedStatement.setString(6, op_export_label);

                                preparedStatement.executeUpdate();

                                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                                String s = "";
                                if (resultSet.next()) {
                                    int newID = resultSet.getInt(1);
                                    optionsMap.put(Integer.parseInt(arrNewFormElementsOption[4]), newID);

                                    String getOptionFields = "SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?";
                                    preparedStatement = connection.prepareStatement(getOptionFields);
                                    preparedStatement.setInt(1, Integer.parseInt(op_id));

                                    ResultSet scriveOptionFields = preparedStatement.executeQuery();
                                    preparedStatement = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields(option_id, template_id, field_name) VALUES(?, ?, ?)");
                                    while (scriveOptionFields.next()) {
                                        preparedStatement.setInt(1, newID);
                                        preparedStatement.setInt(2, scriveOptionFields.getInt("template_id"));
                                        preparedStatement.setString(3, scriveOptionFields.getString("field_name"));
                                        preparedStatement.addBatch();
                                    }
                                    preparedStatement.executeBatch();
                                    s += id + ", " + newID + "\n";
                                }
                                writeLog("optionsMap: " + s);
                                resultSet.close();
                                preparedStatement.close();
                                connection.close();
                            } catch (Exception e) {
                                writeLog("Error copying form element options: " + e.toString());
                                return;
                            }
                        }
                    }
                } catch (Exception e) {
                    writeLog("Error copying element options: " + e.toString());
                }

                try {
                    // Get new element-ID
                    String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);

                    // Get new validation from selected form
                    String[][] arrNewValidation = dbUtil.sqlQueryMulti(GET_FORM_VALIDATIONS, new String[]{id});

                    // Insert new validation into this form
                    if (arrNewValidation != null) {
                        for (String[] anArrNewValidation : arrNewValidation) {
                            String type = anArrNewValidation[0];
                            String value = anArrNewValidation[1];
                            String group_with = anArrNewValidation[2];

                            dbUtil.sqlUpdateQuery(ADD_FORM_VALIDATION, new String[]{insertedElementId, type, value, group_with});
                        }
                    }
                } catch (Exception e) {
                    writeLog("Error copying validation: " + e.toString());
                }
            }

            //Insert the new dependencies
            try {
                //List the old dependencies
                String[][] conditions = dbUtil.sqlQueryMulti(GET_OLD_DEPENDENCIES, new String[]{"" + from_meta});

                String s = "";
                for (String[] condition : conditions) {
                    s += "" + condition[0] + ", " + condition[1] + ", " + condition[2] + ", " + condition[3] + ", " + condition[4] + "\n";
                }
                writeLog("Old dependency conditions:\n" + s);
                s = "";

                //Insert the new dependencies
                for (String[] condition : conditions) {
                    try {
                        java.sql.Connection connection = databaseService.getConnection();
                        java.sql.PreparedStatement preparedStatement = connection.prepareStatement(ADD_CONDITION, java.sql.Statement.RETURN_GENERATED_KEYS);
                        writeLog("Inserting new condition: " + elementsMap.get(Integer.parseInt(condition[1])) + "," + elementsMap.get(Integer.parseInt(condition[2])) + "," +
                                condition[3] + ", " + condition[4]);
                        preparedStatement.setInt(1, (Integer) elementsMap.get(Integer.parseInt(condition[1])));
                        preparedStatement.setInt(2, (Integer) elementsMap.get(Integer.parseInt(condition[2])));
                        preparedStatement.setBoolean(3, condition[3] != null && condition[3].matches("true|1|-1"));
                        preparedStatement.setString(4, condition[4]);

                        preparedStatement.executeUpdate();

                        java.sql.ResultSet resultSet = preparedStatement.getGeneratedKeys();
                        if (resultSet.next()) {
                            int newID = resultSet.getInt(1);
                            conditionsMap.put(Integer.parseInt(condition[0]), newID);
                        }
                        resultSet.close();
                        preparedStatement.close();
                        connection.close();
                    } catch (Exception e) {
                        writeLog("Error inserting new conditions: " + e.toString());
                        return;
                    }
                }
            } catch (Exception e) {
                writeLog("Error updating dependencies: " + e.toString());
            }

            //Insert the new dependency options
            String s = "";
            try {
                //List the old dependency options
                String[][] options = dbUtil.sqlQueryMulti(GET_OLD_DEPENDENCIES_OPTIONS, new String[]{"" + from_meta});

                for (String[] option : options) {
                    s += "" + option[0] + ", " + option[1] + ", " + option[2] + ", " + option[3] + ", " + option[4] + ", " + option[5] + "\n";
                }
                writeLog("Old dependency options:\n" + s);
                s = "";
                for (String[] option : options) {
                    try {
                        String newCondition_id = "" + conditionsMap.get(Integer.parseInt(option[0]));
                        s += "Condition_id från " + option[0] + " -> " + newCondition_id + " ";

                        String newOption_id = "" + optionsMap.get(Integer.parseInt(option[1]));
                        s += " Option_id från " + option[1] + " -> " + newOption_id + "\n";

                        dbUtil.sqlUpdateQuery(ADD_CONDITION_VALUE, new String[]{newCondition_id, newOption_id});
                    } catch (Exception e) {
                        writeLog("Error inserting condition_value: " + e.toString());
                    }
                }
                writeLog("new dependency options: " + s);
            } catch (Exception e) {
                writeLog("new dependency options: " + s);
                writeLog("Error updating dependency options: " + e.toString());
            }

            //Insert oneflow fields
            try {
                //List the old oneflow fields
                String[][] fields = dbUtil.sqlQueryMulti(GET_OLD_FIELDS, new String[]{"" + from_meta});

                for (String[] field : fields) {
                    try {
                        String newElement_id = "" + elementsMap.get(Integer.parseInt(field[0]));
                        dbUtil.sqlUpdateQuery(ADD_SCRIVE_FIELD, new String[]{newElement_id, field[1], field[2], field[3]});
                    } catch (Exception e) {
                        writeLog("Error inserting oneflow field: " + e.toString());
                    }
                }
            } catch (Exception e) {
                writeLog("Error updating oneflow fields: " + e.toString());
            }
        }
        try {
            documentService.saveChanges(toDoc);
        } catch (Exception e) {
            writeLog("Error saving doc changes: " + e.toString());
        }
    }

    public static JsonObject exportSurvey(int from_meta, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest(request);
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        JsonObject formData = new JsonObject();
        try {
            connection = databaseService.getConnection();

            // Get new settings from selected form
            String[][] arrNewSettings = dbUtil.sqlQueryMulti(GET_SETTINGS, new String[]{String.valueOf(from_meta)});

            // Insert new settings into this form
            if (arrNewSettings != null) {
                JsonArray formSettings = new JsonArray();
                formData.add("settings", formSettings);
                for (String[] arrNewSetting : arrNewSettings) {
                    try {
                        JsonObject settingObject = new JsonObject();
                        String id = arrNewSetting[0];
                        String setting = arrNewSetting[1];

                        if (id.equals(FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "")) {
                            continue;
                        }
                        settingObject.addProperty("id", id);
                        settingObject.addProperty("setting", setting);
                        formSettings.add(settingObject);
                    } catch (Exception e) {
                        writeLog("Error inserting new settings: " + e.toString());
                    }
                }
            }

            String[][] arrNewFormElements = null;

            try {
                // Get new form elements from selected form
                arrNewFormElements = dbUtil.sqlQueryMulti(GET_FORM_ELEMENTS, new String[]{String.valueOf(from_meta)});
            } catch (Exception e) {
                writeLog("Error getting old form elements: " + e.toString());
            }

            if (arrNewFormElements != null) {
                JsonArray jsonElements = new JsonArray();
                JsonArray jsonValidations = new JsonArray();
                formData.add("elements", jsonElements);
                formData.add("validationRules", jsonValidations);
                for (String[] arrNewFormElement : arrNewFormElements) {
                    JsonObject elementObject = new JsonObject();
                    elementObject.addProperty("id", arrNewFormElement[0]);
                    elementObject.addProperty("el_type", arrNewFormElement[1]);
                    elementObject.addProperty("el_sort", arrNewFormElement[2]);
                    elementObject.addProperty("el_count", arrNewFormElement[3]);
                    elementObject.addProperty("el_tablerows", arrNewFormElement[4]);
                    elementObject.addProperty("el_size", arrNewFormElement[5]);
                    elementObject.addProperty("el_rows", arrNewFormElement[6]);
                    elementObject.addProperty("el_maxlength", arrNewFormElement[7]);
                    elementObject.addProperty("el_multiple", arrNewFormElement[8]);
                    elementObject.addProperty("el_label", arrNewFormElement[9]);
                    elementObject.addProperty("el_label_fullwidth", arrNewFormElement[10]);
                    elementObject.addProperty("tab_nbr", arrNewFormElement[11]);
                    elementObject.addProperty("export_label", arrNewFormElement[12]);
                    elementObject.addProperty("depends_on_show", arrNewFormElement[13]);
                    elementObject.addProperty("depends_on_all_required", arrNewFormElement[14]);
                    elementObject.addProperty("el_hidden_val", arrNewFormElement[15]);
                    elementObject.addProperty("el_default_val", arrNewFormElement[16]);
                    elementObject.addProperty("el_default_del", arrNewFormElement[17]);
                    elementObject.addProperty("el_infotext", arrNewFormElement[18]);
                    elementObject.addProperty("el_infotext_type", arrNewFormElement[19]);
                    jsonElements.add(elementObject);

                    String id = arrNewFormElement[0];

                    JsonArray elementOptions = new JsonArray();
                    elementObject.add("elementOptions", elementOptions);

                    try {
                        // Get new form element options from selected form item - If exists
                        String[][] arrNewFormElementsOptions = dbUtil.sqlQueryMulti(GET_FORM_ELEMENT_OPTIONS, new String[]{id});
                        if (arrNewFormElementsOptions != null && arrNewFormElementsOptions.length > 0) {
                            // Get new element-ID
                            for (String[] arrNewFormElementsOption : arrNewFormElementsOptions) {
                                try {
                                    JsonObject elementOption = new JsonObject();
                                    elementOption.addProperty("op_value", arrNewFormElementsOption[0]);
                                    elementOption.addProperty("op_text", arrNewFormElementsOption[1]);
                                    elementOption.addProperty("op_selected", arrNewFormElementsOption[2]);
                                    elementOption.addProperty("op_sort", arrNewFormElementsOption[3]);
                                    elementOption.addProperty("op_id", arrNewFormElementsOption[4]);
                                    elementOption.addProperty("op_export_label", arrNewFormElementsOption[5]);

                                    elementOptions.add(elementOption);

                                    JsonArray elementOptionScriveFields = new JsonArray();
                                    elementOption.add("optionScriveFields", elementOptionScriveFields);

                                    String getOptionFields = "SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?";
                                    preparedStatement = connection.prepareStatement(getOptionFields);
                                    preparedStatement.setInt(1, Integer.parseInt(arrNewFormElementsOption[4]));

                                    rs = preparedStatement.executeQuery();
                                    while (rs.next()) {
                                        JsonObject scriveOption = new JsonObject();
                                        scriveOption.addProperty("id", rs.getInt("id"));
                                        scriveOption.addProperty("option_id", rs.getInt("option_id"));
                                        scriveOption.addProperty("template_id", rs.getInt("template_id"));
                                        scriveOption.addProperty("field_name", rs.getString("field_name"));
                                        elementOptionScriveFields.add(scriveOption);
                                    }
                                } catch (Exception e) {
                                    writeLog("Error copying form element options: " + e.toString());
                                    return null;
                                }
                            }
                        }
                    } catch (Exception e) {
                        writeLog("Error copying element options: " + e.toString());
                    }

                    try {
                        // Get new element-ID
                        String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);

                        // Get new validation from selected form
                        String[][] arrNewValidation = dbUtil.sqlQueryMulti(GET_FORM_VALIDATIONS, new String[]{id});

                        // Insert new validation into this form
                        if (arrNewValidation != null) {
                            for (String[] anArrNewValidation : arrNewValidation) {
                                String type = anArrNewValidation[0];
                                String value = anArrNewValidation[1];
                                String group_with = anArrNewValidation[2];

                                JsonObject validationObject = new JsonObject();
                                validationObject.addProperty("item_id", id);
                                validationObject.addProperty("type", type);
                                validationObject.addProperty("value", value);
                                validationObject.addProperty("group_with", group_with);
                                jsonValidations.add(validationObject);
                            }
                        }
                    } catch (Exception e) {
                        writeLog("Error copying validation: " + e.toString());
                    }
                }

                //Insert the new dependencies
                try {
                    JsonArray oldDependenciesOptions = new JsonArray();
                    formData.add("dependices", oldDependenciesOptions);

                    //List the old dependencies
                    String[][] conditions = dbUtil.sqlQueryMulti(GET_OLD_DEPENDENCIES, new String[]{"" + from_meta});
//                String s = "";
//                for (String[] condition : conditions) {
//                    s += "" + condition[0] + ", " + condition[1] + ", " + condition[2] + ", " + condition[3] + ", " + condition[4] + "\n";
//                }
//                writeLog("Old dependency conditions:\n" + s);
                    writeLog("Old dependency conditions:\n");
//                s = "";

                    //Insert the new dependencies
                    for (String[] condition : conditions) {
                        try {
                            JsonObject oldDependency = new JsonObject();
                            oldDependency.addProperty("condition_id", condition[0]);
                            oldDependency.addProperty("parent_question_id", condition[1]);
                            oldDependency.addProperty("question_id", condition[2]);
                            oldDependency.addProperty("all_values_required", condition[3]);
                            oldDependency.addProperty("text", condition[4]);

                            oldDependenciesOptions.add(oldDependency);
                        } catch (Exception e) {
                            writeLog("Error inserting new conditions: " + e.toString());
                        }
                    }
                } catch (Exception e) {
                    writeLog("Error updating dependencies: " + e.toString());
                }

                //Insert the new dependency options
                String s = "";
                try {
                    JsonArray oldDependeciesOptionsValues = new JsonArray();
                    formData.add("dependicesOptions", oldDependeciesOptionsValues);

                    //List the old dependency option's
                    String[][] options = dbUtil.sqlQueryMulti(GET_OLD_DEPENDENCIES_OPTIONS, new String[]{"" + from_meta});

                    for (String[] option : options) {
                        s += "" + option[0] + ", " + option[1] + ", " + option[2] + ", " + option[3] + ", " + option[4] + ", " + option[5] + "\n";
                    }
                    writeLog("Old dependency options:\n" + s);
                    s = "";
                    for (String[] option : options) {
                        try {
                            JsonObject oldDependencyValue = new JsonObject();

                            oldDependencyValue.addProperty("condition_id", Integer.parseInt(option[0]));
                            oldDependencyValue.addProperty("option_id", Integer.parseInt(option[1]));
                            oldDependeciesOptionsValues.add(oldDependencyValue);
                        } catch (Exception e) {
                            writeLog("Error inserting condition_value: " + e.toString());
                        }
                    }
                    writeLog("new dependency options: " + s);
                } catch (Exception e) {
                    writeLog("new dependency options: " + s);
                    writeLog("Error updating dependency options: " + e.toString());
                }

                //Insert oneflow fields
                try {
                    JsonArray jsonFields = new JsonArray();
                    formData.add("fields", jsonFields);
                    //List the old oneflow fields
                    String[][] fields = dbUtil.sqlQueryMulti(GET_OLD_FIELDS, new String[]{"" + from_meta});

                    for (String[] field : fields) {
                        try {
                            JsonObject jsonField = new JsonObject();
                            jsonField.addProperty("element_id", field[0]);
                            jsonField.addProperty("template_id", field[1]);
                            jsonField.addProperty("field_name", field[2]);
                            jsonField.addProperty("oneflow_field", field[3]);
                            jsonFields.add(jsonField);
                        } catch (Exception e) {
                            writeLog("Error inserting oneflow field: " + e.toString());
                        }
                    }
                } catch (Exception e) {
                    writeLog("Error updating oneflow fields: " + e.toString());
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, preparedStatement, rs);
        }
        return formData;
    }

    public static boolean importSurvey(int toMetaId, MultipartHttpServletRequest request) {
        MultipartHttpServletRequest.DataSourceFileItem parameterFileItem = request.getParameterFileItem("file");

        if (parameterFileItem != null && parameterFileItem.getSize() >= 1L) {
            String fileName = parameterFileItem.getName();
            File file = new File("");
            JsonObject formData = new JsonObject();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet rs = null;
            try {
                String filePath = request.getRealPath("/tmp");
                // Write the file
                if (fileName.lastIndexOf("\\") >= 0) {
                    file = new File(filePath + "/" +
                            fileName.substring(fileName.lastIndexOf("\\")));
                } else {
                    file = new File(filePath + "/" +
                            fileName.substring(fileName.lastIndexOf("\\") + 1));
                }
                //Creating required file structure if now exists
                if (!file.getParentFile().exists()) {
                    if (!file.getParentFile().mkdirs()) {
                        throw new IOException("Unable to create required folder");
                    }
                }
                parameterFileItem.write(file);

                JsonParser parser = new JsonParser();
                JsonElement jsonFormData = parser.parse(new FileReader(file));
                formData = jsonFormData.getAsJsonObject();

                ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest(request);
                DocumentService documentService = imcmsSystem.getDocumentService();
                DatabaseService databaseService = imcmsSystem.getDatabaseService();
                DBUtil dbUtil = new DBUtil(databaseService);
                connection = databaseService.getConnection();
                TextDocument toDoc = documentService.getTextDocument(toMetaId);

                dbUtil.sqlUpdateQuery(DELETE_FORM_SETTING, new String[]{toDoc.getId() + ""});

                // Get new settings from selected form
                JsonArray formSettings = formData.get("settings").getAsJsonArray();
                String oldMailFromElementId = "";
                // Insert new settings into this form
                if (formSettings != null) {
                    for (JsonElement formSetting : formSettings) {
                        try {
                            String id = ((JsonObject) formSetting).get("id").getAsString();
                            String setting = ((JsonObject) formSetting).get("setting").getAsString();

                            if (id.equals(FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "")) {
                                oldMailFromElementId = setting;
                                continue;
                            }
                            dbUtil.sqlUpdateQuery(ADD_FORM_SETTING, new String[]{toDoc.getId() + "", id, setting});
                        } catch (Exception e) {
                            writeLog("Error inserting new settings: " + e.toString());
                        }
                    }
                }

                try {
                    // Remove old form element options from this form
                    dbUtil.sqlUpdateQuery(DELETE_FORM_ELEMENTS, new String[]{toDoc.getId() + ""});

                    // Remove old form elements from this form
                    dbUtil.sqlUpdateQuery(DELETE_FORM_ELEMENTS_OPTIONS, new String[]{toDoc.getId() + ""});
                } catch (Exception e) {
                    writeLog("Error clearing out old elements or options: " + e.toString());
                }

                JsonArray jsonElements = formData.get("elements").getAsJsonArray();
                if (jsonElements != null) {
                    Map elementsMap = new HashMap<Integer, Integer>();
                    Map conditionsMap = new HashMap<Integer, Integer>();
                    Map optionsMap = new HashMap<Integer, Integer>();
                    int newFieldId = 0;

                    for (JsonElement jsonElement : jsonElements) {
                        JsonObject elementObject = jsonElement.getAsJsonObject();
                        String id = elementObject.get("id").getAsString();
                        String el_type = elementObject.get("el_type").getAsString();
                        String el_sort = elementObject.get("el_sort").getAsString();
                        String el_count = elementObject.get("el_count").getAsString();
                        String el_tablerows = elementObject.get("el_tablerows").getAsString();
                        String el_size = elementObject.get("el_size").getAsString();
                        String el_rows = elementObject.get("el_rows").getAsString();
                        String el_maxlength = elementObject.get("el_maxlength").getAsString();
                        String el_multiple = elementObject.get("el_multiple").getAsString();
                        String el_label = elementObject.get("el_label").getAsString();
                        String el_label_fullwidth = elementObject.get("el_label_fullwidth").getAsString();
                        String tab_nbr = elementObject.get("tab_nbr").getAsString();

                        String export_label = elementObject.get("export_label").getAsString();
                        String depends_on_show = elementObject.get("depends_on_show").getAsString();
                        String depends_on_all_required = elementObject.get("depends_on_all_required").getAsString();

                        String el_hidden_val = elementObject.get("el_hidden_val").getAsString();
                        String el_default_val = elementObject.get("el_default_val").getAsString();
                        String el_default_del = elementObject.get("el_default_del").getAsString();
                        String el_infotext = elementObject.get("el_infotext").isJsonNull() ? null : elementObject.get("el_infotext").getAsString();
                        String el_infotext_type = elementObject.get("el_infotext_type").getAsString();

                        try {
                            preparedStatement = connection.prepareStatement(ADD_FORM_ELEMENT, java.sql.Statement.RETURN_GENERATED_KEYS);

                            preparedStatement.setInt(1, toDoc.getId());
                            preparedStatement.setString(2, el_type);
                            preparedStatement.setInt(3, Integer.parseInt(el_sort));
                            preparedStatement.setInt(4, Integer.parseInt(el_count));
                            preparedStatement.setInt(5, Integer.parseInt(el_tablerows));
                            preparedStatement.setInt(6, Integer.parseInt(el_size));
                            preparedStatement.setInt(7, Integer.parseInt(el_rows));
                            preparedStatement.setInt(8, Integer.parseInt(el_maxlength));
                            preparedStatement.setInt(9, Integer.parseInt((el_multiple.matches("true|1|-1") ? "1" : "0")));
                            preparedStatement.setString(10, el_label);
                            preparedStatement.setInt(11, Integer.parseInt(el_label_fullwidth.matches("true|1|-1") ? "1" : "0"));
                            preparedStatement.setString(12, tab_nbr);
                            preparedStatement.setString(13, export_label);
                            preparedStatement.setString(14, depends_on_show);
                            preparedStatement.setString(15, depends_on_all_required);
                            preparedStatement.setString(16, el_hidden_val);
                            preparedStatement.setString(17, el_default_val);
                            preparedStatement.setInt(18, el_default_del != null ? Integer.parseInt((el_default_del.matches("true|1|-1") ? "1" : "0")) : 0);
                            preparedStatement.setString(19, el_infotext);
                            preparedStatement.setInt(20, el_infotext_type != null ? Integer.parseInt((el_infotext_type.matches("true|1|-1") ? "1" : "0")) : 0);

                            preparedStatement.executeUpdate();
                            rs = preparedStatement.getGeneratedKeys();
                            if (rs.next()) {
                                newFieldId = rs.getInt(1);
                                elementsMap.put(Integer.parseInt(id), newFieldId);

//                                elementsMap.put(Integer.parseInt(id), newID);
                                if (oldMailFromElementId.equals(id)) {
                                    dbUtil.sqlUpdateQuery(ADD_FORM_SETTING, new String[]{toDoc.getId() + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "", "" + newFieldId});
                                }
                            }
                        } catch (Exception e) {
                            writeLog("Error copying form elements: " + e.toString());
                            e.printStackTrace();
                            return false;
                        }

                        try {
                            JsonArray jsonOptions = elementObject.get("elementOptions").getAsJsonArray();

                            if (jsonOptions != null) {
                                // Get new element-ID
                                String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);

                                for (JsonElement jsonOption : jsonOptions) {
                                    try {
                                        JsonObject optionObject = jsonOption.getAsJsonObject();
                                        String op_value = optionObject.get("op_value").getAsString();
                                        String op_text = optionObject.get("op_text").getAsString();
                                        String op_selected = optionObject.get("op_selected").getAsString();
                                        String op_sort = optionObject.get("op_sort").getAsString();
                                        String op_id = optionObject.get("op_id").getAsString();
                                        String op_export_label = optionObject.get("op_value").getAsString();
                                        preparedStatement = connection.prepareStatement(ADD_FORM_ELEMENT_OPTION, java.sql.Statement.RETURN_GENERATED_KEYS);

                                        preparedStatement.setInt(1, Integer.parseInt(insertedElementId));
                                        preparedStatement.setString(2, op_value);
                                        preparedStatement.setString(3, op_text);
                                        preparedStatement.setBoolean(4, (op_selected.matches("true|1|-1")));
                                        preparedStatement.setInt(5, Integer.parseInt(op_sort));
                                        preparedStatement.setString(6, op_export_label);

                                        preparedStatement.executeUpdate();

                                        rs = preparedStatement.getGeneratedKeys();
                                        String s = "";
                                        if (rs.next()) {
                                            int newID = rs.getInt(1);
                                            optionsMap.put(Integer.parseInt(op_id), newID);

                                            JsonArray jsonScriveOptions = optionObject.get("optionScriveFields").getAsJsonArray();

                                            preparedStatement = connection.prepareStatement(ADD_SCRIVE_FIELD_OPTION);
                                            for (JsonElement scriveOption : jsonScriveOptions) {
                                                JsonObject scriveOptionObject = scriveOption.getAsJsonObject();
                                                preparedStatement.setInt(1, newID);
                                                preparedStatement.setInt(2, scriveOptionObject.get("template_id").getAsInt());
                                                preparedStatement.setString(3, scriveOptionObject.get("field_name").getAsString());
                                                preparedStatement.addBatch();
                                            }
                                            preparedStatement.executeBatch();
                                            s += op_id + ", " + newID + "\n";
                                        }
                                        writeLog("optionsMap: " + s);
//                                        resultSet.close();
//                                        preparedStatement.close();
                                    } catch (Exception e) {
                                        writeLog("Error copying form element options: " + e.toString());
                                        e.printStackTrace();
                                        return false;
                                    }
                                }
                            }
                        } catch (Exception e) {
                            writeLog("Error copying element options: " + e.toString());
                            e.printStackTrace();
                        }
                    }
                        try {
                            // Get new element-ID
                            String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);

                            // Get new validation from selected form
                            JsonArray jsonValidations = formData.get("validationRules").getAsJsonArray();

                            // Insert new validation into this form
                            if (jsonValidations != null) {
                                for (JsonElement jsonValidation : jsonValidations) {
                                    preparedStatement = connection.prepareStatement(ADD_FORM_VALIDATION);

                                    JsonObject validationObject = jsonValidation.getAsJsonObject();
                                    String type = validationObject.get("type").getAsString();
                                    String value = validationObject.get("value").getAsString();
                                    String group_with = validationObject.get("group_with").getAsString();

                                    preparedStatement.setInt(1, (Integer) elementsMap.get(validationObject.get("item_id").getAsInt()));
                                    preparedStatement.setString(2, type);
                                    preparedStatement.setString(3, value);
                                    preparedStatement.setString(4, group_with);
                                    preparedStatement.executeUpdate();
                                }
                            }
                        } catch (Exception e) {
                            writeLog("Error copying validation: " + e.toString());
                            e.printStackTrace();
                            return false;
                        }

                    //Insert the new dependencies
                    try {
                        //List the old dependencies
                        JsonArray jsonDependecies = formData.get("dependices").getAsJsonArray();

                        String s = "";
//                        for(String[] condition:conditions){
//                            s+="" + condition[0] + ", " + condition[1] + ", " + condition[2] + ", " + condition[3] + ", " + condition[4] + "\n";
//                        }
//                        writeLog("Old dependency conditions:\n" + s);
                        s = "";

                        //Insert the new dependencies
                        for (JsonElement jsonDependency : jsonDependecies) {
                            JsonObject dependencyObject = jsonDependency.getAsJsonObject();
                            try {
                                preparedStatement = connection.prepareStatement(ADD_CONDITION, java.sql.Statement.RETURN_GENERATED_KEYS);
//                                writeLog("Inserting new condition: " + elementsMap.get(Integer.parseInt(dependencyObject.get("condition_id").getAsString())) + "," + elementsMap.get(Integer.parseInt(dependencyObject.get("parent_question_id").getAsString())) + "," +
//                                        dependencyObject.get("ll_values_required").getAsString() + ", " + dependencyObject.get("text").getAsString());
                                preparedStatement.setInt(1, (Integer) elementsMap.get(dependencyObject.get("parent_question_id").getAsInt()));
                                preparedStatement.setInt(2, (Integer) elementsMap.get(dependencyObject.get("question_id").getAsInt()));
                                preparedStatement.setBoolean(3, !dependencyObject.get("all_values_required").isJsonNull() && dependencyObject.get("all_values_required").getAsString().matches("true|1|-1"));
                                preparedStatement.setString(4, dependencyObject.get("text").isJsonNull() ? null : dependencyObject.get("text").getAsString());
                                preparedStatement.executeUpdate();

                                rs = preparedStatement.getGeneratedKeys();
                                if (rs.next()) {
                                    int newID = rs.getInt(1);
                                    conditionsMap.put(Integer.parseInt(dependencyObject.get("condition_id").getAsString()), newID);
                                }
                            } catch (Exception e) {
                                writeLog("Error inserting new conditions: " + e.toString());
                                e.printStackTrace();
                                return false;
                            }
                        }
                    } catch (Exception e) {
                        writeLog("Error updating dependencies: " + e.toString());
                        e.printStackTrace();
                        return false;
                    }

                    //Insert the new dependency options
                    String s = "";
                    try {
                        //List the old dependency options

                        JsonArray jsonOldDependeciesOptions = formData.get("dependicesOptions").getAsJsonArray();

                        writeLog("Old dependency options:\n" + s);
                        s = "";
                        for (JsonElement jsonOldeDependencyOption : jsonOldDependeciesOptions) {
                            JsonObject olderDependencyOptionObject = jsonOldeDependencyOption.getAsJsonObject();
                            try {
                                String newCondition_id = "" + conditionsMap.get(Integer.parseInt(olderDependencyOptionObject.get("condition_id").getAsString()));
//                                s += "Condition_id från " + olderDependencyOptionObject.get("condition_id").getAsString() + " -> " + newCondition_id + " ";

                                String newOption_id = "" + optionsMap.get(Integer.parseInt(olderDependencyOptionObject.get("option_id").getAsString()));
//                                s += " Option_id från " + olderDependencyOptionObject.get("option_id").getAsString() + " -> " + newOption_id + "\n";

                                if (!newCondition_id.equals("null") && !newOption_id.equals("null")) {
                                    dbUtil.sqlUpdateQuery(ADD_CONDITION_VALUE, new String[]{newCondition_id, newOption_id});
                                }
                            } catch (Exception e) {
                                writeLog("Error inserting condition_value: " + e.toString());
                                e.printStackTrace();
                                return false;
                            }
                        }
                        writeLog("new dependency options: " + s);

                    } catch (Exception e) {
                        writeLog("new dependency options: " + s);
                        writeLog("Error updating dependency options: " + e.toString());
                        e.printStackTrace();
                        return false;
                    }

                    //Insert oneflow fields
                    try {
                        JsonArray jsonFields = formData.get("fields").getAsJsonArray();
                        //List the old oneflow fields
                        for (JsonElement jsonField : jsonFields) {
                            JsonObject fieldObject = jsonField.getAsJsonObject();
                            try {
                                String newElement_id = "" + elementsMap.get(Integer.parseInt(fieldObject.get("element_id").getAsString()));
                                dbUtil.sqlUpdateQuery(ADD_SCRIVE_FIELD, new String[]{newElement_id, fieldObject.get("template_id").getAsString(), fieldObject.get("field_name").getAsString(), fieldObject.get("oneflow_field").getAsString()});
                            } catch (Exception e) {
                                writeLog("Error inserting oneflow field: " + e.toString());
                            }
                        }

                    } catch (Exception e) {
                        writeLog("Error updating oneflow fields: " + e.toString());
                        e.printStackTrace();
                        return false;
                    }
                }
                try {
                    documentService.saveChanges(toDoc);
                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            } catch (Exception e) {
                e.printStackTrace();
                file.delete();
                return false;
            } finally {
                DbUtils.closeQuietly(connection, preparedStatement, rs);
                file.delete();
            }
        }
        return true;
    }

    /* TODO: delegate to client implementation */

    public static Role getClientAdminRole(UserService userService) {
        return userService.getRole("kund_admin");
    }

    /* TODO: delegate to client implementation */
    public static Role getServiceAdminRole(UserService userService) {
        return userService.getRole("service_admin_imsurvey");
    }

    public static boolean canAdminster(User user, UserService userService) {
        Role clientAdminRole = getClientAdminRole(userService);
        Role serviceAdminRole = getServiceAdminRole(userService);
        return user.isSuperAdmin() || (clientAdminRole != null && user.hasRole(clientAdminRole)) || (serviceAdminRole != null && user.hasRole(getServiceAdminRole(userService)));
    }

    /* TODO: delegate to client implementation */
    public static CategoryType getClientCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(CLIENT_CATEGORY_TYPE_NAME);
    }

    /* TODO: delegate to client implementation */
    public static CategoryType getSurveyCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(ACCOUNT_CATEGORY_TYPE_NAME);
    }

    /* TODO: delegate to client implementation */
    public static CategoryType getServiceCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(SERVICE_CATEGORY_TYPE_NAME);
    }

    /* TODO: delegate to client implementation */
    public static Category getSurveyCategory(DocumentService documentService) {
        return documentService.getCategory(getServiceCategoryType(documentService), "imsurvey");
    }

    /* TODO: delegate to client implementation */
    public static TextDocument getSurveyDocument(DocumentService documentService) {
        return documentService.getTextDocument("imsurvey");
    }

    /* TODO: delegate to client implementation */
    public static Template getSurveyTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_TEMPLATE_NAME);
    }

    public static Template getSurveyAdminTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_ADMIN_TEMPLATE_NAME);
    }

    public static CategoryType getFormCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(FORM_CATEGORY_NAME);
    }

    public static Category getFormCategory(DocumentService documentService) {
        CategoryType formCategoryType = getFormCategoryType(documentService);
        if (formCategoryType == null) {
            return null;
        }

        return documentService.getCategory(formCategoryType, FORM_CATEGORY_NAME);
    }

    public static Map<String, List<String>> getTemplateFields(HttpServletRequest request) {
        Map<String, List<String>> templateFields = new HashMap<String, List<String>>();

        String[] templateIds = request.getParameterValues("scrive_template");
        String[] fieldNames = request.getParameterValues("scrive_field");
        String[] fieldTypes = request.getParameterValues("el_type");
        String fieldType = fieldTypes != null ? fieldTypes[0] : "";

        String[] userIds = request.getParameterValues("scrive_field_user");

        if (templateIds != null) {
            for (String templateId : templateIds) {
                if (StringUtils.isBlank(templateId)) {
                    continue;
                }
                List<String> fields = templateFields.get(templateId);
                if (fields == null) {
                    fields = new ArrayList<String>();
                    templateFields.put(templateId, fields);
                }
                if (fieldNames != null) {
                    Pattern fieldPattern = Pattern.compile(templateId + "_(.+)");
                    int i = 0;
                    for (String fieldName : fieldNames) {
                        Matcher matcher = fieldPattern.matcher(fieldName);
                        if (fieldType.equals("scrive_button")) {
                            fieldPattern = Pattern.compile("_(.+)");
                            matcher = fieldPattern.matcher(fieldName);
                            if (matcher.find()) {
                                String agreementId = fieldNames[0].substring(0, matcher.start());
                                if (!fields.contains(agreementId)) {
                                    fields.add(agreementId);
                                }
                            }
                        } else {
                            if (matcher.matches()) {
                                String scriveFieldName = matcher.group(1);
                                if (!fields.contains(scriveFieldName)) {
                                    String userId = userIds != null ? userIds[i] : "";
                                    if (!userId.isEmpty()) {
                                        if (!fields.contains("user_" + userId + "_" + scriveFieldName)) {
                                            fields.add("user_" + userId + "_" + scriveFieldName);
                                        }
                                    } else {
                                        fields.add(scriveFieldName);
                                    }
                                }
                            }
                        }
                        i++;
                    }
                }

                String signMethod = request.getParameter("scrive_field_sign");
                String deliveryChannel = request.getParameter("scrive_field_delivery");

                if (null != signMethod && !signMethod.isEmpty()) {
                    fields.add(SignMethod.class.getSimpleName() + "_" + SignMethod.valueOf(signMethod.substring(signMethod.indexOf('_') + 1)).name());
                }

                if (null != deliveryChannel && !deliveryChannel.isEmpty()) {
                    fields.add(DeliveryChannel.class.getSimpleName() + "_" + DeliveryChannel.valueOf(deliveryChannel.substring(deliveryChannel.indexOf('_') + 1)).name());
                }
            }
        }

        return templateFields;
    }

    public static void writeLog(String str) {
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "imSurvey_sms_send_log.txt").getAbsoluteFile();

        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            } catch (Exception e) {
                return;
            }
        }
        java.io.FileOutputStream fos;
        try {
            fos = new java.io.FileOutputStream(log_file, true);
        } catch (java.io.FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());

        if (!str.equals(""))
            str = logDate + " " + str + "\n";
        else
            str = "\n";

        try {
            fos.write(str.getBytes());
        } catch (Exception e) {
            return;
        }
        try {
            fos.close();
        } catch (Exception e) {
            return;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc,
                                   javax.activation.DataSource[] att, ContentManagementSystem imcmsSystem, boolean htmlMail) {
        writeLog("Sending email: " + to[0]);
        try {
            MailService mailService = imcmsSystem.getMailService();
            Mail mail = new Mail(from, to, subject, body);
            if (htmlMail) {
                mail.setHtmlBody(body);
            }
            if (cc != null && cc.length > 0 && !cc[0].equals("")) mail.setCcAddresses(cc);
            if (bcc != null && bcc.length > 0 && !bcc[0].equals("")) mail.setBccAddresses(bcc);
            if (att != null && att.length > 0) mail.setAttachments(att);
            mailService.sendMail(mail);
            return true;
        } catch (Exception ex) {
            writeLog("mailexception= " + ex.getMessage());
            writeLog("from= " + from + " to = " + to[0] + " subject= " + subject + " body= " + body);
            return false;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc, javax.activation.DataSource[] att, ContentManagementSystem imcmsSystem) {
        return sendMail(from, to, subject, body, cc, bcc, att, imcmsSystem, false);
    }

    public static void notifyAbouScriveOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest(request);

        String from = settings.getMailFrom();
        String[] to = {settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty(settings.getScriveOutOfSyncSubject(), "Survey out of sync with Scrive: "));
        subject.append(" ").append(surveyId);

        String linkToSurvey = getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(createLink(linkToSurvey, linkToSurvey));
        sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static void notifyAbouOneflowOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest(request);

        String from = settings.getMailFrom();
        String[] to = {settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty(settings.getScriveOutOfSyncSubject(), "Survey out of sync with Oneflow: "));
        subject.append(" ").append(surveyId);

        String linkToSurvey = getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(createLink(linkToSurvey, linkToSurvey));
        sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static String getBaseURL(HttpServletRequest request) {
        boolean isLocalhost = "localhost".equals(request.getServerName());
        return request.getScheme() + "://" + request.getServerName() + (isLocalhost ? ":" + request.getServerPort() : "") + request.getContextPath();
    }

    public static String createLink(String href, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href='").append(href).append("'>");
        sb.append(text);
        sb.append("</a>");

        return sb.toString();
    }

    @SuppressWarnings("unchecked")
    public static String getTemplateIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveButtonPattern = Pattern.compile("scrive_button_(.+)");
        Map<String, String[]> params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveButtonPattern.matcher(name);
            if (matcher.matches()) {
                templateId = matcher.group(1);
                break;
            }
        }
        return templateId;
    }

    @SuppressWarnings("unchecked")
    public static String getTemplateGroupIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveHiddenPattern = Pattern.compile("scrive_([0-9]+)_([0-9]+)");
        Map<String, String[]> params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveHiddenPattern.matcher(name);
            if (matcher.matches()) {
                templateId = matcher.group(1);
                break;
            }
        }
        return templateId;
    }

    @SuppressWarnings("unchecked")
    public static Map<String, String> getFieldValuesForTemplate(String templateId, ServletRequest request) {
//       TODO: check if new pattern works with scrive API
        Pattern scriveFieldParamPattern = Pattern.compile("scrive_([0-9]+)_(.+)");
        if (!StringUtils.isBlank(templateId)) {
            Map<String, String[]> params = request.getParameterMap();
            Map<String, String> scriveParams = new HashMap<String, String>();

            for (String name : params.keySet()) {
                Matcher matcher = scriveFieldParamPattern.matcher(name);
                if (matcher.matches()) {
                    String fieldTemplateId = matcher.group(1);
                    String fieldName = matcher.group(2);
                    String value = params.get(name)[0];

                    if (templateId.equals(fieldTemplateId)) {
                        scriveParams.put(fieldName, value);
                    }
                }
            }

            return scriveParams;
        }

        return null;
    }

    @SuppressWarnings("unchecked")
    public static Map<String, String> getScriveFieldsFromDb(String templateId, ServletRequest request) {
        /* Reuires changes to the way form engine renders checkboxes and radio button(use of option id as value instead of text) */
        throw new UnsupportedOperationException("Not implemented");
//        Pattern textFieldPattern = Pattern.compile("formField(\\d+)");
//        Pattern checkboxPattern = Pattern.compile("cbField(\\d+)");
//        Pattern radionPattarn = Pattern.compile("radioField(\\d+)");
//
//        if (!StringUtils.isBlank(templateId)) {
//            Map<String, String[]> params = request.getParameterMap();
//            Map<String, String> scriveParams = new HashMap<String, String>();
//
//            for(String name: params.keySet()) {
//
//            }
//        }

    }

    public static Properties getProperties() {
        Properties prop = new Properties();
        InputStream input = null;
        try {
            input = new FileInputStream("server.properties");
            prop.load(input);
        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
            if (input != null) {
                try {
                    input.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return prop;
        }
    }

    public static API getAPI(String stringValue) {
        if (stringValue.equals(API.ONEFLOW.toString())) {
            return API.ONEFLOW;
        } else {
            return API.SCRIVE;
        }
    }
}