/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey;

import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.addon.imsurvey.FormEngine;
import com.imcode.imcms.addon.imsurvey.FormEngineSettings;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.utils.API;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Mail;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.Template;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static final String ACCOUNT_CATEGORY_TYPE_NAME = "imSurvey_AccountCategories";
    public static final String CLIENT_CATEGORY_TYPE_NAME = "client";
    public static final String SERVICE_CATEGORY_TYPE_NAME = "service";
    public static final String SURVEY_TEMPLATE_NAME = "imsurvey_surveypage_babs";
    public static final String SURVEY_ADMIN_TEMPLATE_NAME = "service_imsurvey";
    public static final String SURVEY_ADMIN_PAGE_ALIAS = "imsurvey";
    public static final String FORM_CATEGORY_NAME = "imSurvey_surveypage";
    public static final String IMSURVEY_ROLE_NAME = "imsurvey";

    public static void copySurvey(int from_meta, int meta_id, HttpServletRequest request, JspWriter out) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        TextDocument toDoc = documentService.getTextDocument(meta_id);
        TextDocument fromDoc = documentService.getTextDocument(from_meta);
        toDoc.setHtmlTextField(6301, fromDoc.getTextField(6301).getText());
        toDoc.setHtmlTextField(6302, fromDoc.getTextField(6302).getText());
        String sql = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";
        dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{toDoc.getId() + ""});
        sql = "SELECT id, setting FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";
        String[][] arrNewSettings = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{String.valueOf(from_meta)});
        String oldMailFromElementId = "";
        if (arrNewSettings != null) {
            for (int i = 0; i < arrNewSettings.length; ++i) {
                try {
                    String id = arrNewSettings[i][0];
                    String setting = arrNewSettings[i][1];
                    if (id.equals("205")) {
                        oldMailFromElementId = setting;
                        continue;
                    }
                    sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_settings (meta_id, id, setting) VALUES (?, ?, ?)";
                    dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{toDoc.getId() + "", id, setting});
                    continue;
                }
                catch (Exception e) {
                    Utils.writeLog("Error inserting new settings: " + e.toString());
                }
            }
        }
        try {
            sql = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id IN (SELECT id FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?)";
            dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{toDoc.getId() + ""});
            sql = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";
            dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{toDoc.getId() + ""});
        }
        catch (Exception e) {
            Utils.writeLog("Error clearing out old elements or options: " + e.toString());
        }
        String[][] arrNewFormElements = null;
        try {
            sql = "SELECT id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, el_maxlength, el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";
            arrNewFormElements = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{String.valueOf(from_meta)});
        }
        catch (Exception e) {
            Utils.writeLog("Error getting old form elements: " + e.toString());
        }
        if (arrNewFormElements != null) {
            HashMap<Integer, Integer> elementsMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> conditionsMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> optionsMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < arrNewFormElements.length; ++i) {
                String id = arrNewFormElements[i][0];
                String el_type = arrNewFormElements[i][1];
                String el_sort = arrNewFormElements[i][2];
                String el_count = arrNewFormElements[i][3];
                String el_tablerows = arrNewFormElements[i][4];
                String el_size = arrNewFormElements[i][5];
                String el_rows = arrNewFormElements[i][6];
                String el_maxlength = arrNewFormElements[i][7];
                String el_multiple = arrNewFormElements[i][8];
                String el_label = arrNewFormElements[i][9];
                String el_label_fullwidth = arrNewFormElements[i][10];
                String tab_nbr = arrNewFormElements[i][11];
                String export_label = arrNewFormElements[i][12];
                String depends_on_show = arrNewFormElements[i][13];
                String depends_on_all_required = arrNewFormElements[i][14];
                String el_hidden_val = arrNewFormElements[i][15];
                String el_default_val = arrNewFormElements[i][16];
                String el_default_del = arrNewFormElements[i][17];
                String el_infotext = arrNewFormElements[i][18];
                String el_infotext_type = arrNewFormElements[i][19];
                sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements (meta_id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, el_maxlength, el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                try {
                    Connection connection = databaseService.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
                    preparedStatement.setInt(1, toDoc.getId());
                    preparedStatement.setString(2, el_type);
                    preparedStatement.setInt(3, Integer.parseInt(el_sort));
                    preparedStatement.setInt(4, Integer.parseInt(el_count));
                    preparedStatement.setInt(5, Integer.parseInt(el_tablerows));
                    preparedStatement.setInt(6, Integer.parseInt(el_size));
                    preparedStatement.setInt(7, Integer.parseInt(el_rows));
                    preparedStatement.setInt(8, Integer.parseInt(el_maxlength));
                    preparedStatement.setInt(9, Integer.parseInt(el_multiple.matches("true|1|-1") ? "1" : "0"));
                    preparedStatement.setString(10, el_label);
                    preparedStatement.setInt(11, Integer.parseInt(el_label_fullwidth.matches("true|1|-1") ? "1" : "0"));
                    preparedStatement.setString(12, tab_nbr);
                    preparedStatement.setString(13, export_label);
                    preparedStatement.setString(14, depends_on_show);
                    preparedStatement.setString(15, depends_on_all_required);
                    preparedStatement.setString(16, el_hidden_val);
                    preparedStatement.setString(17, el_default_val);
                    preparedStatement.setInt(18, el_default_del != null ? Integer.parseInt(el_default_del.matches("true|1|-1") ? "1" : "0") : 0);
                    preparedStatement.setString(19, el_infotext);
                    preparedStatement.setInt(20, el_infotext_type != null ? Integer.parseInt(el_infotext_type.matches("true|1|-1") ? "1" : "0") : 0);
                    preparedStatement.executeUpdate();
                    ResultSet resultSet = preparedStatement.getGeneratedKeys();
                    if (resultSet.next()) {
                        int newID = resultSet.getInt(1);
                        elementsMap.put(Integer.parseInt(id), newID);
                        if (oldMailFromElementId.equals(id)) {
                            sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_settings (meta_id, id, setting) VALUES (?, ?, ?)";
                            dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{toDoc.getId() + "", "205", "" + newID});
                        }
                    }
                    resultSet.close();
                    preparedStatement.close();
                    connection.close();
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying form elements: " + e.toString());
                    return;
                }
                try {
                    sql = "SELECT el_value, el_text, el_selected, el_sort, id, el_export_label FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id = ?";
                    String[][] arrNewFormElementsOptions = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{id});
                    if (arrNewFormElementsOptions != null && arrNewFormElementsOptions.length > 0) {
                        sql = "SELECT MAX(id) FROM " + FormEngine.TABLE_PREFIX + "form_elements";
                        String insertedElementId = dbUtil.sqlQueryStr(sql, new Object[0]);
                        for (int j = 0; j < arrNewFormElementsOptions.length; ++j) {
                            try {
                                String op_value = arrNewFormElementsOptions[j][0];
                                String op_text = arrNewFormElementsOptions[j][1];
                                String op_selected = arrNewFormElementsOptions[j][2];
                                String op_sort = arrNewFormElementsOptions[j][3];
                                String op_id = arrNewFormElementsOptions[j][4];
                                String op_export_label = arrNewFormElementsOptions[j][5];
                                sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements_options (el_id, el_value, el_text, el_selected, el_sort, el_export_label) VALUES (?, ?, ?, ?, ?, ?)";
                                Connection connection = databaseService.getConnection();
                                PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
                                preparedStatement.setInt(1, Integer.parseInt(insertedElementId));
                                preparedStatement.setString(2, op_value);
                                preparedStatement.setString(3, op_text);
                                preparedStatement.setBoolean(4, op_selected.matches("true|1|-1"));
                                preparedStatement.setInt(5, Integer.parseInt(op_sort));
                                preparedStatement.setString(6, op_export_label);
                                preparedStatement.executeUpdate();
                                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                                String s = "";
                                if (resultSet.next()) {
                                    int newID = resultSet.getInt(1);
                                    optionsMap.put(Integer.parseInt(arrNewFormElementsOptions[j][4]), newID);
                                    String getOptionFields = "SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?";
                                    preparedStatement = connection.prepareStatement(getOptionFields);
                                    preparedStatement.setInt(1, Integer.parseInt(op_id));
                                    ResultSet scriveOptionFields = preparedStatement.executeQuery();
                                    preparedStatement = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields(option_id, template_id, field_name) VALUES(?, ?, ?)");
                                    while (scriveOptionFields.next()) {
                                        preparedStatement.setInt(1, newID);
                                        preparedStatement.setInt(2, scriveOptionFields.getInt("template_id"));
                                        preparedStatement.setString(3, scriveOptionFields.getString("field_name"));
                                        preparedStatement.addBatch();
                                    }
                                    preparedStatement.executeBatch();
                                    s = s + id + ", " + newID + "\n";
                                }
                                Utils.writeLog("optionsMap: " + s);
                                resultSet.close();
                                preparedStatement.close();
                                connection.close();
                                continue;
                            }
                            catch (Exception e) {
                                Utils.writeLog("Error copying form element options: " + e.toString());
                                return;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying element options: " + e.toString());
                }
                try {
                    sql = "SELECT MAX(id) FROM " + FormEngine.TABLE_PREFIX + "form_elements";
                    String insertedElementId = dbUtil.sqlQueryStr(sql, new Object[0]);
                    sql = "SELECT type, value, group_with FROM " + FormEngine.TABLE_PREFIX + "form_validation WHERE item_id = ?";
                    String[][] arrNewValidation = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{id});
                    if (arrNewValidation == null) continue;
                    for (int j = 0; j < arrNewValidation.length; ++j) {
                        String type = arrNewValidation[j][0];
                        String value = arrNewValidation[j][1];
                        String group_with = arrNewValidation[j][2];
                        sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_validation (item_id, type, value, group_with) VALUES (?, ?, ?, ?)";
                        dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{insertedElementId, type, value, group_with});
                    }
                    continue;
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying validation: " + e.toString());
                }
            }
            try {
                sql = "SELECT c.condition_id, c.parent_question_id, c.question_id, c.all_values_required, c.text FROM " + FormEngine.TABLE_PREFIX + "conditions c LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON c.parent_question_id = e.id WHERE e.meta_id = ?";
                String[][] conditions = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{"" + from_meta});
                String s = "";
                for (String[] condition : conditions) {
                    s = s + "" + condition[0] + ", " + condition[1] + ", " + condition[2] + ", " + condition[3] + ", " + condition[4] + "\n";
                }
                Utils.writeLog("Old dependency conditions:\n" + s);
                s = "";
                for (String[] condition : conditions) {
                    try {
                        sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "conditions ( parent_question_id, question_id, all_values_required, text) VALUES (?, ?, ?, ?)";
                        Connection connection = databaseService.getConnection();
                        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
                        Utils.writeLog("Inserting new condition: " + elementsMap.get(Integer.parseInt(condition[1])) + "," + elementsMap.get(Integer.parseInt(condition[2])) + "," + condition[3] + ", " + condition[4]);
                        preparedStatement.setInt(1, (Integer)elementsMap.get(Integer.parseInt(condition[1])));
                        preparedStatement.setInt(2, (Integer)elementsMap.get(Integer.parseInt(condition[2])));
                        preparedStatement.setBoolean(3, condition[3] != null && condition[3].matches("true|1|-1"));
                        preparedStatement.setString(4, condition[4]);
                        preparedStatement.executeUpdate();
                        ResultSet resultSet = preparedStatement.getGeneratedKeys();
                        if (resultSet.next()) {
                            int newID = resultSet.getInt(1);
                            conditionsMap.put(Integer.parseInt(condition[0]), newID);
                        }
                        resultSet.close();
                        preparedStatement.close();
                        connection.close();
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting new conditions: " + e.toString());
                        return;
                    }
                }
            }
            catch (Exception e) {
                Utils.writeLog("Error updating dependencies: " + e.toString());
            }
            String s = "";
            try {
                String[][] options;
                sql = "SELECT v.condition_id, v.option_id, c.condition_id, c.question_id, e.id, e.meta_id FROM " + FormEngine.TABLE_PREFIX + "condition_values v LEFT JOIN " + FormEngine.TABLE_PREFIX + "conditions c ON v.condition_id = c.condition_id LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON c.question_id = e.id WHERE e.meta_id = ?";
                for (String[] option : options = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{"" + from_meta})) {
                    s = s + "" + option[0] + ", " + option[1] + ", " + option[2] + ", " + option[3] + ", " + option[4] + ", " + option[5] + "\n";
                }
                Utils.writeLog("Old dependency options:\n" + s);
                s = "";
                for (String[] option : options) {
                    try {
                        String newCondition_id = "" + (Integer)conditionsMap.get(Integer.parseInt(option[0]));
                        s = s + "Condition_id fr\u00e5n " + option[0] + " -> " + newCondition_id + " ";
                        String newOption_id = "" + (Integer)optionsMap.get(Integer.parseInt(option[1]));
                        s = s + " Option_id fr\u00e5n " + option[1] + " -> " + newOption_id + "\n";
                        sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "condition_values ( condition_id, option_id ) VALUES (?,?)";
                        dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{newCondition_id, newOption_id});
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting condition_value: " + e.toString());
                    }
                }
                Utils.writeLog("new dependency options: " + s);
            }
            catch (Exception e) {
                Utils.writeLog("new dependency options: " + s);
                Utils.writeLog("Error updating dependency options: " + e.toString());
            }
            try {
                String[][] fields;
                sql = "SELECT f.element_id, f.template_id, f.field_name, f.oneflow_field FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields f LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON f.element_id = e.id WHERE e.meta_id = ?";
                for (String[] field : fields = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{"" + from_meta})) {
                    try {
                        String newElement_id = "" + (Integer)elementsMap.get(Integer.parseInt(field[0]));
                        sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "element_scrive_fields ( element_id, template_id, field_name, oneflow_field ) VALUES (?,?,?,?)";
                        dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{newElement_id, field[1], field[2], field[3]});
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting oneflow field: " + e.toString());
                    }
                }
            }
            catch (Exception e) {
                Utils.writeLog("Error updating oneflow fields: " + e.toString());
            }
        }
        try {
            documentService.saveChanges((Document)toDoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Role getClientAdminRole(UserService userService) {
        return userService.getRole("kund_admin");
    }

    public static Role getServiceAdminRole(UserService userService) {
        return userService.getRole("service_admin_imsurvey");
    }

    public static boolean canAdminster(User user, UserService userService) {
        Role clientAdminRole = Utils.getClientAdminRole(userService);
        Role serviceAdminRole = Utils.getServiceAdminRole(userService);
        return user.isSuperAdmin() || clientAdminRole != null && user.hasRole(clientAdminRole) || serviceAdminRole != null && user.hasRole(Utils.getServiceAdminRole(userService));
    }

    public static CategoryType getClientCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(CLIENT_CATEGORY_TYPE_NAME);
    }

    public static CategoryType getSurveyCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(ACCOUNT_CATEGORY_TYPE_NAME);
    }

    public static CategoryType getServiceCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(SERVICE_CATEGORY_TYPE_NAME);
    }

    public static Category getSurveyCategory(DocumentService documentService) {
        return documentService.getCategory(Utils.getServiceCategoryType(documentService), "imsurvey");
    }

    public static TextDocument getSurveyDocument(DocumentService documentService) {
        return documentService.getTextDocument("imsurvey");
    }

    public static Template getSurveyTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_TEMPLATE_NAME);
    }

    public static Template getSurveyAdminTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_ADMIN_TEMPLATE_NAME);
    }

    public static CategoryType getFormCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(FORM_CATEGORY_NAME);
    }

    public static Category getFormCategory(DocumentService documentService) {
        CategoryType formCategoryType = Utils.getFormCategoryType(documentService);
        if (formCategoryType == null) {
            return null;
        }
        return documentService.getCategory(formCategoryType, FORM_CATEGORY_NAME);
    }

    public static Map<String, List<String>> getTemplateFields(HttpServletRequest request) {
        HashMap<String, List<String>> templateFields = new HashMap<String, List<String>>();
        String[] templateIds = request.getParameterValues("scrive_template");
        String[] fieldNames = request.getParameterValues("scrive_field");
        String[] fieldTypes = request.getParameterValues("el_type");
        String fieldType = fieldTypes != null ? fieldTypes[0] : "";
        String[] userIds = request.getParameterValues("scrive_field_user");
        if (templateIds != null) {
            for (String templateId : templateIds) {
                if (StringUtils.isBlank((String)templateId)) continue;
                ArrayList<String> fields = (ArrayList<String>)templateFields.get(templateId);
                if (fields == null) {
                    fields = new ArrayList<String>();
                    templateFields.put(templateId, fields);
                }
                if (fieldNames != null) {
                    Pattern fieldPattern = Pattern.compile(templateId + "_(.+)");
                    int i = 0;
                    for (String fieldName : fieldNames) {
                        String scriveFieldName;
                        Matcher matcher = fieldPattern.matcher(fieldName);
                        if (fieldType.equals("scrive_button")) {
                            String agreementId;
                            fieldPattern = Pattern.compile("_(.+)");
                            matcher = fieldPattern.matcher(fieldName);
                            if (matcher.find() && !fields.contains(agreementId = fieldNames[0].substring(0, matcher.start()))) {
                                fields.add(agreementId);
                            }
                        } else if (matcher.matches() && !fields.contains(scriveFieldName = matcher.group(1))) {
                            String userId;
                            String string = userId = userIds != null ? userIds[i] : "";
                            if (!userId.isEmpty()) {
                                if (!fields.contains("user_" + userId + "_" + scriveFieldName)) {
                                    fields.add("user_" + userId + "_" + scriveFieldName);
                                }
                            } else {
                                fields.add(scriveFieldName);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                }
                String signMethod = request.getParameter("scrive_field_sign");
                String deliveryChannel = request.getParameter("scrive_field_delivery");
                if (null != signMethod && !signMethod.isEmpty()) {
                    fields.add(SignMethod.class.getSimpleName() + "_" + SignMethod.valueOf(signMethod.substring(signMethod.indexOf(95) + 1)).name());
                }
                if (null == deliveryChannel || deliveryChannel.isEmpty()) continue;
                fields.add(DeliveryChannel.class.getSimpleName() + "_" + DeliveryChannel.valueOf(deliveryChannel.substring(deliveryChannel.indexOf(95) + 1)).name());
            }
        }
        return templateFields;
    }

    public static void writeLog(String str) {
        FileOutputStream fos;
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "imSurvey_sms_send_log.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc, DataSource[] att, ContentManagementSystem imcmsSystem, boolean htmlMail) {
        Utils.writeLog("Sending email: " + to[0]);
        try {
            MailService mailService = imcmsSystem.getMailService();
            Mail mail = new Mail(from, to, subject, body);
            if (htmlMail) {
                mail.setHtmlBody(body);
            }
            if (cc != null && cc.length > 0 && !cc[0].equals("")) {
                mail.setCcAddresses(cc);
            }
            if (bcc != null && bcc.length > 0 && !bcc[0].equals("")) {
                mail.setBccAddresses(bcc);
            }
            if (att != null && att.length > 0) {
                mail.setAttachments(att);
            }
            mailService.sendMail(mail);
            return true;
        }
        catch (Exception ex) {
            Utils.writeLog("mailexception= " + ex.getMessage());
            Utils.writeLog("from= " + from + " to = " + to[0] + " subject= " + subject + " body= " + body);
            return false;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc, DataSource[] att, ContentManagementSystem imcmsSystem) {
        return Utils.sendMail(from, to, subject, body, cc, bcc, att, imcmsSystem, false);
    }

    public static void notifyAbouScriveOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        String from = settings.getMailFrom();
        String[] to = new String[]{settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty((String)settings.getScriveOutOfSyncSubject(), (String)"Survey out of sync with Scrive: "));
        subject.append(" ").append(surveyId);
        String linkToSurvey = Utils.getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(Utils.createLink(linkToSurvey, linkToSurvey));
        Utils.sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static void notifyAbouOneflowOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        String from = settings.getMailFrom();
        String[] to = new String[]{settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty((String)settings.getScriveOutOfSyncSubject(), (String)"Survey out of sync with Oneflow: "));
        subject.append(" ").append(surveyId);
        String linkToSurvey = Utils.getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(Utils.createLink(linkToSurvey, linkToSurvey));
        Utils.sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static String getBaseURL(HttpServletRequest request) {
        boolean isLocalhost = "localhost".equals(request.getServerName());
        return request.getScheme() + "://" + request.getServerName() + (isLocalhost ? ":" + request.getServerPort() : "") + request.getContextPath();
    }

    public static String createLink(String href, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href='").append(href).append("'>");
        sb.append(text);
        sb.append("</a>");
        return sb.toString();
    }

    public static String getTemplateIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveButtonPattern = Pattern.compile("scrive_button_(.+)");
        Map params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveButtonPattern.matcher(name);
            if (!matcher.matches()) continue;
            templateId = matcher.group(1);
            break;
        }
        return templateId;
    }

    public static String getTemplateGroupIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveHiddenPattern = Pattern.compile("scrive_([0-9]+)_([0-9]+)");
        Map params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveHiddenPattern.matcher(name);
            if (!matcher.matches()) continue;
            templateId = matcher.group(1);
            break;
        }
        return templateId;
    }

    public static Map<String, String> getFieldValuesForTemplate(String templateId, ServletRequest request) {
        Pattern scriveFieldParamPattern = Pattern.compile("scrive_([0-9]+)_(.+)");
        if (!StringUtils.isBlank((String)templateId)) {
            Map params = request.getParameterMap();
            HashMap<String, String> scriveParams = new HashMap<String, String>();
            for (String name : params.keySet()) {
                Matcher matcher = scriveFieldParamPattern.matcher(name);
                if (!matcher.matches()) continue;
                String fieldTemplateId = matcher.group(1);
                String fieldName = matcher.group(2);
                String value = ((String[])params.get(name))[0];
                if (!templateId.equals(fieldTemplateId)) continue;
                scriveParams.put(fieldName, value);
            }
            return scriveParams;
        }
        return null;
    }

    public static Map<String, String> getScriveFieldsFromDb(String templateId, ServletRequest request) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Properties getProperties() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream("server.properties");
            prop.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return prop;
        }
    }

    public static API getAPI(String stringValue) {
        if (stringValue.equals(API.ONEFLOW.toString())) {
            return API.ONEFLOW;
        }
        return API.SCRIVE;
    }
}

