/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.site;

import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryAlreadyExistsException;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.LuceneParsedQuery;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SearchQuery;
import com.imcode.imcms.api.TextDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class SiteUtils {
    private static final Logger log = Logger.getLogger(SiteUtils.class);

    public static Document[] getDocuments(String query, Comparator comp, DocumentService documentService) {
        Document[] docArr = new Document[]{};
        try {
            LuceneParsedQuery sq = new LuceneParsedQuery(query);
            docArr = documentService.search((SearchQuery)sq);
            if (comp != null) {
                Arrays.sort(docArr, comp);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.toString(), (Throwable)ex);
        }
        return docArr;
    }

    public static List<Document> getDocuments(String query, Comparator comp, Predicate filterPredicate, DocumentService documentService) {
        try {
            LuceneParsedQuery sq = new LuceneParsedQuery(query);
            ArrayList<Document> documents = new ArrayList<Document>(documentService.getDocuments((SearchQuery)sq));
            if (null != filterPredicate) {
                CollectionUtils.filter(documents, (Predicate)filterPredicate);
            }
            if (null != comp) {
                Collections.sort(documents, comp);
            }
            return documents;
        }
        catch (Exception ex) {
            return new ArrayList<Document>();
        }
    }

    public static String getParam(String paramName, HttpServletRequest request) {
        return StringUtils.defaultString((String)request.getParameter(paramName));
    }

    public static String getTextField(int meta, int txtNo, DocumentService documentService) {
        String retVal = "";
        try {
            TextDocument txtDoc = documentService.getTextDocument(meta);
            TextDocument.TextField txt = txtDoc.getTextField(txtNo);
            retVal = txt.getHtmlFormattedText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getTextFieldDoc(Document doc, int txtNo) {
        try {
            if (doc instanceof TextDocument) {
                TextDocument txtDoc = (TextDocument)doc;
                return SiteUtils.getTextFieldDoc(txtDoc, txtNo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getTextFieldDoc(TextDocument txtDoc, int txtNo) {
        try {
            TextDocument.TextField txt = txtDoc.getTextField(txtNo);
            return txt.getHtmlFormattedText();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Category getCategoryByName(String catName, String catTypeName, DocumentService documentService) {
        if (null != catTypeName && !"".equals(catTypeName)) {
            Category[] cats;
            CategoryType catType = documentService.getCategoryType(catTypeName);
            for (Category cat : cats = documentService.getAllCategoriesOfType(catType)) {
                if (!catName.equals(cat.getName())) continue;
                return cat;
            }
            Category catNew = new Category(catName, catType);
            try {
                documentService.saveCategory(catNew);
                return catNew;
            }
            catch (CategoryAlreadyExistsException categoryAlreadyExistsException) {
            }
            catch (NoPermissionException noPermissionException) {
            }
            catch (Exception exception) {}
        } else {
            CategoryType[] types;
            for (CategoryType catType : types = documentService.getAllCategoryTypes()) {
                Category[] cats;
                for (Category cat : cats = documentService.getAllCategoriesOfType(catType)) {
                    if (!catName.equals(cat.getName())) continue;
                    return cat;
                }
            }
        }
        return null;
    }

    public static int getIntRequestParameter(String param, int defaultVal, HttpServletRequest request) {
        return NumberUtils.toInt((String)request.getParameter(param), (int)defaultVal);
    }

    public static boolean getBooleanRequestParameter(String param, HttpServletRequest request) {
        return null != request.getParameter(param) && "true".equals(request.getParameter(param));
    }

    public static boolean getBooleanFromTextField(TextDocument doc, int textFieldNbr, boolean defaultValue) {
        try {
            String text = doc.getTextField(textFieldNbr).getHtmlFormattedText().trim();
            if ("true".equalsIgnoreCase(text)) {
                return true;
            }
            if ("false".equalsIgnoreCase(text)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String removeHTML(String str) {
        str = str.replaceAll("(<[Bb][Rr][^>]*?>|\\n|\\r)", " ");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("<[^>]+?>", "");
        return str;
    }

    public static String truncateString(String str, int iTruncate) {
        String ret = str;
        try {
            ret = ret.replaceAll("<[\\/]?[^>]+?>", "");
            ret = ret.trim();
            if (ret.length() > iTruncate) {
                ret = ret.substring(0, iTruncate - 3) + "...";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getCookie(String theName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!theName.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return "";
    }

    public static void setCookie(String theName, String theValue, HttpServletResponse response) {
        Cookie cookie = new Cookie(theName, theValue);
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void saveDocumentKeepModifiedDate(Document doc, DocumentService ds) {
        try {
            Date oldModifiedDate = doc.getModifiedDatetime();
            Date newModifiedDate = new Date(oldModifiedDate.getTime() + 60000L);
            doc.setModifiedDatetime(newModifiedDate);
            ds.saveChanges(doc);
            doc = ds.getDocument(doc.getId());
            oldModifiedDate = doc.getModifiedDatetime();
            newModifiedDate = new Date(oldModifiedDate.getTime() - 60000L);
            doc.setModifiedDatetime(newModifiedDate);
            ds.saveChanges(doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DocumentPublishedPredicate
    implements Predicate {
        public boolean evaluate(Object object) {
            Document doc = (Document)object;
            return doc.isPublished();
        }
    }
}

