/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.system;

import com.imcode.imcms.addon.system.PageView;
import com.imcode.imcms.addon.system.SystemUtils;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.oro.text.perl.Perl5Util;

public class AdminServlet
extends HttpServlet {
    public static final String PARAM_DOC = "adminServletDoc";
    public static final String PARAM_ID = "adminServletId";
    public static final String PARAM_SID = "adminServletSid";
    public static final boolean DEBUG = false;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, true);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response, boolean isPOST) throws ServletException, IOException {
        String servletPath = StringUtils.defaultString((String)request.getServletPath());
        boolean isAdmin = "/admin".equals(servletPath);
        boolean isIframe = "/iframe".equals(servletPath);
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        String pathInfo = StringUtils.defaultString((String)request.getPathInfo());
        String servletPathAndInfo = servletPath + pathInfo;
        if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        if (servletPathAndInfo.length() > 1 && servletPathAndInfo.endsWith("/")) {
            servletPathAndInfo = servletPathAndInfo.substring(0, servletPathAndInfo.length() - 1);
        }
        Perl5Util re = new Perl5Util();
        String debug = "";
        request.getSession().removeAttribute("TEMP_debug");
        if (isIframe) {
            if (pathInfo.startsWith("/stripped")) {
                request.getSession().setAttribute("IS_STRIPPED_IFRAME", (Object)true);
            } else {
                request.getSession().removeAttribute("IS_STRIPPED_IFRAME");
            }
            String strippedPath = pathInfo.replaceFirst("^\\/(stripped|unstripped)", "");
            String strippedQs = StringUtils.defaultString((String)request.getQueryString());
            if (!"".equals(strippedQs)) {
                strippedPath = strippedPath + "?" + strippedQs;
            }
            response.sendRedirect(request.getContextPath() + strippedPath);
            return;
        }
        if (isAdmin && imcmsSystem.getCurrentUser().isDefaultUser()) {
            request.getSession().setAttribute("TEMP_debug", (Object)("NO ADMIN: |" + servletPath + "|" + pathInfo + "| isAdmin:" + isAdmin));
            Utility.forwardToLogin((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            request.getSession().setAttribute("pathInfo", (Object)servletPathAndInfo);
            for (PageView.View view : PageView.View.values()) {
                boolean isAjaxView = false;
                if (!AdminServlet.class.getName().equals(view.getServletName()) || PageView.ForwardTo.OTHER == view.getForwardTo()) {
                    debug = debug + "continue\n";
                    continue;
                }
                if ((servletPathAndInfo.matches(".*(submit|delete|exec).*") || pathInfo.matches(".*(submit|delete|exec).*")) && !isPOST) {
                    request.getSession().setAttribute("TEMP_debug", (Object)"View has (submit|delete|exec): IS GET, NOT POST!");
                    Utility.forwardToLogin((HttpServletRequest)request, (HttpServletResponse)response);
                    continue;
                }
                if (!re.match(view.getPathRegExp(), servletPathAndInfo) && !re.match(view.getPathRegExp(), pathInfo)) continue;
                debug = debug + (isAjaxView ? "" : "re.match(view.getPathRegExp(), \"" + servletPathAndInfo + "\") || re.match(view.getPathRegExp(), \"" + pathInfo + "\")\n");
                int id = 0;
                request.removeAttribute(PARAM_DOC);
                request.removeAttribute(PARAM_ID);
                request.removeAttribute(PARAM_SID);
                String viewHref = view.getLinkHref("");
                boolean hasTag = false;
                if (viewHref.contains("#META_ID#")) {
                    Document doc = this.getDocumentFromPath(re, documentService);
                    request.setAttribute(PARAM_DOC, (Object)doc);
                    debug = debug + (isAjaxView ? "" : "(" + view.toString() + ".getLinkHref(\"\").contains(\"#META_ID# [" + doc.getId() + "]\"))\n");
                    hasTag = true;
                }
                if (viewHref.contains("#ID#")) {
                    id = this.getIntFromPath(re);
                    if (viewHref.contains("#META_ID#") && viewHref.indexOf("#META_ID#") < viewHref.indexOf("#ID#")) {
                        id = this.getIntFromPath2(re);
                    }
                    request.setAttribute(PARAM_ID, (Object)id);
                    debug = debug + (isAjaxView ? "" : "(" + view.toString() + ".getLinkHref(\"\").contains(\"#ID# [" + id + "]\"))\n");
                    hasTag = true;
                }
                if (viewHref.contains("#SID#")) {
                    String sId = this.getStringFromPath(re);
                    request.setAttribute(PARAM_SID, (Object)sId);
                    debug = debug + (isAjaxView ? "" : "(" + view.toString() + ".getLinkHref(\"\").contains(\"#SID# [" + sId + "]\"))\n");
                    hasTag = true;
                }
                if (!hasTag) {
                    debug = debug + (isAjaxView ? "" : "(" + view.toString() + ".getLinkHref(\"\") contains no tags)\n");
                }
                if (PageView.ForwardTo.META_ID == view.getForwardTo()) {
                    debug = debug + (Object)((Object)view) + " selected - ForwardTo.META_ID - forwardToGetDoc(" + id + ", " + (Object)((Object)view) + ")\n";
                    SystemUtils.forwardToGetDoc(id, view, request, response);
                    break;
                }
                if (PageView.ForwardTo.FILE == view.getForwardTo()) {
                    if (!view.toString().startsWith("TEMP_")) {
                        PageView.swapView(view, request);
                    }
                    debug = debug + (Object)((Object)view) + " selected - ForwardTo.FILE\n";
                    request.getRequestDispatcher(view.getJspPath()).forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
                if (PageView.ForwardTo.ROOT != view.getForwardTo()) break;
                debug = debug + (Object)((Object)view) + " selected - ForwardTo.ROOT\n";
                SystemUtils.forwardToRoot(view, request, response);
                break;
            }
        }
        response.setContentType("text/plain");
        response.getWriter().write("\n" + servletPath + pathInfo);
    }

    private Document getDocumentFromPath(Perl5Util re, DocumentService documentService) {
        try {
            int id = this.getIntFromPath(re);
            return documentService.getDocument(id);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getIntFromPath(Perl5Util re) {
        try {
            if (NumberUtils.isDigits((String)re.group(1))) {
                return Integer.parseInt(re.group(1));
            }
            if (NumberUtils.isDigits((String)re.group(2))) {
                return Integer.parseInt(re.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private int getIntFromPath2(Perl5Util re) {
        try {
            if (NumberUtils.isDigits((String)re.group(2))) {
                return Integer.parseInt(re.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private String getStringFromPath(Perl5Util re) {
        try {
            return re.group(1);
        }
        catch (Exception e) {
            return "";
        }
    }
}

