/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.Document;
import com.imcode.imcms.addon.imsurvey.oneflow.Field;
import com.imcode.imcms.addon.imsurvey.oneflow.OneflowParticipant;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.oneflow.UserField;
import com.imcode.imcms.addon.imsurvey.utils.OneflowFields;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OneflowService {
    private static final int FAILURE_HTTP_RESPONSE_CODE = 390;
    private static final String ONEFLOW_BASE_URL = "https://app.oneflow.com";
    private static final Logger log = Logger.getLogger(OneflowService.class);

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return new OneflowService();
    }

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        return true;
    }

    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props, HttpServletRequest request) throws Exception {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        if (props.containsKey("imSurveyId")) {
            try {
                props.remove("imSurveyId");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException("Oneflow template id is either missing or invalid: " + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + templateId, "GET");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject fetchedAgreement = null;
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/" + templateId + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            fetchedAgreement = parsedReturn.getAsJsonObject();
            JsonObject id = fetchedAgreement.getAsJsonObject("template_group");
            docId = id.getAsJsonPrimitive("id").getAsLong();
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception("Error template has changed! Can't create document.");
        }
        if (docId > 0L) {
            String urlParameters = fetchedAgreement.toString();
            JsonObject contract = this.buildContract(templateId, props);
            connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
            streamWriter.write(contract.toString());
            streamWriter.close();
            responseCode = connection.getResponseCode();
            log.debug((Object)("https://app.oneflow.com/api/agreements/:" + responseCode + connection.getResponseMessage()));
            if (responseCode > 390) {
                log.error((Object)("https://app.oneflow.com/api/agreements/:" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            Integer agreementId = 0;
            JsonObject agreementResponse = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (null != agreementResponse) {
                JsonPrimitive id = agreementResponse.getAsJsonPrimitive("id");
                agreementId = id.getAsInt();
            }
            connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + agreementId + "/publish");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            String publishSubject = "Agreement " + agreementId + " publication";
            String publishMessage = "Agreement " + agreementId + " has been published";
            JsonObject publishContent = new JsonObject();
            publishContent.addProperty("subject", publishSubject);
            publishContent.addProperty("message", publishMessage);
            OutputStreamWriter streamWriter1 = new OutputStreamWriter(connection.getOutputStream());
            streamWriter1.write(publishContent.toString());
            streamWriter1.close();
            connection.disconnect();
            if (connection.getResponseCode() < 390) {
                log.info((Object)("Agreement with id " + agreementId + " was published: " + connection.getResponseCode() + ":" + connection.getResponseMessage()));
                JsonElement publishResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
                if (publishResponse.isJsonObject()) {
                    String participantId = this.getParticipantId((JsonObject)publishResponse);
                    String userToken = this.getUserToken(agreementId.toString(), participantId);
                    if (!userToken.isEmpty()) {
                        log.debug((Object)("Agreement id:" + agreementId + "\t Participant id: " + participantId + "\t User token:" + userToken));
                        return "/contracts/" + agreementId + "/at/" + userToken;
                    }
                }
            } else {
                log.error((Object)("Agreement with id " + agreementId + " wasn't published: " + connection.getResponseCode() + ":" + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
                connection.disconnect();
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            connection.disconnect();
        }
        return null;
    }

    private JsonObject buildContract(String templateId, Map<String, String> props) {
        JsonObject contract = new JsonObject();
        contract.addProperty("template_id", (Number)Integer.valueOf(templateId));
        JsonArray parties = new JsonArray();
        JsonObject party = new JsonObject();
        party.addProperty("self", (Number)1);
        JsonArray participants = new JsonArray();
        JsonObject participant = new JsonObject();
        participant.addProperty("position_id", (Number)Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_POSITION));
        participants.add((JsonElement)participant);
        party.add("participants", (JsonElement)participants);
        parties.add((JsonElement)party);
        ArrayList<OneflowParticipant> participantsData = new ArrayList<OneflowParticipant>();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (entry.getValue().isEmpty() || !entry.getKey().matches("user_[0-9]+_.+")) continue;
            String[] splittedData = entry.getKey().split("user_");
            String userId = splittedData[1].substring(0, splittedData[1].indexOf(95));
            String fieldName = splittedData[1].substring(splittedData[1].indexOf(95) + 1, splittedData[1].length());
            if (!userId.isEmpty() && !fieldName.isEmpty()) {
                OneflowParticipant oneflowParticipant = null;
                boolean isNew = true;
                for (OneflowParticipant op : participantsData) {
                    if (!op.getId().equals(userId)) continue;
                    oneflowParticipant = op;
                    isNew = false;
                }
                if (oneflowParticipant == null) {
                    oneflowParticipant = new OneflowParticipant(userId);
                }
                if (UserField.isMember(fieldName.toLowerCase())) {
                    UserField userField = UserField.valueOf(fieldName.toUpperCase());
                    if (userField.equals((Object)UserField.DELIVERY_CHANNEL)) {
                        oneflowParticipant.addValues(userField, String.valueOf((Object)DeliveryChannel.valueOf(entry.getValue())));
                    }
                    if (userField.equals((Object)UserField.SIGN_METHOD)) {
                        oneflowParticipant.addValues(userField, String.valueOf((Object)SignMethod.valueOf(entry.getValue())));
                    } else {
                        oneflowParticipant.addValues(userField, entry.getValue());
                    }
                }
                if (isNew) {
                    participantsData.add(oneflowParticipant);
                }
            }
            it.remove();
        }
        for (OneflowParticipant entity : participantsData) {
            JsonObject partyClient = new JsonObject();
            participants = new JsonArray();
            participant = new JsonObject();
            for (Map.Entry<Enum, String> entry : entity.getValues().entrySet()) {
                String value = entry.getValue();
                Integer intValue = null;
                if (entry.getKey().equals((Object)UserField.NAME) || entry.getKey().equals((Object)UserField.COUNTRY) || entry.getKey().equals((Object)UserField.ORGNR)) {
                    partyClient.addProperty(((UserField)entry.getKey()).getValue(), entry.getValue());
                    continue;
                }
                if (entry.getKey().equals((Object)UserField.DELIVERY_CHANNEL) && DeliveryChannel.isMember(entry.getValue())) {
                    intValue = DeliveryChannel.valueOf(value).getValue();
                }
                if (entry.getKey().equals((Object)UserField.SIGN_METHOD) && SignMethod.isMember(entry.getValue())) {
                    intValue = SignMethod.valueOf(value).getValue();
                }
                if (entry.getKey().equals((Object)UserField.TYPE)) {
                    intValue = Integer.parseInt(value);
                }
                if (intValue != null && (entry.getKey().equals((Object)UserField.DELIVERY_CHANNEL) || entry.getKey().equals((Object)UserField.SIGN_METHOD) || entry.getKey().equals((Object)UserField.TYPE))) {
                    participant.addProperty(((UserField)entry.getKey()).getValue(), (Number)intValue);
                    continue;
                }
                participant.addProperty(((UserField)entry.getKey()).getValue(), value);
            }
            participants.add((JsonElement)participant);
            partyClient.add("participants", (JsonElement)participants);
            parties.add((JsonElement)partyClient);
        }
        contract.add("parties", (JsonElement)parties);
        JsonArray dataList = new JsonArray();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            JsonObject dataItem = new JsonObject();
            dataItem.addProperty("key", "data_field");
            JsonObject dataItemValue = new JsonObject();
            dataItemValue.addProperty("external_key", entry.getKey());
            dataItemValue.addProperty("value", entry.getValue());
            dataItem.add("value", (JsonElement)dataItemValue);
            dataList.add((JsonElement)dataItem);
        }
        contract.add("data", (JsonElement)dataList);
        log.info((Object)("contract:" + contract));
        return contract;
    }

    private String getUserToken(String agreementId, String userId) throws IOException {
        JsonObject tokenBody = new JsonObject();
        tokenBody.addProperty("type", "form");
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + agreementId + "/participants/" + userId + "/tokens");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
        streamWriter.write(tokenBody.toString());
        streamWriter.close();
        int responseCode = connection.getResponseCode();
        log.debug((Object)("https://app.oneflow.com/api/agreements/" + agreementId + "/participants/" + userId + "/tokens :" + responseCode + connection.getResponseMessage()));
        if (responseCode > 390) {
            log.error((Object)("https://app.oneflow.com/api/agreements/" + agreementId + "/participants/" + userId + "/tokens :" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
            throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
        }
        String tokenValue = "";
        JsonElement tokenResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (tokenResponse.isJsonObject()) {
            JsonPrimitive token = ((JsonObject)tokenResponse).getAsJsonPrimitive("token");
            tokenValue = token.getAsString();
        }
        return tokenValue;
    }

    private String getParticipantId(JsonObject publishedAgreementResponse) {
        String participantId = "";
        JsonArray parties = (JsonArray)publishedAgreementResponse.get("parties");
        if (null != parties && parties.isJsonArray()) {
            JsonObject party = (JsonObject)parties.get(0);
            JsonArray participants = (JsonArray)party.get("participants");
            JsonObject participant = (JsonObject)participants.get(0);
            JsonElement idElement = participant.get("id");
            participantId = idElement.getAsString();
        }
        return participantId;
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        JsonElement signMethods;
        JsonElement optionsElem;
        ArrayList<SignMethod> availableMethods = new ArrayList<SignMethod>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/:" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get("available_options")) && optionsElem.isJsonObject() && null != (signMethods = ((JsonObject)optionsElem).get("sign_methods")) && signMethods.isJsonArray()) {
            for (JsonElement signMethod : (JsonArray)signMethods) {
                SignMethod method = SignMethod.valueOf(signMethod.getAsInt());
                if (null == method) continue;
                availableMethods.add(method);
            }
        }
        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        JsonElement deliveryChannels;
        JsonElement optionsElem;
        ArrayList<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/" + id + ":" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get("available_options")) && optionsElem.isJsonObject() && null != (deliveryChannels = ((JsonObject)optionsElem).get("delivery_channels")) && deliveryChannels.isJsonArray()) {
            for (JsonElement deliveryChannel : (JsonArray)deliveryChannels) {
                DeliveryChannel channel = DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                if (null == channel) continue;
                availableDeliveries.add(channel);
            }
        }
        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        JsonElement templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/ext/templategroups/", "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/ext/templategroups/:" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get("collection")) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonObject templateObj = (JsonObject)templateElem;
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                JsonElement templateId = templateObj.get("id");
                if (null == templateId || null == title) continue;
                Document template = new Document();
                template.setId(templateId.getAsString());
                template.setTitle(title.getAsString());
                JsonElement templateFieldElem = templateObj.get("data_field_set");
                if (null != templateFieldElem && templateFieldElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    template.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
            document.setFields(this.getTemplateFields(id));
        }
        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup = new Document();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/ext/templategroups/" + id, "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/ext/templategroups/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != parsedReturn) {
            JsonObject templateGroupObj = (JsonObject)parsedReturn;
            JsonPrimitive title = templateGroupObj.getAsJsonPrimitive("name");
            JsonElement templateGroupId = templateGroupObj.get("id");
            if (null != templateGroupId && null != title) {
                templateGroup.setId(templateGroupId.getAsString());
                templateGroup.setTitle(title.getAsString());
                JsonElement fieldSetElem = templateGroupObj.get("data_field_set");
                if (null != fieldSetElem && fieldSetElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)fieldSetElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    templateGroup.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
            }
        }
        return templateGroup;
    }

    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        Document templateGroup = this.getTemplateGroup(id);
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/templates/?template_group_id=" + id, "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/ext/templategroups/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonObject templateGroupResponse = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        JsonArray templateGroupCollection = templateGroupResponse.getAsJsonArray("collection");
        if (null != templateGroupCollection) {
            ArrayList<Field> templateList = new ArrayList<Field>();
            for (JsonElement templateElem : templateGroupCollection) {
                JsonPrimitive templateId;
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonPrimitive name = ((JsonObject)templateElem).getAsJsonPrimitive("name");
                JsonObject agreementElem = ((JsonObject)templateElem).getAsJsonObject("agreement");
                if (null == agreementElem || !agreementElem.isJsonObject() || null == (templateId = agreementElem.getAsJsonPrimitive("id")) || null == name) continue;
                templateList.add(new Field(Field.Type.TEMPLATE, name.getAsString(), templateId.getAsString()));
            }
            templateGroup.setFields(templateList);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        JsonArray templateListElem;
        ArrayList<Field> fields = new ArrayList<Field>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/data_field_sets/" + id, "GET", true);
        connection.setRequestProperty("Content-Type", "text/plain");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/data_field_sets/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonObject agreementsFields = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (null != agreementsFields && null != (templateListElem = agreementsFields.getAsJsonArray("data_fields"))) {
            for (JsonElement templateElem : templateListElem) {
                JsonObject templateObj = (JsonObject)templateElem;
                JsonElement name = templateObj.get("name");
                JsonElement externalKey = templateObj.get("external_key");
                if (null == name || null == externalKey) continue;
                fields.add(new Field(Field.Type.TEXT, name.getAsString(), externalKey.getAsString()));
            }
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonElement titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonElement idElem = jsonObject.get("id");
            if (idElem != null && idElem.isJsonPrimitive()) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.get("name")) != null && titleElem.isJsonPrimitive()) {
                document.setTitle(titleElem.getAsString());
            }
        }
        return document;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        return this.getHttpURLConnection(callUrl, method, false);
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method, boolean isSystemCall) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("X-Flow-API-Token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.addRequestProperty("X-Flow-Current-Position", isSystemCall ? SystemProperties.ONEFLOW_SYSTEM_POSITION : SystemProperties.ONEFLOW_CURRENT_POSITION);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_OPTIONS_TEMPLATE_FIELDS);
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                List<Field> fields = (ArrayList<Field>)optionFields.get(template);
                if (fieldName.matches("user_[0-9]+_.+")) {
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, "Delivery_channel", "DELIVERY_CHANNEL"));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, "Sign_method", "SIGN_METHOD"));
                    continue;
                }
                for (Field field : template.getFields()) {
                    fields = (List)optionFields.get(template);
                    if (!field.getName().equals(fieldName)) continue;
                    if (fields == null) {
                        fields = new ArrayList();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_TEMPLATE_FIELDS);
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (fieldName.matches("[0-9]+")) {
                    List<Field> allFields = template.getFields();
                    allFields.addAll(this.getTemplatesInGroupAsFields(templateId).getFields());
                    template.setFields(allFields);
                    fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                }
                if (fieldName.matches("user_[0-9]+_.+")) {
                    Pattern fieldPattern = Pattern.compile("_([0-9]+)_(.+)");
                    Matcher matcher = fieldPattern.matcher(fieldName);
                    if (matcher.find()) {
                        fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    }
                } else {
                    for (Field field : template.getFields()) {
                        if (!field.getName().equals(fieldName)) continue;
                        fields.add(field);
                    }
                }
                templateFields.put(template, fields);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        ArrayList<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_TEMPLATE_USERS);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("id");
                String fieldName = rs.getString("el_text");
                if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)fieldName)) continue;
                templateFields.add(new Field(Field.Type.USER, fieldName, userId));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserElementIdByMetaId(int surveyId, DatabaseService databaseService) {
        String elId = "";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_ID_BY_META_ID);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                elId = rs.getString("id");
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return elId;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        String oneflowDocumentURI = this.getDocumentURI(backToSiteURL, templateId, oneflowParams, request);
        if (oneflowDocumentURI == null) {
            return null;
        }
        return ONEFLOW_BASE_URL + oneflowDocumentURI;
    }
}

