/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.Document;
import com.imcode.imcms.addon.imsurvey.oneflow.Field;
import com.imcode.imcms.addon.imsurvey.oneflow.OneflowParticipant;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.oneflow.UserField;
import com.imcode.imcms.addon.imsurvey.utils.OneflowFields;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OneflowService {
    private static final int FAILURE_HTTP_RESPONSE_CODE = 390;
    private static final String ONEFLOW_BASE_URL = "https://app.oneflow.com";
    private static final Logger log = Logger.getLogger(OneflowService.class);

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return new OneflowService();
    }

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props, HttpServletRequest request) throws Exception {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        if (props.containsKey("imSurveyId")) {
            try {
                props.remove("imSurveyId");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException("Oneflow template id is either missing or invalid: " + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + templateId, "GET");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject fetchedAgreement = null;
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/" + templateId + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            fetchedAgreement = parsedReturn.getAsJsonObject();
            JsonObject id = fetchedAgreement.getAsJsonObject("template_group");
            docId = id.getAsJsonPrimitive("id").getAsLong();
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception("Error template has changed! Can't create document.");
        }
        if (docId > 0L) {
            void var21_33;
            String urlParameters = fetchedAgreement.toString();
            JsonObject contract = new JsonObject();
            contract.addProperty("template_id", (Number)Integer.valueOf(templateId));
            JsonArray parties = new JsonArray();
            JsonObject party = new JsonObject();
            party.addProperty("self", (Number)1);
            JsonArray participants = new JsonArray();
            JsonObject participant = new JsonObject();
            participant.addProperty("position_id", (Number)Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_POSITION));
            participants.add((JsonElement)participant);
            party.add("participants", (JsonElement)participants);
            parties.add((JsonElement)party);
            ArrayList<OneflowParticipant> participantsData = new ArrayList<OneflowParticipant>();
            Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                if (entry.getValue().isEmpty() || !entry.getKey().matches("user_[0-9]+_.+")) continue;
                String[] stringArray = entry.getKey().split("user_");
                String userId = stringArray[1].substring(0, stringArray[1].indexOf(95));
                String fieldName = stringArray[1].substring(stringArray[1].indexOf(95) + 1, stringArray[1].length());
                if (null != userId || null != fieldName) {
                    OneflowParticipant oneflowParticipant = null;
                    boolean isNew = true;
                    for (OneflowParticipant op : participantsData) {
                        if (!op.getId().equals(userId)) continue;
                        oneflowParticipant = op;
                        isNew = false;
                    }
                    if (oneflowParticipant == null) {
                        oneflowParticipant = new OneflowParticipant(userId);
                    }
                    if (UserField.isMember(fieldName.toLowerCase())) {
                        UserField userField = UserField.valueOf(fieldName.toUpperCase());
                        if (userField.equals((Object)UserField.DELIVERY_CHANNEL)) {
                            oneflowParticipant.addValues(userField, String.valueOf((Object)DeliveryChannel.valueOf(entry.getValue())));
                        }
                        if (userField.equals((Object)UserField.SIGN_METHOD)) {
                            oneflowParticipant.addValues(userField, String.valueOf((Object)SignMethod.valueOf(entry.getValue())));
                        } else {
                            oneflowParticipant.addValues(userField, entry.getValue());
                        }
                    }
                    if (isNew) {
                        participantsData.add(oneflowParticipant);
                    }
                }
                it.remove();
            }
            for (OneflowParticipant oneflowParticipant : participantsData) {
                JsonObject jsonObject = new JsonObject();
                participants = new JsonArray();
                participant = new JsonObject();
                for (Map.Entry<Enum, String> entry : oneflowParticipant.getValues().entrySet()) {
                    String value = entry.getValue();
                    Integer intValue = null;
                    if (entry.getKey().equals((Object)UserField.NAME) || entry.getKey().equals((Object)UserField.COUNTRY) || entry.getKey().equals((Object)UserField.ORGNR)) {
                        jsonObject.addProperty(((UserField)entry.getKey()).getValue(), entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)UserField.DELIVERY_CHANNEL) && DeliveryChannel.isMember(entry.getValue())) {
                        intValue = DeliveryChannel.valueOf(value).getValue();
                    }
                    if (entry.getKey().equals((Object)UserField.SIGN_METHOD) && SignMethod.isMember(entry.getValue())) {
                        intValue = SignMethod.valueOf(value).getValue();
                    }
                    if (intValue != null && (entry.getKey().equals((Object)UserField.DELIVERY_CHANNEL) || entry.getKey().equals((Object)UserField.SIGN_METHOD))) {
                        participant.addProperty(((UserField)entry.getKey()).getValue(), (Number)intValue);
                        continue;
                    }
                    participant.addProperty(((UserField)entry.getKey()).getValue(), value);
                }
                participants.add((JsonElement)participant);
                jsonObject.add("participants", (JsonElement)participants);
                parties.add((JsonElement)jsonObject);
            }
            contract.add("parties", (JsonElement)parties);
            JsonArray dataList = new JsonArray();
            for (Map.Entry<String, String> entry : props.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                JsonObject dataItem = new JsonObject();
                dataItem.addProperty("key", "data_field");
                JsonObject dataItemValue = new JsonObject();
                dataItemValue.addProperty("external_key", entry.getKey());
                dataItemValue.addProperty("value", entry.getValue());
                dataItem.add("value", (JsonElement)dataItemValue);
                dataList.add((JsonElement)dataItem);
            }
            contract.add("data", (JsonElement)dataList);
            log.info((Object)("contract:" + contract));
            connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(contract.toString());
            outputStreamWriter.close();
            responseCode = connection.getResponseCode();
            log.debug((Object)("https://app.oneflow.com/api/agreements/:" + responseCode + connection.getResponseMessage()));
            if (responseCode > 390) {
                log.error((Object)("https://app.oneflow.com/api/agreements/:" + responseCode + connection.getResponseMessage()));
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            Integer n = 0;
            JsonElement publishReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (publishReturn.isJsonObject()) {
                JsonPrimitive id = ((JsonObject)publishReturn).getAsJsonPrimitive("id");
                Integer n2 = id.getAsInt();
            }
            connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + var21_33 + "/publish");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            String publishSubject = "Agreement " + var21_33 + " publication";
            String publishMessage = "Agreement " + var21_33 + " has been published";
            JsonObject publishContent = new JsonObject();
            publishContent.addProperty("subject", publishSubject);
            publishContent.addProperty("message", publishMessage);
            OutputStreamWriter streamWriter1 = new OutputStreamWriter(connection.getOutputStream());
            streamWriter1.write(publishContent.toString());
            streamWriter1.close();
            connection.disconnect();
            if (connection.getResponseCode() < 390) {
                log.info((Object)("Agreement with id " + var21_33 + " was published: " + connection.getResponseCode() + ":" + connection.getResponseMessage()));
            } else {
                log.error((Object)("Agreement with id " + var21_33 + " wasn't published: " + connection.getResponseCode() + ":" + connection.getResponseMessage()));
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
        }
        return null;
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        JsonElement signMethods;
        JsonElement optionsElem;
        ArrayList<SignMethod> availableMethods = new ArrayList<SignMethod>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/:" + responseCode + connection.getResponseMessage()));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get("available_options")) && optionsElem.isJsonObject() && null != (signMethods = ((JsonObject)optionsElem).get("sign_methods")) && signMethods.isJsonArray()) {
            for (JsonElement signMethod : (JsonArray)signMethods) {
                SignMethod method = SignMethod.valueOf(signMethod.getAsInt());
                if (null == method) continue;
                availableMethods.add(method);
            }
        }
        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        JsonElement deliveryChannels;
        JsonElement optionsElem;
        ArrayList<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/" + id + ":" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get("available_options")) && optionsElem.isJsonObject() && null != (deliveryChannels = ((JsonObject)optionsElem).get("delivery_channels")) && deliveryChannels.isJsonArray()) {
            for (JsonElement deliveryChannel : (JsonArray)deliveryChannels) {
                DeliveryChannel channel = DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                if (null == channel) continue;
                availableDeliveries.add(channel);
            }
        }
        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        JsonElement templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/ext/templategroups/", "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/ext/templategroups/:" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get("collection")) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonObject templateObj = (JsonObject)templateElem;
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                JsonElement templateId = templateObj.get("id");
                if (null == templateId || null == title) continue;
                Document template = new Document();
                template.setId(templateId.getAsString());
                template.setTitle(title.getAsString());
                JsonElement templateFieldElem = templateObj.get("data_field_set");
                if (null != templateFieldElem && templateFieldElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    template.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/agreements/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
            document.setFields(this.getTemplateFields(id));
        }
        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup = new Document();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/ext/templategroups/" + id, "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/ext/templategroups/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != parsedReturn) {
            JsonObject templateGroupObj = (JsonObject)parsedReturn;
            JsonPrimitive title = templateGroupObj.getAsJsonPrimitive("name");
            JsonElement templateGroupId = templateGroupObj.get("id");
            if (null != templateGroupId && null != title) {
                templateGroup.setId(templateGroupId.getAsString());
                templateGroup.setTitle(title.getAsString());
                JsonElement fieldSetElem = templateGroupObj.get("data_field_set");
                if (null != fieldSetElem && fieldSetElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)fieldSetElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    templateGroup.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
            }
        }
        return templateGroup;
    }

    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        JsonElement templateListElem;
        Document templateGroup = this.getTemplateGroup(id);
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/templates/?template_group_id=" + id, "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/ext/templategroups/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get("collection")) && templateListElem.isJsonArray()) {
            ArrayList<Field> templatesList = new ArrayList<Field>();
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                JsonObject templateObj;
                JsonElement templateFieldElem;
                if (null == templateElem || !templateElem.isJsonObject() || null == (templateFieldElem = (templateObj = (JsonObject)templateElem).get("agreement")) || !templateFieldElem.isJsonObject()) continue;
                JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                JsonPrimitive templateId = templateFieldObj.getAsJsonPrimitive("id");
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                if (null == templateId || null == title) continue;
                templatesList.add(new Field(Field.Type.TEMPLATE, title.getAsString(), templateId.getAsString()));
            }
            templateGroup.setFields(templatesList);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        JsonElement templateListElem;
        ArrayList<Field> fields = new ArrayList<Field>();
        HttpURLConnection connection = this.getHttpURLConnection("https://app.oneflow.com/api/data_field_sets/" + id, "GET", true);
        connection.setRequestProperty("Content-Type", "text/plain");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)("https://app.oneflow.com/api/data_field_sets/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement agreementsFields = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (agreementsFields.isJsonObject() && null != (templateListElem = ((JsonObject)agreementsFields).get("data_fields")) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                JsonObject templateObj = (JsonObject)templateElem;
                JsonElement name = templateObj.get("name");
                JsonElement externalKey = templateObj.get("external_key");
                if (null == name || null == externalKey) continue;
                fields.add(new Field(Field.Type.TEXT, name.getAsString(), externalKey.getAsString()));
            }
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonElement titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonElement idElem = jsonObject.get("id");
            if (idElem != null && idElem.isJsonPrimitive()) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.get("name")) != null && titleElem.isJsonPrimitive()) {
                document.setTitle(titleElem.getAsString());
            }
        }
        return document;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        return this.getHttpURLConnection(callUrl, method, false);
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method, boolean isSystemCall) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("X-Flow-API-Token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.addRequestProperty("X-Flow-Current-Position", isSystemCall ? SystemProperties.ONEFLOW_SYSTEM_POSITION : SystemProperties.ONEFLOW_CURRENT_POSITION);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    private void changeProperty(String property, JsonObject parent, String data) {
        parent.remove(property);
        parent.addProperty(property, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_OPTIONS_TEMPLATE_FIELDS);
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                List<Field> fields = (ArrayList<Field>)optionFields.get(template);
                if (fieldName.matches("user_[0-9]+_.+")) {
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, "Delivery_channel", "DELIVERY_CHANNEL"));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, "Sign_method", "SIGN_METHOD"));
                    continue;
                }
                for (Field field : template.getFields()) {
                    fields = (List)optionFields.get(template);
                    if (!field.getName().equals(fieldName)) continue;
                    if (fields == null) {
                        fields = new ArrayList();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_TEMPLATE_FIELDS);
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (fieldName.matches("[0-9]+")) {
                    List<Field> allFields = template.getFields();
                    allFields.addAll(this.getTemplatesInGroupAsFields(templateId).getFields());
                    template.setFields(allFields);
                    fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                }
                if (fieldName.matches("user_[0-9]+_.+")) {
                    Pattern fieldPattern = Pattern.compile("_([0-9]+)_(.+)");
                    Matcher matcher = fieldPattern.matcher(fieldName);
                    if (matcher.find()) {
                        fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    }
                } else {
                    for (Field field : template.getFields()) {
                        if (!field.getName().equals(fieldName)) continue;
                        fields.add(field);
                    }
                }
                templateFields.put(template, fields);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        ArrayList<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_TEMPLATE_USERS);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("id");
                String fieldName = rs.getString("el_text");
                if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)fieldName)) continue;
                templateFields.add(new Field(Field.Type.USER, fieldName, userId));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserElementIdByMetaId(int surveyId, DatabaseService databaseService) {
        String elId = "";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_ID_BY_META_ID);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                elId = rs.getString("id");
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return elId;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        String oneflowDocumentURI = this.getDocumentURI(backToSiteURL, templateId, oneflowParams, request);
        if (oneflowDocumentURI == null) {
            return null;
        }
        return ONEFLOW_BASE_URL + oneflowDocumentURI;
    }
}

