/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.FormEngine;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.Document;
import com.imcode.imcms.addon.imsurvey.oneflow.Field;
import com.imcode.imcms.addon.imsurvey.oneflow.OneflowParticipant;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.oneflow.UserField;
import com.imcode.imcms.addon.imsurvey.utils.OneflowFields;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class OneflowService {
    private static int FAILURE_HTTP_RESPONSE_CODE = 390;
    private String oneflowBaseURL = "https://app.oneflow.com";

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return new OneflowService();
    }

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        return true;
    }

    public List<String> getMissingFields(Document document, List<String> fieldNames) {
        ArrayList<String> missingFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            boolean hasField = false;
            for (Field field : document.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                hasField = true;
            }
            if (hasField) continue;
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public Map<String, List<String>> getSurveyFields(int surveyId, DatabaseService databaseService) {
        return this.getSurveyFields(surveyId, false, databaseService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getSurveyFields(int surveyId, boolean isOneFlowField, DatabaseService databaseService) {
        HashMap<String, List<String>> surveyFields = new HashMap<String, List<String>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT COALESCE(el_fields.template_id, opt_field.template_id) AS template_id, COALESCE(el_fields.field_name, opt_field.field_name) AS field_name" + (isOneFlowField ? ", el_fields.oneflow_field\n" : "\n") + "FROM " + FormEngine.TABLE_PREFIX + "form_elements el \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields opt_field ON opt_field.`option_id` = opt.id \nWHERE el.meta_id = ?" + (isOneFlowField ? " AND el_fields.oneflow_field = 1" : ""));
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString(OneflowFields.sqlTemplateId);
                String fieldName = rs.getString(OneflowFields.sqlFieldName);
                if (StringUtils.isEmpty((String)templateId) || StringUtils.isEmpty((String)fieldName)) continue;
                ArrayList<String> templateFields = (ArrayList<String>)surveyFields.get(templateId);
                if (templateFields == null) {
                    templateFields = new ArrayList<String>();
                    surveyFields.put(templateId, templateFields);
                }
                templateFields.add(fieldName);
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return surveyFields;
    }

    /*
     * WARNING - void declaration
     */
    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props, HttpServletRequest request) throws Exception {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        int nbrPropsToSet = props.size();
        boolean useEmailAuthentication = false;
        if (props.containsKey(OneflowFields.propertyImSurveyId)) {
            try {
                int imSurveyId = Integer.parseInt(props.get(OneflowFields.propertyImSurveyId));
                --nbrPropsToSet;
                props.remove(OneflowFields.propertyImSurveyId);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException(OneflowFields.errorWrongTempalateId + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiAgreementURL + templateId, "GET");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject documentToUpdate = null;
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String errorMessage = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(errorMessage);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            documentToUpdate = parsedReturn.getAsJsonObject();
            JsonObject id = documentToUpdate.getAsJsonObject("template_group");
            docId = id.getAsJsonPrimitive("id").getAsLong();
            this.changeDelivery(documentToUpdate, Integer.toString(DeliveryChannel.EMAIL.getValue()));
            JsonElement signaturesTest = documentToUpdate.get("signatories");
            if (null != signaturesTest && signaturesTest.isJsonArray()) {
                JsonArray signatures = signaturesTest.getAsJsonArray();
                if (signatures.size() == 2) {
                    JsonObject sign2 = signatures.get(1).getAsJsonObject();
                    this.changeDelivery(sign2, useEmailAuthentication ? Integer.toString(DeliveryChannel.EMAIL.getValue()) : Integer.toString(DeliveryChannel.NONE.getValue()));
                    JsonElement fieldsTest = sign2.get("fields");
                    if (null != fieldsTest && fieldsTest.isJsonArray()) {
                        JsonArray fields = fieldsTest.getAsJsonArray();
                        int valuesSet = 0;
                        for (int i = 0; i < fields.size(); ++i) {
                            Object fieldName;
                            JsonElement jsonElement = fields.get(i);
                            if (null == jsonElement || !jsonElement.isJsonObject()) continue;
                            JsonObject jsonObject = jsonElement.getAsJsonObject();
                            JsonElement jsonElement2 = jsonObject.get("name");
                            JsonElement elemValue = jsonObject.get("value");
                            JsonElement elemType = jsonObject.get("type");
                            boolean hasPlacement = false;
                            if (null == jsonElement2 || null == elemValue || null == elemType || !jsonElement2.isJsonPrimitive() || !elemValue.isJsonPrimitive() || !elemType.isJsonPrimitive() || !hasPlacement || !props.containsKey(fieldName = jsonElement2.getAsString())) continue;
                            boolean isCheckbox = "checkbox".equalsIgnoreCase(elemType.getAsString());
                            String newValue = StringUtils.defaultString((String)props.get(fieldName));
                            if (isCheckbox && !newValue.isEmpty()) {
                                newValue = "true";
                            }
                            this.changeValue(jsonObject, newValue);
                            ++valuesSet;
                        }
                        if (nbrPropsToSet > 0 && valuesSet != nbrPropsToSet) {
                            parserError = true;
                        }
                    } else {
                        parserError = true;
                    }
                } else {
                    parserError = true;
                }
            }
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception(OneflowFields.errorTemplateChanged);
        }
        if (docId > 0L) {
            void var25_44;
            String urlParameters = documentToUpdate.toString();
            List<Field> fields = this.getTemplateFields(String.valueOf(docId));
            JsonObject contract = new JsonObject();
            contract.addProperty(OneflowFields.jsonTemplateId, (Number)Integer.valueOf(templateId));
            JsonArray parties = new JsonArray();
            JsonObject party = new JsonObject();
            party.addProperty(OneflowFields.jsonSelf, (Number)1);
            JsonArray participants = new JsonArray();
            JsonObject participant = new JsonObject();
            participant.addProperty(OneflowFields.jsonPositionId, (Number)Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_POSITION));
            participants.add((JsonElement)participant);
            ArrayList<OneflowParticipant> participantsData = new ArrayList<OneflowParticipant>();
            Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                if (entry.getValue().isEmpty() || !entry.getKey().matches("user_[0-9]+_.+")) continue;
                String[] stringArray = entry.getKey().split("user_");
                String string = stringArray[1].substring(0, stringArray[1].indexOf(95));
                String fieldName = stringArray[1].substring(stringArray[1].indexOf(95) + 1, stringArray[1].length());
                if (null != string || null != fieldName) {
                    OneflowParticipant oneflowParticipant = null;
                    boolean isNew = true;
                    for (OneflowParticipant op : participantsData) {
                        if (!op.getId().equals(string)) continue;
                        oneflowParticipant = op;
                        isNew = false;
                    }
                    if (oneflowParticipant == null) {
                        oneflowParticipant = new OneflowParticipant(string);
                    }
                    if (UserField.isMember(fieldName.toLowerCase())) {
                        if (UserField.valueOf(fieldName.toUpperCase()).equals((Object)UserField.DELIVERY_CHANNEL)) {
                            oneflowParticipant.addValues(UserField.valueOf(fieldName.toUpperCase()), String.valueOf((Object)DeliveryChannel.valueOf(entry.getValue())));
                        }
                        if (UserField.valueOf(fieldName.toUpperCase()).equals((Object)UserField.SIGN_METHOD)) {
                            oneflowParticipant.addValues(UserField.valueOf(fieldName.toUpperCase()), String.valueOf((Object)SignMethod.valueOf(entry.getValue())));
                        } else {
                            oneflowParticipant.addValues(UserField.valueOf(fieldName.toUpperCase()), entry.getValue());
                        }
                    }
                    if (isNew) {
                        participantsData.add(oneflowParticipant);
                    }
                }
                it.remove();
            }
            for (OneflowParticipant oneflowParticipant : participantsData) {
                participant = new JsonObject();
                for (Map.Entry<Enum, String> entry : oneflowParticipant.getValues().entrySet()) {
                    String value = entry.getValue();
                    Integer intValue = null;
                    if (entry.getKey().equals((Object)UserField.DELIVERY_CHANNEL) && DeliveryChannel.isMember(entry.getValue())) {
                        intValue = DeliveryChannel.valueOf(value).getValue();
                    }
                    if (entry.getKey().equals((Object)UserField.SIGN_METHOD) && SignMethod.isMember(entry.getValue())) {
                        intValue = SignMethod.valueOf(value).getValue();
                    }
                    if (intValue != null && (entry.getKey().equals((Object)UserField.DELIVERY_CHANNEL) || entry.getKey().equals((Object)UserField.SIGN_METHOD))) {
                        participant.addProperty(((UserField)entry.getKey()).getValue(), (Number)intValue);
                        continue;
                    }
                    participant.addProperty(((UserField)entry.getKey()).getValue(), value);
                }
                participants.add((JsonElement)participant);
            }
            party.add(OneflowFields.jsonParticipants, (JsonElement)participants);
            parties.add((JsonElement)party);
            contract.add(OneflowFields.jsonParties, (JsonElement)parties);
            JsonArray dataList = new JsonArray();
            for (Map.Entry<String, String> entry : props.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty(OneflowFields.jsonKey, OneflowFields.jsonDataField);
                JsonObject dataItemValue = new JsonObject();
                dataItemValue.addProperty(OneflowFields.jsonExternalKey, entry.getKey());
                dataItemValue.addProperty(OneflowFields.jsonValue, entry.getValue());
                jsonObject.add(OneflowFields.jsonValue, (JsonElement)dataItemValue);
                dataList.add((JsonElement)jsonObject);
            }
            contract.add(OneflowFields.jsonData, (JsonElement)dataList);
            System.out.println("contract: " + contract);
            connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiAgreementURL);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(contract.toString());
            outputStreamWriter.close();
            responseCode = connection.getResponseCode();
            System.out.println(responseCode + connection.getResponseMessage());
            if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            Integer n = 0;
            JsonElement jsonElement = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (jsonElement.isJsonObject()) {
                JsonPrimitive id = ((JsonObject)jsonElement).getAsJsonPrimitive(OneflowFields.jsonId);
                Integer n2 = id.getAsInt();
            }
            connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiAgreementURL + var25_44 + "/publish");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            String publishSubject = "Agreement " + var25_44 + " publication";
            String publishMessage = "Agreement " + var25_44 + " has been published";
            JsonObject publishContent = new JsonObject();
            publishContent.addProperty(OneflowFields.jsonSubject, publishSubject);
            publishContent.addProperty(OneflowFields.jsonMessage, publishMessage);
            OutputStreamWriter streamWriter1 = new OutputStreamWriter(connection.getOutputStream());
            streamWriter1.write(publishContent.toString());
            streamWriter1.close();
            connection.disconnect();
        }
        return null;
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        JsonElement signMethods;
        JsonElement optionsElem;
        ArrayList<SignMethod> availableMethods = new ArrayList<SignMethod>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiAgreementURL + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get(OneflowFields.jsonAvailableOptions)) && optionsElem.isJsonObject() && null != (signMethods = ((JsonObject)optionsElem).get(OneflowFields.jsonSignMethods)) && signMethods.isJsonArray()) {
            for (JsonElement signMethod : (JsonArray)signMethods) {
                SignMethod method = SignMethod.valueOf(signMethod.getAsInt());
                if (null == method) continue;
                availableMethods.add(method);
            }
        }
        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        JsonElement deliveryChannels;
        JsonElement optionsElem;
        ArrayList<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiAgreementURL + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get(OneflowFields.jsonAvailableOptions)) && optionsElem.isJsonObject() && null != (deliveryChannels = ((JsonObject)optionsElem).get(OneflowFields.jsonDeliveryChannels)) && deliveryChannels.isJsonArray()) {
            for (JsonElement deliveryChannel : (JsonArray)deliveryChannels) {
                DeliveryChannel channel = DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                if (null == channel) continue;
                availableDeliveries.add(channel);
            }
        }
        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        JsonElement templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiTemplateGroupsURL, "GET", true);
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get(OneflowFields.jsonCollection)) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonObject templateObj = (JsonObject)templateElem;
                JsonPrimitive title = templateObj.getAsJsonPrimitive(OneflowFields.jsonName);
                JsonElement templateId = templateObj.get(OneflowFields.jsonId);
                if (null == templateId || null == title) continue;
                Document template = new Document();
                template.setId(templateId.getAsString());
                template.setTitle(title.getAsString());
                JsonElement templateFieldElem = templateObj.get(OneflowFields.jsonDataFieldSet);
                if (null != templateFieldElem && templateFieldElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive(OneflowFields.jsonId);
                    template.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiAgreementURL + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
            document.setFields(this.getTemplateFields(id));
        }
        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup = new Document();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiTemplateGroupsURL + id, "GET", true);
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != parsedReturn) {
            JsonObject templateGroupObj = (JsonObject)parsedReturn;
            JsonPrimitive title = templateGroupObj.getAsJsonPrimitive(OneflowFields.jsonName);
            JsonElement templateGroupId = templateGroupObj.get(OneflowFields.jsonId);
            if (null != templateGroupId && null != title) {
                templateGroup.setId(templateGroupId.getAsString());
                templateGroup.setTitle(title.getAsString());
                JsonElement fieldSetElem = templateGroupObj.get(OneflowFields.jsonDataFieldSet);
                if (null != fieldSetElem && fieldSetElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)fieldSetElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive(OneflowFields.jsonId);
                    templateGroup.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
            }
        }
        return templateGroup;
    }

    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        JsonElement templateListElem;
        Document templateGroup = this.getTemplateGroup(id);
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiTemplateGroupByIdURL + id, "GET", true);
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get(OneflowFields.jsonCollection)) && templateListElem.isJsonArray()) {
            ArrayList<Field> templatesList = new ArrayList<Field>();
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                JsonObject templateObj;
                JsonElement templateFieldElem;
                if (null == templateElem || !templateElem.isJsonObject() || null == (templateFieldElem = (templateObj = (JsonObject)templateElem).get(OneflowFields.jsonAgreement)) || !templateFieldElem.isJsonObject()) continue;
                JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                JsonPrimitive templateId = templateFieldObj.getAsJsonPrimitive(OneflowFields.jsonId);
                JsonPrimitive title = templateObj.getAsJsonPrimitive(OneflowFields.jsonName);
                if (null == templateId || null == title) continue;
                templatesList.add(new Field(Field.Type.TEMPLATE, title.getAsString(), templateId.getAsString()));
            }
            templateGroup.setFields(templatesList);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        JsonElement templateListElem;
        ArrayList<Field> fields = new ArrayList<Field>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + OneflowFields.apiDataSetURL + id, "GET", true);
        connection.setRequestProperty("Content-Type", "text/plain");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement agreementsFields = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (agreementsFields.isJsonObject() && null != (templateListElem = ((JsonObject)agreementsFields).get(OneflowFields.jsonDataFields)) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                JsonObject templateObj = (JsonObject)templateElem;
                JsonElement name = templateObj.get(OneflowFields.jsonName);
                JsonElement externalKey = templateObj.get(OneflowFields.jsonExternalKey);
                if (null == name || null == externalKey) continue;
                fields.add(new Field(Field.Type.TEXT, name.getAsString(), externalKey.getAsString()));
            }
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonElement titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonElement idElem = jsonObject.get(OneflowFields.jsonId);
            if (idElem != null && idElem.isJsonPrimitive()) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.get(OneflowFields.jsonName)) != null && titleElem.isJsonPrimitive()) {
                document.setTitle(titleElem.getAsString());
            }
        }
        return document;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        return this.getHttpURLConnection(callUrl, method, false);
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method, boolean isSystemCall) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("X-Flow-API-Token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.addRequestProperty("X-Flow-Current-Position", isSystemCall ? SystemProperties.ONEFLOW_SYSTEM_POSITION : SystemProperties.ONEFLOW_CURRENT_POSITION);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    private void changeValue(JsonObject field, String data) {
        this.changeProperty("value", field, data);
    }

    private void changeDelivery(JsonObject parent, String data) {
        this.changeProperty("delivery", parent, data);
    }

    private void changeProperty(String property, JsonObject parent, String data) {
        parent.remove(property);
        parent.addProperty(property, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?");
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString(OneflowFields.sqlTemplateId);
                String fieldName = rs.getString(OneflowFields.sqlFieldName);
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                List<Field> fields = (ArrayList<Field>)optionFields.get(template);
                if (fieldName.matches("user_[0-9]+_.+")) {
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, "Delivery_channel", "DELIVERY_CHANNEL"));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, "Sign_method", "SIGN_METHOD"));
                    continue;
                }
                for (Field field : template.getFields()) {
                    fields = (List)optionFields.get(template);
                    if (!field.getName().equals(fieldName)) continue;
                    if (fields == null) {
                        fields = new ArrayList();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields WHERE element_id = ?");
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString(OneflowFields.sqlTemplateId);
                String fieldName = rs.getString(OneflowFields.sqlFieldName);
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (fieldName.matches("[0-9]+")) {
                    List<Field> allFields = template.getFields();
                    allFields.addAll(this.getTemplatesInGroupAsFields(templateId).getFields());
                    template.setFields(allFields);
                    fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                }
                if (fieldName.matches("user_[0-9]+_.+")) {
                    Pattern fieldPattern = Pattern.compile("_([0-9]+)_(.+)");
                    Matcher matcher = fieldPattern.matcher(fieldName);
                    if (matcher.find()) {
                        fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    }
                } else {
                    for (Field field : template.getFields()) {
                        if (!field.getName().equals(fieldName)) continue;
                        fields.add(field);
                    }
                }
                templateFields.put(template, fields);
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        ArrayList<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT opt.el_text, opt.el_id, opt.id \nFROM " + FormEngine.TABLE_PREFIX + "form_elements el \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \nWHERE el.meta_id = ? AND el.el_type = 'oneflow_user'");
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String userId = rs.getString(OneflowFields.sqlId);
                String fieldName = rs.getString(OneflowFields.sqlElText);
                if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)fieldName)) continue;
                templateFields.add(new Field(Field.Type.USER, fieldName, userId));
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserElementIdByMetaId(int surveyId, DatabaseService databaseService) {
        String elId = "";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT el.id \nFROM " + FormEngine.TABLE_PREFIX + "form_elements el \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \nWHERE el.meta_id = ? AND el.el_type = 'oneflow_user' LIMIT 1");
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                elId = rs.getString(OneflowFields.sqlId);
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return elId;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        String scringDocumentURI = this.getDocumentURI(backToSiteURL, templateId, oneflowParams, request);
        if (scringDocumentURI == null) {
            return null;
        }
        return this.getOneflowBaseURL() + scringDocumentURI;
    }

    public String getOneflowBaseURL() {
        return this.oneflowBaseURL;
    }

    public void setOneflowBaseURL(String oneflowBaseURL) {
        this.oneflowBaseURL = oneflowBaseURL;
    }
}

