/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.FormEngine;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.Document;
import com.imcode.imcms.addon.imsurvey.oneflow.Field;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class OneflowService {
    private static int FAILURE_HTTP_RESPONSE_CODE = 390;
    private String oneflowBaseURL = "https://app.oneflow.com";

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return new OneflowService();
    }

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        return true;
    }

    public List<String> getMissingFields(Document document, List<String> fieldNames) {
        ArrayList<String> missingFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            boolean hasField = false;
            for (Field field : document.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                hasField = true;
            }
            if (hasField) continue;
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public Map<String, List<String>> getSurveyFields(int surveyId, DatabaseService databaseService) {
        return this.getSurveyFields(surveyId, false, databaseService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getSurveyFields(int surveyId, boolean isOneFlowField, DatabaseService databaseService) {
        HashMap<String, List<String>> surveyFields = new HashMap<String, List<String>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT COALESCE(el_fields.template_id, opt_field.template_id) AS template_id, COALESCE(el_fields.field_name, opt_field.field_name) AS field_name" + (isOneFlowField ? ", el_fields.oneflow_field\n" : "\n") + "FROM " + FormEngine.TABLE_PREFIX + "form_elements el \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields opt_field ON opt_field.`option_id` = opt.id \nWHERE el.meta_id = ?" + (isOneFlowField ? " AND el_fields.oneflow_field = 1" : ""));
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                if (StringUtils.isEmpty((String)templateId) || StringUtils.isEmpty((String)fieldName)) continue;
                ArrayList<String> templateFields = (ArrayList<String>)surveyFields.get(templateId);
                if (templateFields == null) {
                    templateFields = new ArrayList<String>();
                    surveyFields.put(templateId, templateFields);
                }
                templateFields.add(fieldName);
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return surveyFields;
    }

    /*
     * WARNING - void declaration
     */
    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props, HttpServletRequest request) throws Exception {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        int nbrPropsToSet = props.size();
        boolean useEmailAuthentication = false;
        if (props.containsKey("imSurveyId")) {
            try {
                int imSurveyId = Integer.parseInt(props.get("imSurveyId"));
                --nbrPropsToSet;
                props.remove("imSurveyId");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException("Oneflow template id is either missing or invalid: " + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/agreements/" + templateId, "GET");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject documentToUpdate = null;
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String errorMessage = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(errorMessage);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            documentToUpdate = parsedReturn.getAsJsonObject();
            JsonObject id = documentToUpdate.getAsJsonObject("template_group");
            docId = id.getAsJsonPrimitive("id").getAsLong();
            this.changeDelivery(documentToUpdate, Integer.toString(DeliveryChannel.EMAIL.getValue()));
            JsonElement signaturesTest = documentToUpdate.get("signatories");
            if (null != signaturesTest && signaturesTest.isJsonArray()) {
                JsonArray signatures = signaturesTest.getAsJsonArray();
                if (signatures.size() == 2) {
                    JsonObject sign2 = signatures.get(1).getAsJsonObject();
                    this.changeDelivery(sign2, useEmailAuthentication ? Integer.toString(DeliveryChannel.EMAIL.getValue()) : Integer.toString(DeliveryChannel.NONE.getValue()));
                    JsonElement fieldsTest = sign2.get("fields");
                    if (null != fieldsTest && fieldsTest.isJsonArray()) {
                        JsonArray fields = fieldsTest.getAsJsonArray();
                        int valuesSet = 0;
                        for (int i = 0; i < fields.size(); ++i) {
                            String fieldName;
                            JsonElement elem2 = fields.get(i);
                            if (null == elem2 || !elem2.isJsonObject()) continue;
                            JsonObject jsonObject = elem2.getAsJsonObject();
                            JsonElement elemName = jsonObject.get("name");
                            JsonElement elemValue = jsonObject.get("value");
                            JsonElement elemType = jsonObject.get("type");
                            boolean hasPlacement = OneflowService.hasPlacement(jsonObject);
                            if (null == elemName || null == elemValue || null == elemType || !elemName.isJsonPrimitive() || !elemValue.isJsonPrimitive() || !elemType.isJsonPrimitive() || !hasPlacement || !props.containsKey(fieldName = elemName.getAsString())) continue;
                            boolean isCheckbox = "checkbox".equalsIgnoreCase(elemType.getAsString());
                            String newValue = StringUtils.defaultString((String)props.get(fieldName));
                            if (isCheckbox && !newValue.isEmpty()) {
                                newValue = "true";
                            }
                            this.changeValue(jsonObject, newValue);
                            ++valuesSet;
                        }
                        if (nbrPropsToSet > 0 && valuesSet != nbrPropsToSet) {
                            parserError = true;
                        }
                    } else {
                        parserError = true;
                    }
                } else {
                    parserError = true;
                }
            }
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception("Error template has changed! Can't create document.");
        }
        if (docId > 0L) {
            void var25_34;
            String urlParameters = documentToUpdate.toString();
            List<Field> fields = this.getTemplateFields(String.valueOf(docId));
            JsonObject contract = new JsonObject();
            contract.addProperty("template_id", (Number)Integer.valueOf(templateId));
            JsonArray parties = new JsonArray();
            JsonObject party = new JsonObject();
            party.addProperty("self", (Number)1);
            JsonArray participants = new JsonArray();
            JsonObject participant = new JsonObject();
            participant.addProperty("self", (Number)1);
            participants.add((JsonElement)participant);
            party.add("participants", (JsonElement)participants);
            parties.add((JsonElement)party);
            JsonObject partyClient = new JsonObject();
            partyClient.addProperty("name", "TestName");
            partyClient.addProperty("country", "SE");
            partyClient.addProperty("orgnr", "5566778899");
            participants = new JsonArray();
            participant = new JsonObject();
            participant.addProperty("type", (Number)1);
            participant.addProperty("fullname", "fullNameTest");
            participant.addProperty("sign_method", (Number)0);
            participant.add("delivery_channel", (JsonElement)JsonNull.INSTANCE);
            participant.addProperty("email", "asd@asd.com");
            participant.addProperty("phone_number", "+123123");
            participants.add((JsonElement)participant);
            partyClient.add("participants", (JsonElement)participants);
            parties.add((JsonElement)partyClient);
            contract.add("parties", (JsonElement)parties);
            JsonArray dataList = new JsonArray();
            for (Map.Entry entry : props.entrySet()) {
                JsonObject dataItem = new JsonObject();
                dataItem.addProperty("key", "data_field");
                JsonObject dataItemValue = new JsonObject();
                dataItemValue.addProperty("external_key", (String)entry.getKey());
                dataItemValue.addProperty("value", (String)entry.getValue());
                dataItem.add("value", (JsonElement)dataItemValue);
                System.out.println("ENTRY" + (String)entry.getKey() + ";" + (String)entry.getValue());
                dataList.add((JsonElement)dataItem);
            }
            contract.add("data", (JsonElement)dataList);
            System.out.println("contract: " + contract);
            connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/agreements/", "POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
            streamWriter.write(contract.toString());
            streamWriter.close();
            responseCode = connection.getResponseCode();
            System.out.println(responseCode + connection.getResponseMessage());
            if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            Integer n = 0;
            JsonElement publishReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (publishReturn.isJsonObject()) {
                JsonPrimitive id = ((JsonObject)publishReturn).getAsJsonPrimitive("id");
                Integer n2 = id.getAsInt();
            }
            connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/agreements/" + var25_34 + "/publish", "POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            String publishSubject = "testSubject";
            String publishMessage = "testMessage";
            JsonObject publishContent = new JsonObject();
            publishContent.addProperty("subject", publishSubject);
            publishContent.addProperty("message", publishMessage);
            OutputStreamWriter streamWriter1 = new OutputStreamWriter(connection.getOutputStream());
            streamWriter1.write(publishContent.toString());
            streamWriter1.close();
            connection.disconnect();
        }
        return null;
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        JsonElement signMethods;
        JsonElement optionsElem;
        ArrayList<SignMethod> availableMethods = new ArrayList<SignMethod>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get("available_options")) && optionsElem.isJsonObject() && null != (signMethods = ((JsonObject)optionsElem).get("delivery_channels")) && signMethods.isJsonArray()) {
            for (JsonElement signMethod : (JsonArray)signMethods) {
                SignMethod method = SignMethod.valueOf(signMethod.getAsInt());
                if (null == method) continue;
                availableMethods.add(method);
            }
        }
        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        JsonElement deliveryChannels;
        JsonElement optionsElem;
        ArrayList<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (optionsElem = ((JsonObject)parsedReturn).get("available_options")) && optionsElem.isJsonObject() && null != (deliveryChannels = ((JsonObject)optionsElem).get("delivery_channels")) && deliveryChannels.isJsonArray()) {
            for (JsonElement deliveryChannel : (JsonArray)deliveryChannels) {
                DeliveryChannel channel = DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                if (null == channel) continue;
                availableDeliveries.add(channel);
            }
        }
        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        JsonElement templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/ext/templategroups/", "GET");
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get("collection")) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonObject templateObj = (JsonObject)templateElem;
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                JsonElement templateId = templateObj.get("id");
                if (null == templateId || null == title) continue;
                Document template = new Document();
                template.setId(templateId.getAsString());
                template.setTitle(title.getAsString());
                JsonElement templateFieldElem = templateObj.get("data_field_set");
                if (null != templateFieldElem && templateFieldElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    template.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
            document.setFields(this.getTemplateFields(id));
        }
        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup = new Document();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/ext/templategroups/" + id, "GET");
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != parsedReturn) {
            JsonObject templateGroupObj = (JsonObject)parsedReturn;
            JsonPrimitive title = templateGroupObj.getAsJsonPrimitive("name");
            JsonElement templateGroupId = templateGroupObj.get("id");
            if (null != templateGroupId && null != title) {
                templateGroup.setId(templateGroupId.getAsString());
                templateGroup.setTitle(title.getAsString());
                JsonElement fieldSetElem = templateGroupObj.get("data_field_set");
                if (null != fieldSetElem && fieldSetElem.isJsonObject()) {
                    JsonObject templateFieldObj = (JsonObject)fieldSetElem;
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    templateGroup.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
            }
        }
        return templateGroup;
    }

    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        JsonElement templateListElem;
        Document templateGroup = this.getTemplateGroup(id);
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/templates/?template_group_id=" + id, "GET");
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get("collection")) && templateListElem.isJsonArray()) {
            ArrayList<Field> templatesList = new ArrayList<Field>();
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                JsonObject templateObj;
                JsonElement templateFieldElem;
                if (null == templateElem || !templateElem.isJsonObject() || null == (templateFieldElem = (templateObj = (JsonObject)templateElem).get("agreement")) || !templateFieldElem.isJsonObject()) continue;
                JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                JsonPrimitive templateId = templateFieldObj.getAsJsonPrimitive("id");
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                if (null == templateId || null == title) continue;
                templatesList.add(new Field(Field.Type.TEMPLATE, title.getAsString(), templateId.getAsString()));
            }
            templateGroup.setFields(templatesList);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        JsonElement templateListElem;
        ArrayList<Field> fields = new ArrayList<Field>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getOneflowBaseURL() + "/api/data_field_sets/" + id, "GET");
        connection.setRequestProperty("Content-Type", "text/plain");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement agreementsFields = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (agreementsFields.isJsonObject() && null != (templateListElem = ((JsonObject)agreementsFields).get("data_fields")) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                JsonObject templateObj = (JsonObject)templateElem;
                JsonElement name = templateObj.get("name");
                JsonElement externalKey = templateObj.get("external_key");
                if (null == name || null == externalKey) continue;
                fields.add(new Field(Field.Type.TEXT, name.getAsString(), externalKey.getAsString()));
            }
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonElement titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonElement idElem = jsonObject.get("id");
            if (idElem != null && idElem.isJsonPrimitive()) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.get("name")) != null && titleElem.isJsonPrimitive()) {
                document.setTitle(titleElem.getAsString());
            }
        }
        return document;
    }

    public static boolean hasPlacement(JsonObject fieldElem) {
        JsonElement elemPlacement = fieldElem.get("collection");
        boolean hasPlacement = elemPlacement != null && elemPlacement.isJsonArray() && elemPlacement.getAsJsonArray().size() > 0;
        JsonElement elemObligatory = fieldElem.get("obligatory");
        boolean hasObligatory = elemObligatory != null && elemObligatory.isJsonPrimitive() && elemObligatory.getAsString().equalsIgnoreCase("true");
        return hasPlacement || hasObligatory;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("X-Flow-API-Token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.addRequestProperty("X-Flow-Current-Position", SystemProperties.ONEFLOW_CURRENT_POSITION);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    private void changeValue(JsonObject field, String data) {
        this.changeProperty("value", field, data);
    }

    private void changeDelivery(JsonObject parent, String data) {
        this.changeProperty("delivery", parent, data);
    }

    private void changeProperty(String property, JsonObject parent, String data) {
        parent.remove(property);
        parent.addProperty(property, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?");
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                for (Field field : template.getFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    ArrayList<Field> fields = (ArrayList<Field>)optionFields.get(template);
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields WHERE element_id = ?");
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getTemplateGroup(templateId);
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (fieldName.matches("[0-9]+")) {
                    List<Field> allFields = template.getFields();
                    allFields.addAll(this.getTemplatesInGroupAsFields(templateId).getFields());
                    template.setFields(allFields);
                    fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                } else {
                    for (Field field : template.getFields()) {
                        if (!field.getName().equals(fieldName)) continue;
                        fields.add(field);
                    }
                }
                templateFields.put(template, fields);
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        ArrayList<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT opt.el_text, opt.el_id, opt.id \nFROM " + FormEngine.TABLE_PREFIX + "form_elements el \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \nLEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \nWHERE el.meta_id = ? AND el.el_type = 'oneflow_user'");
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("id");
                String fieldName = rs.getString("el_text");
                if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)fieldName)) continue;
                templateFields.add(new Field(Field.Type.USER, fieldName, userId));
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return templateFields;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        String scringDocumentURI = this.getDocumentURI(backToSiteURL, templateId, oneflowParams, request);
        if (scringDocumentURI == null) {
            return null;
        }
        return this.getOneflowBaseURL() + scringDocumentURI;
    }

    public String getOneflowBaseURL() {
        return this.oneflowBaseURL;
    }

    public void setOneflowBaseURL(String oneflowBaseURL) {
        this.oneflowBaseURL = oneflowBaseURL;
    }
}

