/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.site.guide;

import com.imcode.imcms.addon.site.SiteUtils;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TextDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class Register
implements Serializable,
Comparable,
JSONAware {
    private int metaId = 0;
    private String name = "";
    private boolean isBprti = false;

    public Register(int metaId, String name, boolean isBprti) {
        this.metaId = metaId;
        this.name = name;
        this.isBprti = isBprti;
    }

    public Register(String name) {
        this.name = name;
    }

    public int getMetaId() {
        return this.metaId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBprti() {
        return this.isBprti;
    }

    public String toAutoCompleteString() {
        return this.name + "<!--" + this.metaId + "," + this.isBprti + "-->";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Register register = (Register)o;
        return this.name.equalsIgnoreCase(register.name);
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public int compareTo(Object o) {
        return this.getName().compareToIgnoreCase(((Register)o).getName());
    }

    public String toString() {
        return "Register{metaId=" + this.metaId + ", name='" + this.name + '\'' + ", isBprti=" + this.isBprti + '}';
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(JSONObject.escape((String)"metaId"));
        sb.append(":");
        sb.append(this.metaId);
        sb.append(",");
        sb.append(JSONObject.escape((String)"name"));
        sb.append(":");
        sb.append("\"" + JSONObject.escape((String)this.name) + "\"");
        sb.append(",");
        sb.append(JSONObject.escape((String)"isBprti"));
        sb.append(":");
        sb.append(this.isBprti);
        sb.append(",");
        sb.append(JSONObject.escape((String)"raw"));
        sb.append(":");
        sb.append("\"" + JSONObject.escape((String)this.toString()) + "\"");
        sb.append("}");
        return sb.toString();
    }

    public static List<Register> getRegisterList(String catTypeNamePos, DocumentService ds, int TEXTFIELD_POS_SYSTEM_NAME_IF_OTHER, int TEXTFIELD_POS_SYSTEM_IS_BPRTI) {
        ArrayList<Register> retList = new ArrayList<Register>();
        int catTypeIdPos = ds.getCategoryType(catTypeNamePos).getId();
        String query = "+status:" + Document.PublicationStatus.APPROVED + " " + "+doc_type_id:" + 2 + " " + "+category_type_id:" + catTypeIdPos;
        List<Document> docs = SiteUtils.getDocuments(query, (Comparator)Document.Comparator.HEADLINE, new SiteUtils.DocumentPublishedPredicate(), ds);
        CollectionUtils.filter(docs, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return "article".equals(((TextDocument)object).getTemplate().getName());
            }
        });
        for (Document doc : docs) {
            TextDocument textDoc = (TextDocument)doc;
            retList.add(new Register(doc.getId(), StringUtils.defaultIfEmpty((String)SiteUtils.getTextFieldDoc(textDoc, TEXTFIELD_POS_SYSTEM_NAME_IF_OTHER), (String)SiteUtils.getTextFieldDoc(textDoc, 1)), SiteUtils.getBooleanFromTextField(textDoc, TEXTFIELD_POS_SYSTEM_IS_BPRTI, false)));
        }
        Collections.sort(retList);
        return retList;
    }
}

