/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import java.util.HashMap;
import java.util.Map;

public enum SignMethod {
    STANDARD_ESIGN(0),
    SMS(1),
    SWEDISH_BANKID(2),
    NORWEGIAN_BANKID(3),
    NORWEGIAN_BANKID_ADES(4),
    DANISH_NEMID(5),
    DANISH_NEMID_ADES(6),
    FINNISH_BANKID(7),
    FINNISH_BANKID_ADES(8);

    private final int id;
    private static final Map<Integer, SignMethod> map;

    private SignMethod(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public static SignMethod valueOf(int id) {
        return map.get(id);
    }

    public static boolean isMember(String value) {
        for (SignMethod field : map.values()) {
            if (!field.name().equals(value.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    static {
        map = new HashMap<Integer, SignMethod>();
        for (SignMethod signMethod : SignMethod.values()) {
            map.put(signMethod.id, signMethod);
        }
    }
}

