/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.Document;
import com.imcode.imcms.addon.imsurvey.oneflow.Field;
import com.imcode.imcms.addon.imsurvey.oneflow.OneflowParticipant;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.oneflow.UserField;
import com.imcode.imcms.addon.imsurvey.utils.OneflowFields;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OneflowService {
    private static final Logger log = Logger.getLogger(OneflowService.class);
    private static final int FAILURE_HTTP_RESPONSE_CODE = 390;
    private static final OneflowService instance = new OneflowService();
    private final Map<String, Document> templateCache = new HashMap<String, Document>();
    private final Map<String, Document> templateGroupFieldCache = new HashMap<String, Document>();
    private final Map<String, Document> templateGroupCache = new HashMap<String, Document>();
    private final Map<String, List<Field>> templateFieldCache = new HashMap<String, List<Field>>();
    private boolean isSwappedToEmail = false;

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return instance;
    }

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDocumentURI(String signSuccessUrl, String templateId, String templateTypeId, Map<String, String> props, HttpServletRequest request) throws Exception {
        JsonPrimitive id;
        int agreementId;
        if (props.containsKey("imSurveyId")) {
            try {
                props.remove("imSurveyId");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException("Oneflow template id is either missing or invalid: " + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/templates/" + templateId, "GET");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject fetchedAgreement = null;
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + templateId + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            fetchedAgreement = parsedReturn.getAsJsonObject();
            JsonObject templateType = fetchedAgreement.getAsJsonObject("template_type");
            docId = templateType.isJsonNull() ? 0L : templateType.get("id").getAsLong();
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception("Error template has changed! Can't create document.");
        }
        if (docId <= 0L) return null;
        String urlParameters = fetchedAgreement.toString();
        JsonObject contract = this.buildContract(templateId, templateTypeId, props);
        connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + "create");
        connection.addRequestProperty("x-oneflow-user-email", SystemProperties.ONEFLOW_SECURITY_TOKEN_EMAIL);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Content-Length", "" + urlParameters.getBytes().length);
        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
        streamWriter.write(contract.toString());
        streamWriter.close();
        responseCode = connection.getResponseCode();
        log.debug((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + ":" + responseCode + connection.getResponseMessage()));
        if (responseCode > 390) {
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + ":" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
            throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
        }
        JsonElement agreementResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (null != agreementResponse && agreementResponse.isJsonObject() && (agreementId = (id = agreementResponse.getAsJsonObject().getAsJsonPrimitive("id")).getAsInt()) > 0) {
            connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + agreementId + "/publish");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + urlParameters.getBytes().length);
            connection.setRequestProperty("x-oneflow-user-email", SystemProperties.ONEFLOW_SECURITY_TOKEN_EMAIL);
            JsonObject publishContent = new JsonObject();
            publishContent.addProperty("subject", "Verifone - Avtal att signera");
            publishContent.addProperty("message", "Hej! <br /><br />Roligt att du vill teckna avtal med oss.<br />V&auml;nligen l&auml;s igenom och signera ditt avtal.<br /><br />Om du inte &auml;r juridisk part i detta avtal s&aring; beh&ouml;ver du inte g&ouml;ra n&aring;got mer just nu.");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(publishContent.toString());
            outputStreamWriter.close();
            connection.disconnect();
            if (connection.getResponseCode() < 390) {
                log.info((Object)("Agreement with id " + agreementId + " was published: " + connection.getResponseCode() + ":" + connection.getResponseMessage()));
                DeliveryChannel deliveryChannel = this.getDeliveryChannelFromContract(contract, 1);
                if (null == deliveryChannel) {
                    log.error((Object)("Can't obtain delivery method for agreement: " + agreementId));
                    connection.disconnect();
                    throw new IOException("Can't obtain delivery method for agreement: " + agreementId);
                }
                if (deliveryChannel != DeliveryChannel.NONE && !this.isSwappedToEmail) return signSuccessUrl;
                JsonElement publishResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                if (publishResponse.isJsonObject()) {
                    String participantId = this.getParticipantId(publishResponse.getAsJsonObject());
                    String accessLink = this.getAccessLink(Integer.toString(agreementId), participantId);
                    if (!accessLink.isEmpty()) {
                        log.debug((Object)("Agreement id:" + agreementId + "\t Participant id: " + participantId + "\t Access link:" + accessLink));
                        return accessLink;
                    }
                }
            } else {
                log.error((Object)("Agreement with id " + agreementId + " wasn't published: " + connection.getResponseCode() + ":" + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
                connection.disconnect();
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
        }
        connection.disconnect();
        return null;
    }

    private int getWorkspaceId(Integer templateId, Integer templateTypeId) throws IOException {
        int workspaceId = 0;
        HttpURLConnection dataToCreateContractRequest = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/helpers" + "/contract_create_data?template_type_id=" + templateTypeId, "GET");
        dataToCreateContractRequest.addRequestProperty("x-oneflow-user-email", SystemProperties.ONEFLOW_SECURITY_TOKEN_EMAIL);
        if (dataToCreateContractRequest.getResponseCode() == 200) {
            JsonElement data = new JsonParser().parse((Reader)new InputStreamReader(dataToCreateContractRequest.getInputStream(), StandardCharsets.UTF_8));
            dataToCreateContractRequest.disconnect();
            for (JsonElement workspace : data.getAsJsonArray()) {
                JsonArray templates = workspace.getAsJsonObject().get("templates").getAsJsonArray();
                for (JsonElement template : templates) {
                    Integer id = template.getAsJsonObject().get("id").getAsInt();
                    if (!id.equals(templateId)) continue;
                    workspaceId = workspace.getAsJsonObject().get("id").getAsInt();
                }
            }
        } else {
            throw new IOException(IOUtils.toString((InputStream)dataToCreateContractRequest.getErrorStream()));
        }
        return workspaceId;
    }

    private JsonObject buildContract(String templateId, String templateTypeId, Map<String, String> props) throws IOException {
        JsonObject contract = new JsonObject();
        contract.addProperty("template_id", (Number)Integer.valueOf(templateId));
        contract.addProperty("workspace_id", (Number)this.getWorkspaceId(Integer.valueOf(templateId), Integer.valueOf(templateTypeId)));
        JsonArray parties = new JsonArray();
        ArrayList<Object> participantsData = new ArrayList<Object>();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (entry.getValue().isEmpty() || !entry.getKey().matches("user_[0-9]+_.+")) continue;
            String[] splittedData = entry.getKey().split("user_");
            String userId = splittedData[1].substring(0, splittedData[1].indexOf(95));
            String fieldName = splittedData[1].substring(splittedData[1].indexOf(95) + 1);
            if (!userId.isEmpty() && !fieldName.isEmpty()) {
                Object oneflowParticipant = null;
                boolean isNew = true;
                for (OneflowParticipant oneflowParticipant2 : participantsData) {
                    if (!oneflowParticipant2.getId().equals(userId)) continue;
                    oneflowParticipant = oneflowParticipant2;
                    isNew = false;
                }
                if (oneflowParticipant == null) {
                    oneflowParticipant = new OneflowParticipant(userId);
                }
                if (UserField.isMember(fieldName.toLowerCase())) {
                    UserField userField = UserField.valueOf(fieldName.toUpperCase());
                    if (userField.equals((Object)UserField.DELIVERY_CHANNEL)) {
                        ((OneflowParticipant)oneflowParticipant).addValues(userField, String.valueOf((Object)DeliveryChannel.valueOf(entry.getValue())));
                    }
                    if (userField.equals((Object)UserField.SIGN_METHOD)) {
                        ((OneflowParticipant)oneflowParticipant).addValues(userField, String.valueOf((Object)SignMethod.valueOf(entry.getValue())));
                    } else {
                        ((OneflowParticipant)oneflowParticipant).addValues(userField, entry.getValue());
                    }
                }
                if (isNew) {
                    participantsData.add(oneflowParticipant);
                }
            }
            it.remove();
        }
        Collections.sort(participantsData);
        for (OneflowParticipant oneflowParticipant : participantsData) {
            JsonObject partyClient = new JsonObject();
            JsonArray participants = new JsonArray();
            JsonObject participant = new JsonObject();
            for (Map.Entry<Enum, String> entry : oneflowParticipant.getValues().entrySet()) {
                Enum key = entry.getKey();
                String string = entry.getValue();
                if (key.equals((Object)UserField.COMPANY_NAME)) {
                    partyClient.addProperty(UserField.NAME.getValue(), string);
                    continue;
                }
                if (key.equals((Object)UserField.IDENTIFICATION_NUMBER) || key.equals((Object)UserField.COUNTRY_CODE)) {
                    partyClient.addProperty(((UserField)key).getValue(), string);
                    continue;
                }
                if (key.equals((Object)UserField.DELIVERY_CHANNEL) && DeliveryChannel.isMember(entry.getValue())) {
                    if (DeliveryChannel.valueOf(string) == DeliveryChannel.NONE) {
                        this.isSwappedToEmail = true;
                    }
                    participant.addProperty(((UserField)key).getValue(), entry.getValue().toLowerCase());
                    continue;
                }
                if (key.equals((Object)UserField.TYPE)) {
                    OneflowParticipant.Type type = OneflowParticipant.Type.valueOf(Integer.parseInt(string));
                    participant.addProperty("signatory", Boolean.valueOf(type.isSignatory()));
                    JsonObject permissions = new JsonObject();
                    permissions.addProperty("contract:update", Boolean.valueOf(type.isContractUpdate()));
                    participant.add("_permissions", (JsonElement)permissions);
                    continue;
                }
                if (key.equals((Object)UserField.SIGN_METHOD)) {
                    participant.addProperty(((UserField)key).getValue(), string.toLowerCase());
                    continue;
                }
                participant.addProperty(((UserField)key).getValue(), string);
            }
            JsonElement tmpName = participant.get(UserField.NAME.getValue());
            JsonElement tmpEmail = participant.get(UserField.EMAIL.getValue());
            if (null == tmpName || tmpName.getAsString().isEmpty() || null == tmpEmail || tmpEmail.getAsString().isEmpty()) continue;
            participants.add((JsonElement)participant);
            partyClient.add("participants", (JsonElement)participants);
            partyClient.addProperty("type", "company");
            parties.add((JsonElement)partyClient);
        }
        this.addContractCreator(contract);
        contract.add("parties", (JsonElement)parties);
        JsonArray dataList = new JsonArray();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            JsonObject dataItemValue = new JsonObject();
            dataItemValue.addProperty("custom_id", entry.getKey());
            dataItemValue.addProperty("value", entry.getValue());
            dataList.add((JsonElement)dataItemValue);
        }
        contract.add("data_fields", (JsonElement)dataList);
        log.info((Object)("contract:" + contract));
        return contract;
    }

    private void addContractCreator(JsonObject contract) {
        JsonObject myParty = new JsonObject();
        myParty.addProperty(UserField.NAME.getValue(), SystemProperties.ONEFLOW_CREATOR_NAME);
        myParty.addProperty(UserField.COUNTRY_CODE.getValue(), SystemProperties.ONEFLOW_CREATOR_COUNTRY_CODE);
        myParty.addProperty(UserField.IDENTIFICATION_NUMBER.getValue(), SystemProperties.ONEFLOW_CREATOR_IDENTIFICATION_NUMBER);
        JsonArray participants = new JsonArray();
        OneflowParticipant.Type participant = OneflowParticipant.Type.ORGANIZER;
        JsonObject creatorParticipant = new JsonObject();
        creatorParticipant.addProperty("signatory", Boolean.valueOf(participant.isSignatory()));
        creatorParticipant.addProperty("organizer", Boolean.valueOf(participant.isOrganizer()));
        creatorParticipant.addProperty(UserField.EMAIL.getValue(), SystemProperties.ONEFLOW_SECURITY_TOKEN_EMAIL);
        JsonObject permissions = new JsonObject();
        permissions.addProperty("contract:update", Boolean.valueOf(participant.isContractUpdate()));
        creatorParticipant.add("_permissions", (JsonElement)permissions);
        participants.add((JsonElement)creatorParticipant);
        myParty.add("participants", (JsonElement)participants);
        contract.add("my_party", (JsonElement)myParty);
    }

    private String getAccessLink(String agreementId, String userId) throws IOException {
        JsonObject tokenBody = new JsonObject();
        tokenBody.addProperty("type", "form");
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + agreementId + "/participants/" + userId + "/access_link");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
        streamWriter.write(tokenBody.toString());
        streamWriter.close();
        int responseCode = connection.getResponseCode();
        log.debug((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + agreementId + "/participants/" + userId + "/tokens :" + responseCode + connection.getResponseMessage()));
        if (responseCode > 390) {
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + agreementId + "/participants/" + userId + "/tokens :" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
            throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
        }
        String accessLink = "";
        JsonElement tokenResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (tokenResponse.isJsonObject()) {
            accessLink = tokenResponse.getAsJsonObject().get("access_link").getAsString();
        }
        return accessLink;
    }

    private String getParticipantId(JsonObject publishedAgreementResponse) {
        String participantId = "";
        JsonArray parties = publishedAgreementResponse.getAsJsonArray("parties");
        if (null != parties) {
            for (JsonElement tmpParty : parties) {
                JsonObject participant;
                JsonObject party = tmpParty.getAsJsonObject();
                if (party.get("my_party").getAsBoolean() || !(participant = party.getAsJsonArray("participants").get(0).getAsJsonObject()).get("signatory").getAsBoolean()) continue;
                JsonElement idElement = participant.getAsJsonObject().get("id");
                participantId = idElement.getAsString();
            }
        }
        return participantId;
    }

    private DeliveryChannel getDeliveryChannelFromContract(JsonObject contract, Integer participantNumber) {
        JsonArray userParties = contract.getAsJsonArray("parties");
        JsonObject party = userParties.get(0).getAsJsonObject();
        if (userParties.size() > 1) {
            party = userParties.get(participantNumber.intValue()).getAsJsonObject();
        }
        JsonElement deliveryChannel = party.getAsJsonArray("participants").get(0).getAsJsonObject().get(UserField.DELIVERY_CHANNEL.getValue());
        return DeliveryChannel.valueOf(deliveryChannel.getAsString().toUpperCase());
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        JsonArray signMethods;
        JsonObject optionsElem;
        ArrayList<SignMethod> availableMethods = new ArrayList<SignMethod>();
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + ":" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement signMethodsResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (signMethodsResponse.isJsonObject() && null != (optionsElem = signMethodsResponse.getAsJsonObject().getAsJsonObject("available_options")) && null != (signMethods = optionsElem.getAsJsonArray("sign_methods"))) {
            for (JsonElement signMethod : signMethods) {
                SignMethod method = SignMethod.valueOf(((JsonObject)signMethod).get("name").getAsString().toUpperCase());
                availableMethods.add(method);
            }
        }
        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        JsonArray deliveryChannels;
        JsonObject optionsElem;
        ArrayList<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + id + ":" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement deliveryChannelResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (deliveryChannelResponse.isJsonObject() && null != (optionsElem = deliveryChannelResponse.getAsJsonObject().getAsJsonObject("available_options")) && null != (deliveryChannels = optionsElem.getAsJsonArray("delivery_channels"))) {
            for (JsonElement deliveryChannel : deliveryChannels) {
                DeliveryChannel channel = DeliveryChannel.valueOf(((JsonObject)deliveryChannel).get("name").getAsString().toUpperCase());
                availableDeliveries.add(channel);
            }
        }
        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        JsonArray templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/template_types/", "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/template_types/" + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement templateGroupsResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (templateGroupsResponse.isJsonObject() && null != (templateListElem = ((JsonObject)templateGroupsResponse).getAsJsonArray("data"))) {
            for (JsonElement templateElem : templateListElem) {
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonObject templateObj = templateElem.getAsJsonObject();
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                JsonPrimitive templateId = templateObj.getAsJsonPrimitive("id");
                if (null == templateId || null == title) continue;
                Document template = new Document();
                template.setId(templateId.getAsString());
                template.setTitle(title.getAsString());
                template.setFields(this.getTemplateFields(templateId.getAsString()));
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/contracts/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
            document.setFields(this.getTemplateFields(id));
        }
        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup;
        if (this.templateGroupCache.get(id) != null) {
            templateGroup = this.templateGroupCache.get(id);
        } else {
            templateGroup = new Document();
            HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/template_types/" + id, "GET", true);
            if (connection.getResponseCode() > 390) {
                String error = IOUtils.toString((InputStream)connection.getErrorStream());
                connection.disconnect();
                log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/template_types/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
                throw new IOException(error);
            }
            LinkedList<Field> fields = new LinkedList<Field>();
            JsonElement templateGroupResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            connection.disconnect();
            if (templateGroupResponse.isJsonObject()) {
                JsonObject templateGroupObj = templateGroupResponse.getAsJsonObject();
                JsonPrimitive title = templateGroupObj.getAsJsonPrimitive("name");
                JsonPrimitive templateGroupId = templateGroupObj.getAsJsonPrimitive("id");
                if (null != templateGroupId && null != title) {
                    templateGroup.setId(templateGroupId.getAsString());
                    templateGroup.setTitle(title.getAsString());
                    JsonArray templateListElem = templateGroupObj.getAsJsonArray("data_fields");
                    fields.addAll(this.jsonsTemplateArrayToFields(templateListElem));
                }
            }
            templateGroup.setFields(fields);
            this.templateFieldCache.put(id, fields);
            this.templateGroupCache.put(id, templateGroup);
        }
        return templateGroup;
    }

    private List<Field> jsonsTemplateArrayToFields(JsonArray templateListElem) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (JsonElement templateElem : templateListElem) {
            JsonObject templateObj = templateElem.getAsJsonObject();
            JsonPrimitive name = templateObj.getAsJsonPrimitive("name");
            JsonPrimitive customId = templateObj.getAsJsonPrimitive("custom_id");
            if (null == name || null == customId) continue;
            fields.add(new Field(Field.Type.TEXT, name.getAsString(), customId.getAsString()));
        }
        return fields;
    }

    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        Document templateGroup;
        if (this.templateGroupFieldCache.get(id) != null) {
            templateGroup = this.templateGroupFieldCache.get(id);
        } else {
            JsonArray templateGroupCollection;
            templateGroup = this.getTemplateGroup(id);
            HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/helpers" + "/contract_create_data?template_type_id=" + id, "GET", true);
            connection.addRequestProperty("x-oneflow-user-email", SystemProperties.ONEFLOW_SECURITY_TOKEN_EMAIL);
            if (connection.getResponseCode() > 390) {
                String error = IOUtils.toString((InputStream)connection.getErrorStream());
                connection.disconnect();
                log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/template_types/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
                throw new IOException(error);
            }
            JsonElement templateGroupResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            connection.disconnect();
            if (null != templateGroupResponse && templateGroupResponse.isJsonArray() && null != (templateGroupCollection = templateGroupResponse.getAsJsonArray())) {
                ArrayList<Field> templateList = new ArrayList<Field>();
                for (JsonElement templateElem : templateGroupCollection) {
                    if (null == templateElem || !templateElem.isJsonObject()) continue;
                    JsonArray templates = templateElem.getAsJsonObject().getAsJsonArray("templates");
                    for (JsonElement template : templates) {
                        if (template.isJsonNull()) continue;
                        JsonPrimitive name = template.getAsJsonObject().getAsJsonPrimitive("name");
                        JsonPrimitive templateId = template.getAsJsonObject().getAsJsonPrimitive("id");
                        if (null == templateId || null == name) continue;
                        templateList.add(new Field(Field.Type.TEMPLATE, name.getAsString(), templateId.getAsString()));
                    }
                }
                templateGroup.setFields(templateList);
            }
            this.templateGroupFieldCache.put(id, templateGroup);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        LinkedList<Field> fields;
        if (this.templateFieldCache.get(id) != null) {
            fields = this.templateFieldCache.get(id);
        } else {
            JsonArray templateListElem;
            fields = new LinkedList();
            HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/helpers" + "/template_types/" + id + "data_fields", "GET", true);
            connection.setRequestProperty("Content-Type", "text/plain");
            int responseCode = connection.getResponseCode();
            if (responseCode == 404) {
                connection.disconnect();
                return null;
            }
            if (responseCode > 390) {
                String error = IOUtils.toString((InputStream)connection.getErrorStream());
                connection.disconnect();
                log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/data_field_sets/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
                throw new IOException(error);
            }
            JsonElement agreementsFields = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            connection.disconnect();
            if (null != agreementsFields && null != (templateListElem = agreementsFields.getAsJsonObject().get("data_fields").getAsJsonArray())) {
                fields.addAll(this.jsonsTemplateArrayToFields(templateListElem));
            }
            this.templateFieldCache.put(id, fields);
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonPrimitive titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonPrimitive idElem = jsonObject.getAsJsonPrimitive("id");
            if (idElem != null) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.getAsJsonPrimitive("name")) != null) {
                document.setTitle(titleElem.getAsString());
            }
        }
        return document;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        return this.getHttpURLConnection(callUrl, method, false);
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method, boolean isSystemCall) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("x-oneflow-api-token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_OPTIONS_TEMPLATE_FIELDS);
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                Document template;
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                if (this.templateCache.get(templateId) != null) {
                    template = this.templateCache.get(templateId);
                } else {
                    this.templateCache.put(templateId, this.getTemplateGroup(templateId));
                    template = this.templateCache.get(templateId);
                }
                if (template == null) continue;
                List<Field> fields = (ArrayList<Field>)optionFields.get(template);
                if (fieldName.matches("user_[0-9]+_.+")) {
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, UserField.DELIVERY_CHANNEL.name(), UserField.DELIVERY_CHANNEL.name().toUpperCase()));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, UserField.SIGN_METHOD.name(), UserField.SIGN_METHOD.name().toUpperCase()));
                    continue;
                }
                for (Field field : template.getFields()) {
                    fields = (List)optionFields.get(template);
                    if (!field.getName().equals(fieldName)) continue;
                    if (fields == null) {
                        fields = new ArrayList();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_TEMPLATE_FIELDS);
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                Document template;
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                if (this.templateCache.get(templateId) != null) {
                    template = this.templateCache.get(templateId);
                } else {
                    this.templateCache.put(templateId, this.getTemplateGroup(templateId));
                    template = this.templateCache.get(templateId);
                }
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (fieldName.matches("[0-9]+")) {
                    List<Field> allFields = template.getFields();
                    List<Field> newFields = this.getTemplatesInGroupAsFields(templateId).getFields();
                    for (Field newField : newFields) {
                        if (allFields.contains(newField)) continue;
                        allFields.add(newField);
                    }
                    template.setFields(allFields);
                    fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                }
                if (fieldName.matches("user_[0-9]+_.+")) {
                    Pattern fieldPattern = Pattern.compile("_([0-9]+)_(.+)");
                    Matcher matcher = fieldPattern.matcher(fieldName);
                    if (matcher.find()) {
                        fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    }
                } else {
                    for (Field field : template.getFields()) {
                        if (!field.getName().equals(fieldName)) continue;
                        fields.add(field);
                    }
                }
                templateFields.put(template, fields);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        ArrayList<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_TEMPLATE_USERS);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("id");
                String fieldName = rs.getString("el_text");
                if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)fieldName)) continue;
                templateFields.add(new Field(Field.Type.USER, fieldName, userId));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserElementIdByMetaId(int surveyId, DatabaseService databaseService) {
        String elId = "";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_ID_BY_META_ID);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                elId = rs.getString("id");
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return elId;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, String templateTypeId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        return this.getDocumentURI(backToSiteURL, templateId, templateTypeId, oneflowParams, request);
    }
}

