/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.addon.imsurvey.FormEngine;
import com.imcode.imcms.addon.imsurvey.FormEngineSettings;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.utils.API;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Mail;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.Template;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import com.imcode.util.MultipartHttpServletRequest;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static final String ACCOUNT_CATEGORY_TYPE_NAME = "imSurvey_AccountCategories";
    public static final String CLIENT_CATEGORY_TYPE_NAME = "client";
    public static final String SERVICE_CATEGORY_TYPE_NAME = "service";
    public static final String SURVEY_TEMPLATE_NAME = "imsurvey_surveypage_babs";
    public static final String SURVEY_ADMIN_TEMPLATE_NAME = "service_imsurvey";
    public static final String SURVEY_ADMIN_PAGE_ALIAS = "imsurvey";
    public static final String FORM_CATEGORY_NAME = "imSurvey_surveypage";
    public static final String IMSURVEY_ROLE_NAME = "imsurvey";
    private static final String ADD_FORM_ELEMENT = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements (meta_id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, el_maxlength, el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_FORM_ELEMENT_OPTION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements_options (el_id, el_value, el_text, el_selected, el_sort, el_export_label) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String ADD_FORM_VALIDATION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_validation (item_id, type, value, group_with) VALUES (?, ?, ?, ?)";
    private static final String ADD_CONDITION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "conditions ( parent_question_id, question_id, all_values_required, text) VALUES (?, ?, ?, ?)";
    private static final String ADD_CONDITION_VALUE = "INSERT INTO " + FormEngine.TABLE_PREFIX + "condition_values ( condition_id, option_id ) VALUES (?,?)";
    private static final String ADD_SCRIVE_FIELD = "INSERT INTO " + FormEngine.TABLE_PREFIX + "element_scrive_fields ( element_id, template_id, field_name, oneflow_field ) VALUES (?,?,?,?)";
    private static final String ADD_SCRIVE_FIELD_OPTION = "INSERT INTO " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields(option_id, template_id, field_name) VALUES(?, ?, ?)";
    private static final String ADD_FORM_SETTING = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_settings (meta_id, id, setting) VALUES (?, ?, ?)";
    private static final String GET_SETTINGS = "SELECT id, setting FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";
    private static final String GET_FORM_ELEMENTS = "SELECT id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, el_maxlength, el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";
    private static final String GET_FORM_ELEMENT_OPTIONS = "SELECT el_value, el_text, el_selected, el_sort, id, el_export_label FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id = ?";
    private static final String GET_MAX_ID_FORM_ELEMENTS = "SELECT MAX(id) FROM " + FormEngine.TABLE_PREFIX + "form_elements";
    private static final String GET_FORM_VALIDATIONS = "SELECT type, value, group_with FROM " + FormEngine.TABLE_PREFIX + "form_validation WHERE item_id = ?";
    private static final String GET_OLD_DEPENDENCIES = "SELECT c.condition_id, c.parent_question_id, c.question_id, c.all_values_required, c.text FROM " + FormEngine.TABLE_PREFIX + "conditions c LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON c.parent_question_id = e.id WHERE e.meta_id = ?";
    private static final String GET_OLD_DEPENDENCIES_OPTIONS = "SELECT v.condition_id, v.option_id, c.condition_id, c.question_id, e.id, e.meta_id FROM " + FormEngine.TABLE_PREFIX + "condition_values v LEFT JOIN " + FormEngine.TABLE_PREFIX + "conditions c ON v.condition_id = c.condition_id LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON c.question_id = e.id WHERE e.meta_id = ?";
    private static final String GET_OLD_FIELDS = "SELECT f.element_id, f.template_id, f.field_name, f.oneflow_field FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields f LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements e ON f.element_id = e.id WHERE e.meta_id = ?";
    private static final String DELETE_FORM_SETTING = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";
    private static final String DELETE_FORM_ELEMENTS = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id IN (SELECT id FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?)";
    private static final String DELETE_FORM_ELEMENTS_OPTIONS = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";

    public static void copySurvey(int from_meta, int meta_id, HttpServletRequest request, JspWriter out) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        TextDocument toDoc = documentService.getTextDocument(meta_id);
        TextDocument fromDoc = documentService.getTextDocument(from_meta);
        toDoc.setHtmlTextField(6301, fromDoc.getTextField(6301).getText());
        toDoc.setHtmlTextField(6302, fromDoc.getTextField(6302).getText());
        dbUtil.sqlUpdateQuery(DELETE_FORM_SETTING, (Object[])new String[]{toDoc.getId() + ""});
        String[][] arrNewSettings = dbUtil.sqlQueryMulti(GET_SETTINGS, (Object[])new String[]{String.valueOf(from_meta)});
        String oldMailFromElementId = "";
        if (arrNewSettings != null) {
            for (String[] arrNewSetting : arrNewSettings) {
                try {
                    String id = arrNewSetting[0];
                    String setting = arrNewSetting[1];
                    if (id.equals("205")) {
                        oldMailFromElementId = setting;
                        continue;
                    }
                    dbUtil.sqlUpdateQuery(ADD_FORM_SETTING, (Object[])new String[]{toDoc.getId() + "", id, setting});
                }
                catch (Exception e) {
                    Utils.writeLog("Error inserting new settings: " + e.toString());
                }
            }
        }
        try {
            dbUtil.sqlUpdateQuery(DELETE_FORM_ELEMENTS_OPTIONS, (Object[])new String[]{toDoc.getId() + ""});
            dbUtil.sqlUpdateQuery(DELETE_FORM_ELEMENTS, (Object[])new String[]{toDoc.getId() + ""});
        }
        catch (Exception e) {
            Utils.writeLog("Error clearing out old elements or options: " + e.toString());
        }
        String[][] arrNewFormElements = null;
        try {
            arrNewFormElements = dbUtil.sqlQueryMulti(GET_FORM_ELEMENTS, (Object[])new String[]{String.valueOf(from_meta)});
        }
        catch (Exception e) {
            Utils.writeLog("Error getting old form elements: " + e.toString());
        }
        if (arrNewFormElements != null) {
            HashMap<Integer, Integer> elementsMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> conditionsMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> optionsMap = new HashMap<Integer, Integer>();
            for (String[] arrNewFormElement : arrNewFormElements) {
                String id = arrNewFormElement[0];
                String el_type = arrNewFormElement[1];
                String el_sort = arrNewFormElement[2];
                String el_count = arrNewFormElement[3];
                String el_tablerows = arrNewFormElement[4];
                String el_size = arrNewFormElement[5];
                String el_rows = arrNewFormElement[6];
                String el_maxlength = arrNewFormElement[7];
                String el_multiple = arrNewFormElement[8];
                String el_label = arrNewFormElement[9];
                String el_label_fullwidth = arrNewFormElement[10];
                String tab_nbr = arrNewFormElement[11];
                String export_label = arrNewFormElement[12];
                String depends_on_show = arrNewFormElement[13];
                String depends_on_all_required = arrNewFormElement[14];
                String el_hidden_val = arrNewFormElement[15];
                String el_default_val = arrNewFormElement[16];
                String el_default_del = arrNewFormElement[17];
                String el_infotext = arrNewFormElement[18];
                String el_infotext_type = arrNewFormElement[19];
                try {
                    Connection connection = databaseService.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(ADD_FORM_ELEMENT, 1);
                    preparedStatement.setInt(1, toDoc.getId());
                    preparedStatement.setString(2, el_type);
                    preparedStatement.setInt(3, Integer.parseInt(el_sort));
                    preparedStatement.setInt(4, Integer.parseInt(el_count));
                    preparedStatement.setInt(5, Integer.parseInt(el_tablerows));
                    preparedStatement.setInt(6, Integer.parseInt(el_size));
                    preparedStatement.setInt(7, Integer.parseInt(el_rows));
                    preparedStatement.setInt(8, Integer.parseInt(el_maxlength));
                    preparedStatement.setInt(9, Integer.parseInt(el_multiple.matches("true|1|-1") ? "1" : "0"));
                    preparedStatement.setString(10, el_label);
                    preparedStatement.setInt(11, Integer.parseInt(el_label_fullwidth.matches("true|1|-1") ? "1" : "0"));
                    preparedStatement.setString(12, tab_nbr);
                    preparedStatement.setString(13, export_label);
                    preparedStatement.setString(14, depends_on_show);
                    preparedStatement.setString(15, depends_on_all_required);
                    preparedStatement.setString(16, el_hidden_val);
                    preparedStatement.setString(17, el_default_val);
                    preparedStatement.setInt(18, el_default_del != null ? Integer.parseInt(el_default_del.matches("true|1|-1") ? "1" : "0") : 0);
                    preparedStatement.setString(19, el_infotext);
                    preparedStatement.setInt(20, el_infotext_type != null ? Integer.parseInt(el_infotext_type.matches("true|1|-1") ? "1" : "0") : 0);
                    preparedStatement.executeUpdate();
                    ResultSet resultSet = preparedStatement.getGeneratedKeys();
                    if (resultSet.next()) {
                        int newID = resultSet.getInt(1);
                        elementsMap.put(Integer.parseInt(id), newID);
                        if (oldMailFromElementId.equals(id)) {
                            dbUtil.sqlUpdateQuery(ADD_FORM_SETTING, (Object[])new String[]{toDoc.getId() + "", "205", "" + newID});
                        }
                    }
                    resultSet.close();
                    preparedStatement.close();
                    connection.close();
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying form elements: " + e.toString());
                    return;
                }
                try {
                    String[][] arrNewFormElementsOptions = dbUtil.sqlQueryMulti(GET_FORM_ELEMENT_OPTIONS, (Object[])new String[]{id});
                    if (arrNewFormElementsOptions != null && arrNewFormElementsOptions.length > 0) {
                        String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);
                        for (String[] arrNewFormElementsOption : arrNewFormElementsOptions) {
                            try {
                                String op_value = arrNewFormElementsOption[0];
                                String op_text = arrNewFormElementsOption[1];
                                String op_selected = arrNewFormElementsOption[2];
                                String op_sort = arrNewFormElementsOption[3];
                                String op_id = arrNewFormElementsOption[4];
                                String op_export_label = arrNewFormElementsOption[5];
                                Connection connection = databaseService.getConnection();
                                PreparedStatement preparedStatement = connection.prepareStatement(ADD_FORM_ELEMENT_OPTION, 1);
                                preparedStatement.setInt(1, Integer.parseInt(insertedElementId));
                                preparedStatement.setString(2, op_value);
                                preparedStatement.setString(3, op_text);
                                preparedStatement.setBoolean(4, op_selected.matches("true|1|-1"));
                                preparedStatement.setInt(5, Integer.parseInt(op_sort));
                                preparedStatement.setString(6, op_export_label);
                                preparedStatement.executeUpdate();
                                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                                String s = "";
                                if (resultSet.next()) {
                                    int newID = resultSet.getInt(1);
                                    optionsMap.put(Integer.parseInt(arrNewFormElementsOption[4]), newID);
                                    String getOptionFields = "SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?";
                                    preparedStatement = connection.prepareStatement(getOptionFields);
                                    preparedStatement.setInt(1, Integer.parseInt(op_id));
                                    ResultSet scriveOptionFields = preparedStatement.executeQuery();
                                    preparedStatement = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields(option_id, template_id, field_name) VALUES(?, ?, ?)");
                                    while (scriveOptionFields.next()) {
                                        preparedStatement.setInt(1, newID);
                                        preparedStatement.setInt(2, scriveOptionFields.getInt("template_id"));
                                        preparedStatement.setString(3, scriveOptionFields.getString("field_name"));
                                        preparedStatement.addBatch();
                                    }
                                    preparedStatement.executeBatch();
                                    s = s + id + ", " + newID + "\n";
                                }
                                Utils.writeLog("optionsMap: " + s);
                                resultSet.close();
                                preparedStatement.close();
                                connection.close();
                            }
                            catch (Exception e) {
                                Utils.writeLog("Error copying form element options: " + e.toString());
                                return;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying element options: " + e.toString());
                }
                try {
                    String insertedElementId = dbUtil.sqlQueryStr(GET_MAX_ID_FORM_ELEMENTS, new Object[0]);
                    String[][] arrNewValidation = dbUtil.sqlQueryMulti(GET_FORM_VALIDATIONS, (Object[])new String[]{id});
                    if (arrNewValidation == null) continue;
                    for (String[] anArrNewValidation : arrNewValidation) {
                        String type = anArrNewValidation[0];
                        String value = anArrNewValidation[1];
                        String group_with = anArrNewValidation[2];
                        dbUtil.sqlUpdateQuery(ADD_FORM_VALIDATION, (Object[])new String[]{insertedElementId, type, value, group_with});
                    }
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying validation: " + e.toString());
                }
            }
            try {
                String[][] conditions = dbUtil.sqlQueryMulti(GET_OLD_DEPENDENCIES, (Object[])new String[]{"" + from_meta});
                StringBuilder s = new StringBuilder();
                for (String[] condition : conditions) {
                    s.append(condition[0]).append(", ").append(condition[1]).append(", ").append(condition[2]).append(", ").append(condition[3]).append(", ").append(condition[4]).append("\n");
                }
                Utils.writeLog("Old dependency conditions:\n" + s);
                s = new StringBuilder();
                for (String[] condition : conditions) {
                    try {
                        Connection connection = databaseService.getConnection();
                        PreparedStatement preparedStatement = connection.prepareStatement(ADD_CONDITION, 1);
                        Utils.writeLog("Inserting new condition: " + elementsMap.get(Integer.parseInt(condition[1])) + "," + elementsMap.get(Integer.parseInt(condition[2])) + "," + condition[3] + ", " + condition[4]);
                        preparedStatement.setInt(1, (Integer)elementsMap.get(Integer.parseInt(condition[1])));
                        preparedStatement.setInt(2, (Integer)elementsMap.get(Integer.parseInt(condition[2])));
                        preparedStatement.setBoolean(3, condition[3] != null && condition[3].matches("true|1|-1"));
                        preparedStatement.setString(4, condition[4]);
                        preparedStatement.executeUpdate();
                        ResultSet resultSet = preparedStatement.getGeneratedKeys();
                        if (resultSet.next()) {
                            int newID = resultSet.getInt(1);
                            conditionsMap.put(Integer.parseInt(condition[0]), newID);
                        }
                        resultSet.close();
                        preparedStatement.close();
                        connection.close();
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting new conditions: " + e.toString());
                        return;
                    }
                }
            }
            catch (Exception e) {
                Utils.writeLog("Error updating dependencies: " + e.toString());
            }
            StringBuilder s = new StringBuilder();
            try {
                String[][] options;
                for (String[] option : options = dbUtil.sqlQueryMulti(GET_OLD_DEPENDENCIES_OPTIONS, (Object[])new String[]{"" + from_meta})) {
                    s.append(option[0]).append(", ").append(option[1]).append(", ").append(option[2]).append(", ").append(option[3]).append(", ").append(option[4]).append(", ").append(option[5]).append("\n");
                }
                Utils.writeLog("Old dependency options:\n" + s);
                s = new StringBuilder();
                for (String[] option : options) {
                    try {
                        String newCondition_id = "" + conditionsMap.get(Integer.parseInt(option[0]));
                        s.append("Condition_id fr\u00e5n ").append(option[0]).append(" -> ").append(newCondition_id).append(" ");
                        String newOption_id = "" + optionsMap.get(Integer.parseInt(option[1]));
                        s.append(" Option_id fr\u00e5n ").append(option[1]).append(" -> ").append(newOption_id).append("\n");
                        dbUtil.sqlUpdateQuery(ADD_CONDITION_VALUE, (Object[])new String[]{newCondition_id, newOption_id});
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting condition_value: " + e.toString());
                    }
                }
                Utils.writeLog("new dependency options: " + s);
            }
            catch (Exception e) {
                Utils.writeLog("new dependency options: " + s);
                Utils.writeLog("Error updating dependency options: " + e.toString());
            }
            try {
                String[][] fields;
                for (String[] field : fields = dbUtil.sqlQueryMulti(GET_OLD_FIELDS, (Object[])new String[]{"" + from_meta})) {
                    try {
                        String newElement_id = "" + elementsMap.get(Integer.parseInt(field[0]));
                        dbUtil.sqlUpdateQuery(ADD_SCRIVE_FIELD, (Object[])new String[]{newElement_id, field[1], field[2], field[3]});
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting oneflow field: " + e.toString());
                    }
                }
            }
            catch (Exception e) {
                Utils.writeLog("Error updating oneflow fields: " + e.toString());
            }
        }
        try {
            documentService.saveChanges((Document)toDoc);
        }
        catch (Exception e) {
            Utils.writeLog("Error saving doc changes: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject exportSurvey(int from_meta, HttpServletRequest request) {
        imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        databaseService = imcmsSystem.getDatabaseService();
        dbUtil = new DBUtil(databaseService);
        connection = null;
        preparedStatement = null;
        rs = null;
        formData = new JsonObject();
        try {
            connection = databaseService.getConnection();
            arrNewSettings = dbUtil.sqlQueryMulti(Utils.GET_SETTINGS, (Object[])new String[]{String.valueOf(from_meta)});
            if (arrNewSettings != null) {
                formSettings = new JsonArray();
                formData.add("settings", (JsonElement)formSettings);
                for (String[] arrNewSetting : arrNewSettings) {
                    try {
                        settingObject = new JsonObject();
                        id = arrNewSetting[0];
                        setting = arrNewSetting[1];
                        if (id.equals("205")) continue;
                        settingObject.addProperty("id", id);
                        settingObject.addProperty("setting", setting);
                        formSettings.add((JsonElement)settingObject);
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting new settings: " + e.toString());
                    }
                }
            }
            arrNewFormElements = null;
            try {
                arrNewFormElements = dbUtil.sqlQueryMulti(Utils.GET_FORM_ELEMENTS, (Object[])new String[]{String.valueOf(from_meta)});
            }
            catch (Exception e) {
                Utils.writeLog("Error getting old form elements: " + e.toString());
            }
            if (arrNewFormElements == null) return formData;
            jsonElements = new JsonArray();
            jsonValidations = new JsonArray();
            formData.add("elements", (JsonElement)jsonElements);
            formData.add("validationRules", (JsonElement)jsonValidations);
            for (String[] arrNewFormElement : arrNewFormElements) {
                block39: {
                    elementObject = new JsonObject();
                    elementObject.addProperty("id", arrNewFormElement[0]);
                    elementObject.addProperty("el_type", arrNewFormElement[1]);
                    elementObject.addProperty("el_sort", arrNewFormElement[2]);
                    elementObject.addProperty("el_count", arrNewFormElement[3]);
                    elementObject.addProperty("el_tablerows", arrNewFormElement[4]);
                    elementObject.addProperty("el_size", arrNewFormElement[5]);
                    elementObject.addProperty("el_rows", arrNewFormElement[6]);
                    elementObject.addProperty("el_maxlength", arrNewFormElement[7]);
                    elementObject.addProperty("el_multiple", arrNewFormElement[8]);
                    elementObject.addProperty("el_label", arrNewFormElement[9]);
                    elementObject.addProperty("el_label_fullwidth", arrNewFormElement[10]);
                    elementObject.addProperty("tab_nbr", arrNewFormElement[11]);
                    elementObject.addProperty("export_label", arrNewFormElement[12]);
                    elementObject.addProperty("depends_on_show", arrNewFormElement[13]);
                    elementObject.addProperty("depends_on_all_required", arrNewFormElement[14]);
                    elementObject.addProperty("el_hidden_val", arrNewFormElement[15]);
                    elementObject.addProperty("el_default_val", arrNewFormElement[16]);
                    elementObject.addProperty("el_default_del", arrNewFormElement[17]);
                    elementObject.addProperty("el_infotext", arrNewFormElement[18]);
                    elementObject.addProperty("el_infotext_type", arrNewFormElement[19]);
                    jsonElements.add((JsonElement)elementObject);
                    id = arrNewFormElement[0];
                    elementOptions = new JsonArray();
                    elementObject.add("elementOptions", (JsonElement)elementOptions);
                    try {
                        arrNewFormElementsOptions = dbUtil.sqlQueryMulti(Utils.GET_FORM_ELEMENT_OPTIONS, (Object[])new String[]{id});
                        if (arrNewFormElementsOptions == null || arrNewFormElementsOptions.length <= 0) break block39;
                        var21_50 = arrNewFormElementsOptions;
                        var22_51 = var21_50.length;
                        var23_53 = 0;
lbl70:
                        // 2 sources

                        while (var23_53 < var22_51) {
                            arrNewFormElementsOption = var21_50[var23_53];
                            try {
                                elementOption = new JsonObject();
                                elementOption.addProperty("op_value", arrNewFormElementsOption[0]);
                                elementOption.addProperty("op_text", arrNewFormElementsOption[1]);
                                elementOption.addProperty("op_selected", arrNewFormElementsOption[2]);
                                elementOption.addProperty("op_sort", arrNewFormElementsOption[3]);
                                elementOption.addProperty("op_id", arrNewFormElementsOption[4]);
                                elementOption.addProperty("op_export_label", arrNewFormElementsOption[5]);
                                elementOptions.add((JsonElement)elementOption);
                                elementOptionScriveFields = new JsonArray();
                                elementOption.add("optionScriveFields", (JsonElement)elementOptionScriveFields);
                                getOptionFields = "SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?";
                                preparedStatement = connection.prepareStatement(getOptionFields);
                                preparedStatement.setInt(1, Integer.parseInt(arrNewFormElementsOption[4]));
                                rs = preparedStatement.executeQuery();
                                while (rs.next()) {
                                    scriveOption = new JsonObject();
                                    scriveOption.addProperty("id", (Number)rs.getInt("id"));
                                    scriveOption.addProperty("option_id", (Number)rs.getInt("option_id"));
                                    scriveOption.addProperty("template_id", (Number)rs.getInt("template_id"));
                                    scriveOption.addProperty("field_name", rs.getString("field_name"));
                                    elementOptionScriveFields.add((JsonElement)scriveOption);
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Exception e) {
                                Utils.writeLog("Error copying form element options: " + e.toString());
                                elementOptionScriveFields = null;
                                DbUtils.closeQuietly((Connection)connection, preparedStatement, rs);
                                return elementOptionScriveFields;
                            }
                        }
                        break block39;
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error copying element options: " + e.toString());
                        break block39;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++var23_53;
                        ** GOTO lbl70
                    }
                }
                try {
                    insertedElementId = dbUtil.sqlQueryStr(Utils.GET_MAX_ID_FORM_ELEMENTS, new Object[0]);
                    arrNewValidation = dbUtil.sqlQueryMulti(Utils.GET_FORM_VALIDATIONS, (Object[])new String[]{id});
                    if (arrNewValidation == null) continue;
                    for (String[] anArrNewValidation : arrNewValidation) {
                        type = anArrNewValidation[0];
                        value = anArrNewValidation[1];
                        group_with = anArrNewValidation[2];
                        validationObject = new JsonObject();
                        validationObject.addProperty("item_id", id);
                        validationObject.addProperty("type", type);
                        validationObject.addProperty("value", value);
                        validationObject.addProperty("group_with", group_with);
                        jsonValidations.add((JsonElement)validationObject);
                    }
                }
                catch (Exception e) {
                    Utils.writeLog("Error copying validation: " + e.toString());
                }
            }
            try {
                oldDependenciesOptions = new JsonArray();
                formData.add("dependices", (JsonElement)oldDependenciesOptions);
                conditions = dbUtil.sqlQueryMulti(Utils.GET_OLD_DEPENDENCIES, (Object[])new String[]{"" + from_meta});
                Utils.writeLog("Old dependency conditions:\n");
                for (String[] condition : conditions) {
                    try {
                        oldDependency = new JsonObject();
                        oldDependency.addProperty("condition_id", condition[0]);
                        oldDependency.addProperty("parent_question_id", condition[1]);
                        oldDependency.addProperty("question_id", condition[2]);
                        oldDependency.addProperty("all_values_required", condition[3]);
                        oldDependency.addProperty("text", condition[4]);
                        oldDependenciesOptions.add((JsonElement)oldDependency);
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting new conditions: " + e.toString());
                    }
                }
            }
            catch (Exception e) {
                Utils.writeLog("Error updating dependencies: " + e.toString());
            }
            s = new StringBuilder();
            try {
                oldDependeciesOptionsValues = new JsonArray();
                formData.add("dependicesOptions", (JsonElement)oldDependeciesOptionsValues);
                for (String[] option : options = dbUtil.sqlQueryMulti(Utils.GET_OLD_DEPENDENCIES_OPTIONS, (Object[])new String[]{"" + from_meta})) {
                    s.append(option[0]).append(", ").append(option[1]).append(", ").append(option[2]).append(", ").append(option[3]).append(", ").append(option[4]).append(", ").append(option[5]).append("\n");
                }
                Utils.writeLog("Old dependency options:\n" + s);
                s = new StringBuilder();
                for (String[] option : options) {
                    try {
                        oldDependencyValue = new JsonObject();
                        oldDependencyValue.addProperty("condition_id", (Number)Integer.parseInt(option[0]));
                        oldDependencyValue.addProperty("option_id", (Number)Integer.parseInt(option[1]));
                        oldDependeciesOptionsValues.add((JsonElement)oldDependencyValue);
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting condition_value: " + e.toString());
                    }
                }
                Utils.writeLog("new dependency options: " + s);
            }
            catch (Exception e) {
                Utils.writeLog("new dependency options: " + s);
                Utils.writeLog("Error updating dependency options: " + e.toString());
            }
            try {
                jsonFields = new JsonArray();
                formData.add("fields", (JsonElement)jsonFields);
                var16_35 = fields = dbUtil.sqlQueryMulti(Utils.GET_OLD_FIELDS, (Object[])new String[]{"" + from_meta});
                var17_39 = var16_35.length;
                var18_42 = 0;
                while (var18_42 < var17_39) {
                    field = var16_35[var18_42];
                    try {
                        jsonField = new JsonObject();
                        jsonField.addProperty("element_id", field[0]);
                        jsonField.addProperty("template_id", field[1]);
                        jsonField.addProperty("field_name", field[2]);
                        jsonField.addProperty("oneflow_field", field[3]);
                        jsonFields.add((JsonElement)jsonField);
                    }
                    catch (Exception e) {
                        Utils.writeLog("Error inserting oneflow field: " + e.toString());
                    }
                    ++var18_42;
                }
                return formData;
            }
            catch (Exception e) {
                Utils.writeLog("Error updating oneflow fields: " + e.toString());
                return formData;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return formData;
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, preparedStatement, rs);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean importSurvey(int toMetaId, MultipartHttpServletRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 41[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Role getClientAdminRole(UserService userService) {
        return userService.getRole("kund_admin");
    }

    public static Role getServiceAdminRole(UserService userService) {
        return userService.getRole("service_admin_imsurvey");
    }

    public static boolean canAdminster(User user, UserService userService) {
        Role clientAdminRole = Utils.getClientAdminRole(userService);
        Role serviceAdminRole = Utils.getServiceAdminRole(userService);
        return user.isSuperAdmin() || clientAdminRole != null && user.hasRole(clientAdminRole) || serviceAdminRole != null && user.hasRole(Utils.getServiceAdminRole(userService));
    }

    public static CategoryType getClientCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(CLIENT_CATEGORY_TYPE_NAME);
    }

    public static CategoryType getSurveyCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(ACCOUNT_CATEGORY_TYPE_NAME);
    }

    public static CategoryType getServiceCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(SERVICE_CATEGORY_TYPE_NAME);
    }

    public static Category getSurveyCategory(DocumentService documentService) {
        return documentService.getCategory(Utils.getServiceCategoryType(documentService), "imsurvey");
    }

    public static TextDocument getSurveyDocument(DocumentService documentService) {
        return documentService.getTextDocument("imsurvey");
    }

    public static Template getSurveyTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_TEMPLATE_NAME);
    }

    public static Template getSurveyAdminTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_ADMIN_TEMPLATE_NAME);
    }

    public static CategoryType getFormCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(FORM_CATEGORY_NAME);
    }

    public static Category getFormCategory(DocumentService documentService) {
        CategoryType formCategoryType = Utils.getFormCategoryType(documentService);
        if (formCategoryType == null) {
            return null;
        }
        return documentService.getCategory(formCategoryType, FORM_CATEGORY_NAME);
    }

    public static Map<String, List<String>> getTemplateFields(HttpServletRequest request) {
        HashMap<String, List<String>> templateFields = new HashMap<String, List<String>>();
        String[] templateIds = request.getParameterValues("scrive_template");
        String[] fieldNames = request.getParameterValues("scrive_field");
        String[] fieldTypes = request.getParameterValues("el_type");
        String fieldType = fieldTypes != null ? fieldTypes[0] : "";
        String[] userIds = request.getParameterValues("scrive_field_user");
        if (templateIds != null) {
            for (String templateId : templateIds) {
                if (StringUtils.isBlank((String)templateId)) continue;
                List fields = templateFields.computeIfAbsent(templateId, k -> new ArrayList());
                if (fieldNames != null) {
                    Pattern fieldPattern = Pattern.compile(templateId + "_(.+)");
                    int i = 0;
                    for (String fieldName : fieldNames) {
                        String scriveFieldName;
                        Matcher matcher = fieldPattern.matcher(fieldName);
                        if (fieldType.equals("scrive_button")) {
                            String agreementId;
                            fieldPattern = Pattern.compile("_(.+)");
                            matcher = fieldPattern.matcher(fieldName);
                            if (matcher.find() && !fields.contains(agreementId = fieldNames[0].substring(0, matcher.start()))) {
                                fields.add(agreementId);
                            }
                        } else if (matcher.matches() && !fields.contains(scriveFieldName = matcher.group(1))) {
                            String userId;
                            String string = userId = userIds != null ? userIds[i] : "";
                            if (!userId.isEmpty()) {
                                if (!fields.contains("user_" + userId + "_" + scriveFieldName)) {
                                    fields.add("user_" + userId + "_" + scriveFieldName);
                                }
                            } else {
                                fields.add(scriveFieldName);
                            }
                        }
                        ++i;
                    }
                }
                String signMethod = request.getParameter("scrive_field_sign");
                String deliveryChannel = request.getParameter("scrive_field_delivery");
                if (null != signMethod && !signMethod.isEmpty()) {
                    fields.add(SignMethod.class.getSimpleName() + "_" + SignMethod.valueOf(signMethod.substring(signMethod.indexOf(95) + 1)).name());
                }
                if (null == deliveryChannel || deliveryChannel.isEmpty()) continue;
                fields.add(DeliveryChannel.class.getSimpleName() + "_" + DeliveryChannel.valueOf(deliveryChannel.substring(deliveryChannel.indexOf(95) + 1)).name());
            }
        }
        return templateFields;
    }

    public static void writeLog(String str) {
        FileOutputStream fos;
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "imSurvey_sms_send_log.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc, DataSource[] att, ContentManagementSystem imcmsSystem, boolean htmlMail) {
        Utils.writeLog("Sending email: " + to[0]);
        try {
            MailService mailService = imcmsSystem.getMailService();
            Mail mail = new Mail(from, to, subject, body);
            if (htmlMail) {
                mail.setHtmlBody(body);
            }
            if (cc != null && cc.length > 0 && !cc[0].equals("")) {
                mail.setCcAddresses(cc);
            }
            if (bcc != null && bcc.length > 0 && !bcc[0].equals("")) {
                mail.setBccAddresses(bcc);
            }
            if (att != null && att.length > 0) {
                mail.setAttachments(att);
            }
            mailService.sendMail(mail);
            return true;
        }
        catch (Exception ex) {
            Utils.writeLog("mailexception= " + ex.getMessage());
            Utils.writeLog("from= " + from + " to = " + to[0] + " subject= " + subject + " body= " + body);
            return false;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc, DataSource[] att, ContentManagementSystem imcmsSystem) {
        return Utils.sendMail(from, to, subject, body, cc, bcc, att, imcmsSystem, false);
    }

    public static void notifyAbouScriveOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        String from = settings.getMailFrom();
        String[] to = new String[]{settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty((String)settings.getScriveOutOfSyncSubject(), (String)"Survey out of sync with Scrive: "));
        subject.append(" ").append(surveyId);
        String linkToSurvey = Utils.getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(Utils.createLink(linkToSurvey, linkToSurvey));
        Utils.sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static void notifyAbouOneflowOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        String from = settings.getMailFrom();
        String[] to = new String[]{settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty((String)settings.getScriveOutOfSyncSubject(), (String)"Survey out of sync with Oneflow: "));
        subject.append(" ").append(surveyId);
        String linkToSurvey = Utils.getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(Utils.createLink(linkToSurvey, linkToSurvey));
        Utils.sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static String getBaseURL(HttpServletRequest request) {
        boolean isLocalhost = "localhost".equals(request.getServerName());
        return request.getScheme() + "://" + request.getServerName() + (isLocalhost ? ":" + request.getServerPort() : "") + request.getContextPath();
    }

    public static String createLink(String href, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href='").append(href).append("'>");
        sb.append(text);
        sb.append("</a>");
        return sb.toString();
    }

    public static String getTemplateIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveButtonPattern = Pattern.compile("scrive_button_(.+)");
        Map params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveButtonPattern.matcher(name);
            if (!matcher.matches()) continue;
            templateId = matcher.group(1);
            break;
        }
        return templateId;
    }

    public static String getTemplateGroupIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveHiddenPattern = Pattern.compile("scrive_([0-9]+)_([0-9]+)");
        Map params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveHiddenPattern.matcher(name);
            if (!matcher.matches()) continue;
            templateId = matcher.group(1);
            break;
        }
        return templateId;
    }

    public static Map<String, String> getFieldValuesForTemplate(String templateId, ServletRequest request) {
        Pattern scriveFieldParamPattern = Pattern.compile("scrive_([0-9]+)_(.+)");
        if (!StringUtils.isBlank((String)templateId)) {
            Map params = request.getParameterMap();
            HashMap<String, String> scriveParams = new HashMap<String, String>();
            for (String name : params.keySet()) {
                Matcher matcher = scriveFieldParamPattern.matcher(name);
                if (!matcher.matches()) continue;
                String fieldTemplateId = matcher.group(1);
                String fieldName = matcher.group(2);
                String value = ((String[])params.get(name))[0];
                if (!templateId.equals(fieldTemplateId)) continue;
                scriveParams.put(fieldName, value);
            }
            return scriveParams;
        }
        return null;
    }

    public static Map<String, String> getScriveFieldsFromDb(String templateId, ServletRequest request) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Properties getProperties() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream("server.properties");
            prop.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return prop;
        }
    }

    public static API getAPI(String stringValue) {
        if (stringValue.equals(API.ONEFLOW.toString())) {
            return API.ONEFLOW;
        }
        return API.SCRIVE;
    }
}

