package com.imcode.imcms.addon.imsurvey.oneflow;

import java.util.HashMap;
import java.util.Map;

/**
 * Storing keyValue for participant
 * Created by dmizem from Ubrainians for ImCode on 20.01.17
 *
 * @author dmizem
 */
public class OneflowParticipant implements Comparable {

    private String id;

    private Map<Enum, String> values = new HashMap<>();

    public OneflowParticipant() {
    }

    public OneflowParticipant(String id) {
        this.id = id;
    }

    public OneflowParticipant(String id, Map<Enum, String> values) {
        this.id = id;
        this.values = values;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<Enum, String> getValues() {
        return values;
    }

    public void setValues(Map<Enum, String> values) {
        this.values = values;
    }

    public void addValues(Enum field, String value) {
        values.put(field, value);
    }

    @Override
    public int compareTo(Object o) {
        return this.getId().compareTo(((OneflowParticipant) o).getId());
    }

	enum Type {
		INFLUENCER(0, false, false, true),
		SIGNATORY(1, true, false, true),
		ORGANIZER(2, false, true, true),
		VIEWER(3, false, false, false);

		private final int id;
		private final boolean signatory;
		private final boolean organizer;
		private final boolean contractUpdate;

		private static final Map<Integer, Type> map = new HashMap<>();

		static {
			for (Type type : Type.values()) {
				map.put(type.id, type);
			}
		}

		Type(int id, boolean signatory, boolean organizer, boolean contractUpdate) {
			this.id = id;
			this.signatory = signatory;
			this.organizer = organizer;
			this.contractUpdate = contractUpdate;
		}

		public int getId() {
			return id;
		}

		public boolean isSignatory() {
			return signatory;
		}

		public boolean isOrganizer() {
			return organizer;
		}

		public boolean isContractUpdate() {
			return contractUpdate;
		}

		public static Type valueOf(int id) {
			return map.get(id);
		}
	}
}
