package com.imcode.imcms.addon.imsurvey.listeners;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.imcode.imcms.addon.imsurvey.services.*;
import com.imcode.imcms.addon.imsurvey.utils.ImSurveyUtils;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class StartupListener implements ServletContextListener {

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Injector injector = Guice.createInjector(new AbstractModule() {
            @Override
            protected void configure() {
                bind(ClientDetailsService.class).to(StaticClientDetailServiceImpl.class);
                bind(RightsChecker.class).to(RightsCheckerImpl.class);
            }
        });

        injector.getInstance(ImSurveyUtils.class);
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {

    }
}
