package com.imcode.imcms.addon.imsurvey;

import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.api.*;
import imcode.server.Imcms;
import org.apache.commons.lang.StringUtils;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class Utils {
    public static final String ACCOUNT_CATEGORY_TYPE_NAME = "imSurvey_AccountCategories";
    public static final String CLIENT_CATEGORY_TYPE_NAME = "client";
    public static final String SERVICE_CATEGORY_TYPE_NAME = "service";

	//This should be "imsurvey_surveypage". May need a better sollution in the future
    public static final String SURVEY_TEMPLATE_NAME = "imsurvey_surveypage_babs";

    public static final String SURVEY_ADMIN_TEMPLATE_NAME = "service_imsurvey";
    public static final String SURVEY_ADMIN_PAGE_ALIAS = "imsurvey";
    public final static String FORM_CATEGORY_NAME = "imSurvey_surveypage";
    public final static String IMSURVEY_ROLE_NAME = "imsurvey";

    public static void copySurvey(int form_meta, int meta_id, HttpServletRequest request, JspWriter out) {

        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest(request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();

        TextDocument editDoc = documentService.getTextDocument(meta_id);
        TextDocument formDoc = documentService.getTextDocument(form_meta);

        editDoc.setHtmlTextField((SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 301), formDoc.getTextField(SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 301).getText());
        editDoc.setHtmlTextField((SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 302), formDoc.getTextField(SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 302).getText());

        DBUtil dbUtil = new DBUtil(databaseService);
        String sql = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";
        dbUtil.sqlUpdateQuery(sql, new String[]{editDoc.getId() + ""});

        // Get new settings from selected form
        sql = "SELECT id, setting FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ?";
        String[][] arrNewSettings = dbUtil.sqlQueryMulti(sql, new String[]{String.valueOf(form_meta)});

        String oldMailFromElementId = "";
        // Insert new settings into this form
        if (arrNewSettings != null) {
            for (int i = 0; i < arrNewSettings.length; i++) {
                String id = arrNewSettings[i][0];
                String setting = arrNewSettings[i][1];

                if (id.equals(FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "")) {
                    oldMailFromElementId = setting;
                    continue;
                }
                sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_settings" +
                        " (meta_id, id, setting) " +
                        "VALUES" +
                        " (?, ?, ?)";
                dbUtil.sqlUpdateQuery(sql, new String[]{editDoc.getId() + "", id, setting});
            }
        }

        // Remove old form element options from this form
        sql = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id IN (SELECT id FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?)";
        dbUtil.sqlUpdateQuery(sql, new String[]{editDoc.getId() + ""});

        // Remove old form elements from this form
        sql = "DELETE FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";
        dbUtil.sqlUpdateQuery(sql, new String[]{editDoc.getId() + ""});

        // Get new form elements from selected form
        sql = "SELECT id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows," +
                " el_maxlength, el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type " +
                "FROM " + FormEngine.TABLE_PREFIX + "form_elements WHERE meta_id = ?";
        String[][] arrNewFormElements = dbUtil.sqlQueryMulti(sql, new String[]{String.valueOf(form_meta)});


        if (arrNewFormElements != null) {
            Map map = new HashMap<String, String>();
            for (int i = 0; i < arrNewFormElements.length; i++) {
                String id = arrNewFormElements[i][0];
                String el_type = arrNewFormElements[i][1];
                String el_sort = arrNewFormElements[i][2];
                String el_count = arrNewFormElements[i][3];
                String el_tablerows = arrNewFormElements[i][4];
                String el_size = arrNewFormElements[i][5];
                String el_rows = arrNewFormElements[i][6];
                String el_maxlength = arrNewFormElements[i][7];
                String el_multiple = arrNewFormElements[i][8];
                String el_label = arrNewFormElements[i][9];
                String el_label_fullwidth = arrNewFormElements[i][10];
                String tab_nbr = arrNewFormElements[i][11];

                String export_label = arrNewFormElements[i][12];
                String depends_on_show = arrNewFormElements[i][13];
	            String depends_on_all_required = arrNewFormElements[i][14];

	            String el_hidden_val = arrNewFormElements[i][15];
	            String el_default_val = arrNewFormElements[i][16];
	            String el_default_del = arrNewFormElements[i][17];
	            String el_infotext = arrNewFormElements[i][18];
	            String el_infotext_type = arrNewFormElements[i][19];

                sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements" +
                        " (meta_id, el_type, el_sort, el_count, el_tablerows, el_size, el_rows, el_maxlength," +
                        " el_multiple, el_label, el_label_fullwidth, tab_nbr, el_exportlabel, depends_on_show, depends_on_all_required, el_hidden_val, el_default_val, el_default_del, el_infotext, el_infotext_type ) " +
                        "VALUES" +
                        " (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";


                try {
                    java.sql.Connection connection = databaseService.getConnection();
                    java.sql.PreparedStatement preparedStatement = connection.prepareStatement(sql, java.sql.Statement.RETURN_GENERATED_KEYS);

                    preparedStatement.setInt(1, editDoc.getId());
                    preparedStatement.setString(2, el_type);
                    preparedStatement.setInt(3, Integer.parseInt(el_sort));
                    preparedStatement.setInt(4, Integer.parseInt(el_count));
                    preparedStatement.setInt(5, Integer.parseInt(el_tablerows));
                    preparedStatement.setInt(6, Integer.parseInt(el_size));
                    preparedStatement.setInt(7, Integer.parseInt(el_rows));
                    preparedStatement.setInt(8, Integer.parseInt(el_maxlength));
                    preparedStatement.setInt(9, Integer.parseInt((el_multiple.matches("true|1|-1") ? "1" : "0")));
                    preparedStatement.setString(10, el_label);
                    preparedStatement.setInt(11, Integer.parseInt(el_label_fullwidth.matches("true|1|-1") ? "1" : "0"));
                    preparedStatement.setString(12, tab_nbr);
                    preparedStatement.setString(13, export_label);
                    preparedStatement.setString(14, depends_on_show);
	                preparedStatement.setString(15, depends_on_all_required);
	                preparedStatement.setString(16, el_hidden_val);
	                preparedStatement.setString(17, el_default_val);
	                preparedStatement.setInt(18, el_default_del!=null?Integer.parseInt((el_default_del.matches("true|1|-1") ? "1" : "0")):0);
	                preparedStatement.setString(19, el_infotext);
	                preparedStatement.setInt(20, el_infotext_type!=null?Integer.parseInt((el_infotext_type.matches("true|1|-1") ? "1" : "0")):0);

                    preparedStatement.executeUpdate();


                    java.sql.ResultSet resultSet = preparedStatement.getGeneratedKeys();
                    if (resultSet.next()) {
                        int newID = resultSet.getInt(1);

                        map.put(id, newID);
                        if (oldMailFromElementId.equals(id)) {
                            sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_settings" +
                                    " (meta_id, id, setting) " +
                                    "VALUES" +
                                    " (?, ?, ?)";
                            dbUtil.sqlUpdateQuery(sql, new String[]{editDoc.getId() + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "", "" + newID});
                        }
                    }
                    resultSet.close();
                    preparedStatement.close();
                    connection.close();
                } catch (Exception e) {
                    try {
                        out.println("Error: " + e.toString());
                    } catch (Exception e2) {
                    }
                    return;
                }
                /*	dbUtil.sqlUpdateQuery(sql, new String[]{ editDoc.getId() + "", el_type, el_sort, el_count, el_tablerows, el_size,
                el_rows, el_maxlength, (el_multiple.matches("true|1|-1") ? "1" : "0"), el_label, (el_label_fullwidth.matches("true|1|-1") ? "1" : "0")}) ;*/

                // Get new form element options from selected form item - If exists
                sql = "SELECT el_value, el_text, el_selected, el_sort " +
                        "FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE el_id = ?";
                String[][] arrNewFormElementsOptions = dbUtil.sqlQueryMulti(sql, new String[]{id});
                if (arrNewFormElementsOptions != null && arrNewFormElementsOptions.length > 0) {
                    // Get new element-ID
                    sql = "SELECT MAX(id) FROM " + FormEngine.TABLE_PREFIX + "form_elements";
                    String insertedElementId = dbUtil.sqlQueryStr(sql, new Object[0]);

                    for (int j = 0; j < arrNewFormElementsOptions.length; j++) {
                        String op_value = arrNewFormElementsOptions[j][0];
                        String op_text = arrNewFormElementsOptions[j][1];
                        String op_selected = arrNewFormElementsOptions[j][2];
                        String op_sort = arrNewFormElementsOptions[j][3];
                        sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements_options" +
                                " (el_id, el_value, el_text, el_selected, el_sort) " +
                                "VALUES" +
                                " (?, ?, ?, ?, ?)";
                        dbUtil.sqlUpdateQuery(sql, new String[]{
                                insertedElementId,
                                op_value,
                                op_text,
                                (op_selected.matches("true|1|-1") ? "1" : "0"),
                                op_sort
                        });
                    }
                }

                // Get new element-ID
                sql = "SELECT MAX(id) FROM " + FormEngine.TABLE_PREFIX + "form_elements";
                String insertedElementId = dbUtil.sqlQueryStr(sql, new Object[0]);

                // Get new validation from selected form
                sql = "SELECT type, value, group_with FROM " + FormEngine.TABLE_PREFIX + "form_validation WHERE item_id = ?";
                String[][] arrNewValidation = dbUtil.sqlQueryMulti(sql, new String[]{id});

                // Insert new validation into this form
                if (arrNewValidation != null) {
                    for (int j = 0; j < arrNewValidation.length; j++) {
                        String type = arrNewValidation[j][0];
                        String value = arrNewValidation[j][1];
                        String group_with = arrNewValidation[j][2];

                        sql = "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_validation" +
                                " (item_id, type, value, group_with) " +
                                "VALUES" +
                                " (?, ?, ?, ?)";
                        dbUtil.sqlUpdateQuery(sql, new String[]{insertedElementId, type, value, group_with});
                    }
                }

            }
            sql = "UPDATE " + FormEngine.TABLE_PREFIX + "form_elements SET depends_on_id=? WHERE depends_on_id=? AND meta_id=?";

            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pairs = (Map.Entry) it.next();
                dbUtil.sqlUpdateQuery(sql, new String[]{"" + pairs.getValue(), "" + pairs.getKey(), "" + editDoc.getId()});
                it.remove(); // avoids a ConcurrentModificationException
            }

        }
        try {
            documentService.saveChanges(editDoc);
        } catch (Exception e) {
        }
    }

    /* TODO: delegate to client implementation */
    public static Role getClientAdminRole(UserService userService) {
        return userService.getRole("kund_admin");
    }

    /* TODO: delegate to client implementation */
    public static Role getServiceAdminRole(UserService userService) {
        return userService.getRole("service_admin_imsurvey");
    }

    public static boolean canAdminster(User user, UserService userService) {
        Role clientAdminRole = getClientAdminRole(userService);
        Role serviceAdminRole = getServiceAdminRole(userService);
        return user.isSuperAdmin() || (clientAdminRole != null && user.hasRole(clientAdminRole)) || (serviceAdminRole != null && user.hasRole(getServiceAdminRole(userService)));
    }

    /* TODO: delegate to client implementation */
    public static CategoryType getClientCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(CLIENT_CATEGORY_TYPE_NAME);
    }

    /* TODO: delegate to client implementation */
    public static CategoryType getSurveyCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(ACCOUNT_CATEGORY_TYPE_NAME);
    }

    /* TODO: delegate to client implementation */
    public static CategoryType getServiceCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(SERVICE_CATEGORY_TYPE_NAME);
    }

    /* TODO: delegate to client implementation */
    public static Category getSurveyCategory(DocumentService documentService) {
        return documentService.getCategory(getServiceCategoryType(documentService), "imsurvey");
    }

    /* TODO: delegate to client implementation */
    public static TextDocument getSurveyDocument(DocumentService documentService) {
        return documentService.getTextDocument("imsurvey");
    }

    /* TODO: delegate to client implementation */
    public static Template getSurveyTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_TEMPLATE_NAME);
    }

    public static Template getSurveyAdminTemplate(TemplateService templateService) {
        return templateService.getTemplate(SURVEY_ADMIN_TEMPLATE_NAME);
    }

    public static CategoryType getFormCategoryType(DocumentService documentService) {
        return documentService.getCategoryType(FORM_CATEGORY_NAME);
    }

    public static Category getFormCategory(DocumentService documentService) {
        CategoryType formCategoryType = getFormCategoryType(documentService);
        if (formCategoryType == null) {
            return null;
        }

        return documentService.getCategory(formCategoryType, FORM_CATEGORY_NAME);
    }

    public static Map<String, List<String>> getTemplateFields(HttpServletRequest request) {
        Map<String, List<String>> templateFields = new HashMap<String, List<String>>();

        String[] templateIds = request.getParameterValues("scrive_template");
        String[] fieldNames = request.getParameterValues("scrive_field");

        if (templateIds != null) {
            for (String templateId : templateIds) {
                if (StringUtils.isBlank(templateId)) {
                    continue;
                }

                List<String> fields = templateFields.get(templateId);
                if (fields == null) {
                    fields = new ArrayList<String>();
                    templateFields.put(templateId, fields);
                }

                if (fieldNames != null) {
                    Pattern fieldPattern = Pattern.compile(templateId + "_(.+)");
                    for (String fieldName : fieldNames) {
                        Matcher matcher = fieldPattern.matcher(fieldName);
                        if (matcher.matches()) {
                            String scriveFieldName = matcher.group(1);
                            if (!fields.contains(scriveFieldName)) {
                                fields.add(scriveFieldName);
                            }
                        }
                    }
                }
            }
        }

        return templateFields;
    }

    public static void writeLog(String str) {
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "imSurvey_sms_send_log.txt").getAbsoluteFile();

        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            } catch (Exception e) {
                return;
            }
        }
        java.io.FileOutputStream fos;
        try {
            fos = new java.io.FileOutputStream(log_file, true);
        } catch (java.io.FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());

        if (!str.equals(""))
            str = logDate + " " + str + "\n";
        else
            str = "\n";

        try {
            fos.write(str.getBytes());
        } catch (Exception e) {
            return;
        }
        try {
            fos.close();
        } catch (Exception e) {
            return;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc,
                                   javax.activation.DataSource[] att, ContentManagementSystem imcmsSystem, boolean htmlMail) {
        writeLog("Sending email: " + to[0]);
        try {
            MailService mailService = imcmsSystem.getMailService();
            Mail mail = new Mail(from, to, subject, body);
            if (htmlMail) {
                mail.setHtmlBody(body);
            }
            if (cc != null && cc.length > 0 && !cc[0].equals("")) mail.setCcAddresses(cc);
            if (bcc != null && bcc.length > 0 && !bcc[0].equals("")) mail.setBccAddresses(bcc);
            if (att != null && att.length > 0) mail.setAttachments(att);
            mailService.sendMail(mail);
            return true;
        } catch (Exception ex) {
            writeLog("mailexception= " + ex.getMessage());
            writeLog("from= " + from + " to = " + to[0] + " subject= " + subject + " body= " + body);
            return false;
        }
    }

    public static boolean sendMail(String from, String[] to, String subject, String body, String[] cc, String[] bcc, javax.activation.DataSource[] att, ContentManagementSystem imcmsSystem) {
        return sendMail(from, to, subject, body, cc, bcc, att, imcmsSystem, false);
    }

    public static void notifyAbouScriveOutOfSync(int surveyId, FormEngineSettings settings, HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest(request);

        String from = settings.getMailFrom();
        String[] to = {settings.getMailTo()};
        StringBuilder subject = new StringBuilder(StringUtils.defaultIfEmpty(settings.getScriveOutOfSyncSubject(), "Survey out of sync with Scrive: "));
        subject.append(" ").append(surveyId);

        String linkToSurvey = getBaseURL(request) + "/imsurvey?meta_id=" + surveyId;
        StringBuilder body = new StringBuilder(settings.getScriveOutOfSyncBody());
        body.append("\n").append(createLink(linkToSurvey, linkToSurvey));
        sendMail(from, to, subject.toString(), body.toString(), null, null, null, cms, true);
    }

    public static String getBaseURL(HttpServletRequest request) {
        boolean isLocalhost = "localhost".equals(request.getServerName());
        return request.getScheme() + "://" + request.getServerName() + (isLocalhost ? ":" + request.getServerPort() : "") + request.getContextPath();
    }

    public static String createLink(String href, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href='").append(href).append("'>");
        sb.append(text);
        sb.append("</a>");

        return sb.toString();
    }

    @SuppressWarnings("unchecked")
    public static String getTemplateIdFromSurvey(ServletRequest request) {
        String templateId = null;
        Pattern scriveButtonPattern = Pattern.compile("scrive_button_(.+)");
        Map<String, String[]> params = request.getParameterMap();
        for (String name : params.keySet()) {
            Matcher matcher = scriveButtonPattern.matcher(name);
            if (matcher.matches()) {
                templateId = matcher.group(1);
                break;
            }
        }

        return templateId;
    }

    @SuppressWarnings("unchecked")
    public static Map<String, String> getFieldValuesForTemplate(String templateId, ServletRequest request) {
        Pattern scriveFieldParamPattern = Pattern.compile("scrive_(.+)_(.+)");
        if (!StringUtils.isBlank(templateId)) {
            Map<String, String[]> params = request.getParameterMap();
            Map<String, String> scriveParams = new HashMap<String, String>();

            for (String name : params.keySet()) {
                Matcher matcher = scriveFieldParamPattern.matcher(name);
                if (matcher.matches()) {
                    String fieldTemplateId = matcher.group(1);
                    String fieldName = matcher.group(2);
                    String value = params.get(name)[0];

                    if (templateId.equals(fieldTemplateId)) {
                        scriveParams.put(fieldName, value);
                    }
                }
            }

            return scriveParams;
        }

        return null;
    }

    @SuppressWarnings("unchecked")
    public static Map<String, String> getScriveFieldsFromDb(String templateId, ServletRequest request) {
        /* Reuires changes to the way form engine renders checkboxes and radio button(use of option id as value instead of text) */
        throw new UnsupportedOperationException("Not implemented");
//        Pattern textFieldPattern = Pattern.compile("formField(\\d+)");
//        Pattern checkboxPattern = Pattern.compile("cbField(\\d+)");
//        Pattern radionPattarn = Pattern.compile("radioField(\\d+)");
//
//        if (!StringUtils.isBlank(templateId)) {
//            Map<String, String[]> params = request.getParameterMap();
//            Map<String, String> scriveParams = new HashMap<String, String>();
//
//            for(String name: params.keySet()) {
//
//            }
//        }

    }
}
