/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.utils;

import com.google.inject.Inject;
import com.imcode.imcms.addon.imsurvey.services.ClientDetailsService;
import com.imcode.imcms.addon.imsurvey.services.RightsChecker;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ImSurveyUtils {
    private ClientDetailsService clientDetailsService;
    private RightsChecker rightsChecker;
    private static ImSurveyUtils imsurveyUtils;

    @Inject
    public ImSurveyUtils(ClientDetailsService clientDetailsService, RightsChecker rightsChecker) {
        this.clientDetailsService = clientDetailsService;
        this.rightsChecker = rightsChecker;
        imsurveyUtils = this;
    }

    public User getClientUser(HttpServletRequest request) {
        return this.clientDetailsService.getClient(request);
    }

    public TextDocument getClientDoc(HttpServletRequest request) {
        return this.clientDetailsService.getClientDoc(request);
    }

    public Category getClientCategory(HttpServletRequest request) {
        return this.clientDetailsService.getCategory(request);
    }

    public String getClientTitle(HttpServletRequest request) {
        return this.clientDetailsService.getClientTitle(request);
    }

    public String getClientDescription(HttpServletRequest request) {
        return this.clientDetailsService.getClientDescription(request);
    }

    public boolean currentUserCanAdminSurvey(Document document, ServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        User currentUser = cms.getCurrentUser();
        return this.userCanAdminSurvey(document, currentUser, request);
    }

    public boolean userCanAdminSurvey(Document document, User user, ServletRequest request) {
        return this.rightsChecker.userCanAdminSurvey(document, user, request);
    }

    public static ImSurveyUtils getUtils() {
        return imsurveyUtils;
    }
}

