package com.imcode.imcms.addon.imsurvey.scrive;

import com.imcode.imcms.addon.imsurvey.FormEngine;
import com.imcode.imcms.api.DatabaseService;
import org.apache.commons.dbutils.DbUtils;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SettingsService {
    public static void save(int surveyId, String consumerKey, String signature, String token, String secretToken, boolean useEmailAuthentication, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "scrive_credentials(survey_id, consumer_key, signature, token, secret_token, use_email_authentication) VALUES(?,?,?,?,?,?) " +
                    "ON DUPLICATE KEY UPDATE consumer_key = VALUES(consumer_key), signature = VALUES(signature), token = VALUES(token), secret_token = VALUES(secret_token), use_email_authentication = VALUES(use_email_authentication)");
            ps.setInt(1, surveyId);
            ps.setString(2, consumerKey);
            ps.setString(3, signature);
            ps.setString(4, token);
            ps.setString(5, secretToken);
	        ps.setBoolean(6, useEmailAuthentication);
            ps.executeUpdate();

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, null);
        }
    }

    public static ScriveAuthInfo get(int surveyId, DatabaseService databaseService) {
        return get((long)surveyId, databaseService);
    }

    public static ScriveAuthInfo get(long surveyId, DatabaseService databaseService) {
        ScriveAuthInfo authInfo = null;

        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "scrive_credentials WHERE survey_id = ?");
            ps.setLong(1, surveyId);
            rs = ps.executeQuery();
            if (rs.next()) {
                String consumerKey = rs.getString("consumer_key");
                String signature = rs.getString("signature");
                String token = rs.getString("token");
                String secretKey = rs.getString("secret_token");
	            boolean useEmailAuthentication = rs.getBoolean("use_email_authentication");
                authInfo = new ScriveAuthInfo(consumerKey, signature, token, secretKey, useEmailAuthentication);
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }

        return authInfo;
    }

    public static boolean isValid(ScriveAuthInfo authInfo) {
        boolean isValid = false;

        try {
            ScriveService scriveService = ScriveService.getInstance(authInfo);
            isValid = scriveService != null && !scriveService.getTemplates().isEmpty();
        } catch (IOException e) {
            /* Invalid auth credentials */
        }

        return isValid;
    }
}
