package com.imcode.imcms.addon.imsurvey;

/* *******************************************************************************************
 *         CLASS - ImcmsGui - Generates imCMS-admin GUI                                      *
 ******************************************************************************************* */

public class ImcmsGui {

    public ImcmsGui(String contextPath) {
        this.contextPath = contextPath;
    }

    public String  title      = (this.title != null) ? this.title : "imCMS Admin" ;
    public String  heading    = (this.heading != null) ? this.heading : "Admin" ;
    public String  width      = (this.width != null) ? this.width : "" ;
    String  onLoadEvent       = (this.onLoadEvent != null) ? " onLoad=\"" + this.onLoadEvent + "\"" : "" ;
    String  onResizeEvent     = (this.onResizeEvent != null) ? " onResize=\"" + this.onResizeEvent + "\"" : "" ;
    String  onUnloadEvent     = (this.onUnloadEvent != null) ? " onUnload=\"" + this.onUnloadEvent + "\"" : "" ;
    public boolean hideShadow = this.hideShadow ;
    String contextPath ;


    public String getHeading( String head ) {
        return "" +
                     "<span class=\"imcmsAdmHeading\">" + head + "</span><br>" +
                     "<img src=\""+contextPath+"/imcms/swe/images/admin/1x1_20568d.gif\" width=\"100%\" height=\"1\" vspace=\"8\">" ;
    }

    public String getHr( String sWidth, String sColor ) {
        sWidth = (sWidth != null) ? sWidth : "100%" ;
        sColor = (sColor == null || sColor.equals("blue")) ? "20568d" : sColor ;
        return "<img src=\""+contextPath+"/imcms/swe/images/admin/1x1_" + sColor + ".gif\" width=\"" + sWidth + "\" height=\"1\" vspace=\"8\">" ;
    }

    public String getBtn( String type, String name, String value, String style, String onClick, boolean isSmall, boolean isDisabled ) {
        name    = (name != null)    ? " name=\"" + name + "\""     : "" ;
        value   = (value != null)   ? " value=\"" + value.replaceAll("\\\"", "&quot;") + "\"" : "" ;
        style   = (style != null)   ? " style=\"" + style + "\""     : "" ;
        onClick = (onClick != null) ? " onClick=\"" + onClick + "\"" : "" ;
        return "" +
                     "<input type=\"" + type + "\"" + name + value +
                     " class=\"imcmsFormBtn" + (isSmall ? "Small" : "") + (isDisabled ? "Disabled" : "") + "\"" + (isDisabled ? " disabled" : "") +
                     "" + style + onClick + ">" ;
    }

    public String getHead() {
        return "" +
					"<meta http-equiv=\"pragma\" content=\"no-cache\">\n" +
					"<meta http-equiv=\"Expires\" content=\"-1\">\n" +
					"<meta http-equiv=\"Cache-Control\" content=\"must-revalidate\">\n" +
					"<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n\n" +
					"<link rel =\"stylesheet\" type=\"text/css\" href=\""+contextPath+"/imcms/css/imcms_admin.css.jsp\">\n" +
					"<script type=\"text/javascript\" src=\""+contextPath+"/imcms/swe/scripts/imcms_admin.js.jsp\"></script>\n" +
				  // TODO: In other sites than HH - Activate this also. HH has jQuery in the js above.
					"<script type=\"text/javascript\" src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js\"></script>\n" +
					"<script type=\"text/javascript\" src=\"http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.3/jquery-ui.min.js\"></script>\n" +
					"<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\""+contextPath+"/imcms/jscalendar/skins/aqua/theme.css.jsp\" />\n" +
					"<script type=\"text/javascript\" src=\""+contextPath+"/imcms/jscalendar/calendar.js\"></script>\n" +
					"<script type=\"text/javascript\" src=\""+contextPath+"/imcms/jscalendar/lang/calendar-swe.js\"></script>\n" +
					"<script type=\"text/javascript\" src=\""+contextPath+"/imcms/jscalendar/calendar-setup.js\"></script>" + this.getTabsCss() ;
    }

    public String getFullTop( boolean fullWidth, boolean compact ) {
        onLoadEvent   = (this.onLoadEvent.length() > 0)   ? " onLoad=\"" + this.onLoadEvent + "\""     : "" ;
        onResizeEvent = (this.onResizeEvent.length() > 0) ? " onResize=\"" + this.onResizeEvent + "\"" : "" ;
        onUnloadEvent = (this.onUnloadEvent.length() > 0) ? " onUnload=\"" + this.onUnloadEvent + "\""     : "" ;
        return "" +
                     "<html>\n" +
                     "<head>\n" +
                     "	<title>" + title + "</title>\n\n" +
                     this.getHead() + "\n\n" +
                     "</head>\n" +
                     "<body" + (fullWidth ? " class=\"imcmsAdmBgCont\" style=\"margin:0px; border:0px; overflow:auto;\"" : "") +
                     onLoadEvent + onUnloadEvent + onResizeEvent + ">\n\n" +
                     this.getTop(compact) ;
    }

    public String getTop( boolean compact ) {
        width = (!width.equals("")) ? " width=\"" + width + "\"" : "" ;
        String ret = "" +
                     "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"imcmsAdmTable\" align=\"center\"" + width + ">\n" +
                     "<tr>\n" +
                     "		<td class=\"imcmsAdmTable\">\n" +
                     "		<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"" + width + ">\n" +
                     "		<tr class=\"imcmsAdmBgHead\">\n" +
                     "			<td width=\"1\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td width=\"24\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"24\" height=\"1\"></td>\n" +
                     "			<td width=\"99%\" colspan=\"2\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td width=\"24\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"24\" height=\"1\"></td>\n" +
                     "			<td width=\"1\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "		</tr>\n" +
                     "		<tr>\n" +
                     "			<td class=\"imcmsAdmBgHead\" colspan=\"6\"><img\n" +
                     "			src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"20\"></td>\n" +
                     "		</tr>\n" +
                     "		<tr class=\"imcmsAdmBgHead\">\n" +
                     "			<td colspan=\"2\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td nowrap><span class=\"imcmsAdmHeadingTop\">" + heading + "</span></td>\n" +
                     "			<td align=\"right\"><a\n" +
                     "			href=\"http://www.imcms.net/\" target=\"_blank\"><img\n" +
                     "			src=\""+contextPath+"/imcms/swe/images/admin/logo_imcms_admin.gif\"\n" +
                     "			width=\"100\" height=\"20\" alt=\"www.imcms.net\" border=\"0\"></a></td>\n" +
                     "			<td colspan=\"2\"><img\n" +
                     "			src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "		</tr>\n" ;
        if (!compact) {
            ret +=
                    "		<tr>\n" +
                    "			<td colspan=\"6\" class=\"imcmsAdmBgHead\"><img\n" +
                    "			src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"20\"></td>\n" +
                    "		</tr>\n" ;
        }
        ret +=
                "		<tr class=\"imcmsAdmBgHead\">\n" +
                "			<td colspan=\"2\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                "			<td colspan=\"2\">\n" ;
        return ret ;
    }

    public String getMid( String tabsHtml ) {
        tabsHtml = (tabsHtml != null) ? tabsHtml : "" ;
        return "" +
                     "</td>\n" +
                     "			<td colspan=\"2\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "		</tr>\n" +
                     "		<tr>\n" +
                     "			<td class=\"imcmsAdmBgHead\" colspan=\"6\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"20\">" + tabsHtml + "</td>\n" +
                     "		</tr>\n" +
                     "		<tr>\n" +
                     "			<td" + ((!hideShadow) ? " class=\"imcmsAdmBorder\"" : "") + "><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"25\"></td>\n" +
                     "			<td class=\"imcmsAdmBgCont\" colspan=\"4\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td" + ((!hideShadow) ? " class=\"imcmsAdmBorder\"" : "") + "><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "		</tr>\n" +
                     "		<tr class=\"imcmsAdmBgCont\">\n" +
                     "			<td" + ((!hideShadow) ? " class=\"imcmsAdmBorder\"" : "") + "><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td colspan=\"2\">\n" ;
    }

    public String getFullBottom() {
        return this.getBottom() + "\n\n</body>\n</html>" ;
    }

    public String getBottom() {
        String ret = "" +
                     "</td>\n" +
                     "			<td><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td" + ((!hideShadow) ? " class=\"imcmsAdmBorder\"" : "") + "><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "		</tr>\n" +
                     "		<tr>\n" +
                     "			<td height=\"10\"" + ((!hideShadow) ? " class=\"imcmsAdmBorder\"" : "") + "><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td colspan=\"4\" class=\"imcmsAdmBgCont\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "			<td" + ((!hideShadow) ? " class=\"imcmsAdmBorder\"" : "") + "><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"1\"></td>\n" +
                     "		</tr>\n" +
                     "		<tr class=\"imcmsAdmBgCont\">\n" +
                     "			<td colspan=\"6\"><img src=\""+contextPath+"/imcms/swe/images/admin/1x1.gif\" width=\"1\" height=\"" + ((!hideShadow) ? "1" : "20") + "\"></td>\n" +
                     "		</tr>\n" +
                     "		</table></td>\n" ;
        if (!hideShadow) {
            ret += "" +
                   "	<td width=\"12\" align=\"right\" valign=\"top\" background=\""+contextPath+"/imcms/swe/images/admin/imcms_admin_shadow_right.gif\">\n" +
                   "	<img src=\""+contextPath+"/imcms/swe/images/admin/imcms_admin_shadow_right_top.gif\" width=\"12\" height=\"12\" alt=\"\" border=\"0\"></td>\n" +
                   "</tr>\n" +
                   "<tr>\n" +
                   "	<td colspan=\"2\">\n" +
                   "	<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n" +
                   "	<tr>\n" +
                   "		<td background=\""+contextPath+"/imcms/swe/images/admin/imcms_admin_shadow_bottom.gif\">\n" +
                   "		<img src=\""+contextPath+"/imcms/swe/images/admin/imcms_admin_shadow_bottom_left.gif\" width=\"12\" height=\"12\" alt=\"\" border=\"0\"></td>\n" +
                   "		<td background=\""+contextPath+"/imcms/swe/images/admin/imcms_admin_shadow_bottom.gif\" align=\"right\">\n" +
                   "		<img src=\""+contextPath+"/imcms/swe/images/admin/imcms_admin_shadow_bottom_right.gif\" width=\"12\" height=\"12\" alt=\"\" border=\"0\"></td>\n" +
                   "	</tr>\n" +
                   "	</table></td>\n" ;
        }
        ret += "" +
               "</tr>\n" +
               "</table>\n" ;
        return ret ;
    }

    public String getTabsCss() {
        return "\n<style type=\"text/css\">\n" +
               "<!--\n" +
               "SPAN.NavBtnTextAct, SPAN.NavBtnTextAct A:link, SPAN.NavBtnTextAct A:visited, SPAN.NavBtnTextAct A:hover {\n" +
               "	font: bold 10px Verdana, Geneva, Helvetica, sans-serif;\n" +
               "	color:#20568d;\n" +
               "	text-decoration:none;\n" +
               "}\n" +
               "SPAN.NavBtnTextInact, SPAN.NavBtnTextInact A:link, SPAN.NavBtnTextInact A:visited, SPAN.NavBtnTextInact A:hover {\n" +
               "	font: 10px Verdana, Geneva, Helvetica, sans-serif;\n" +
               "	color:#ffffff;\n" +
               "	text-decoration:none;\n" +
               "}\n" +
               "TD.NavBtnTextAct  { cursor: default; }\n" +
               "TD.NavBtnTextInact { cursor: pointer; }\n" +
               "-->\n" +
               "</style>\n" ;
    }

		public String getSaveTextForAdminDocument( String action, String uniqueIdIfSeveral ) {
			uniqueIdIfSeveral = (uniqueIdIfSeveral != null) ? uniqueIdIfSeveral : "" ;
			if (action != null && (action.indexOf("save") != -1 || action.equals("update"))) {
				return
								 "<span style=\"color:#cc0000\" id=\"savedSpan" + uniqueIdIfSeveral + "\"><b>Sparat!</b></span>\n" +
								 "<script language=\"JavaScript\">\n" +
								 "<!--\n" +
								 "function hideSaved" + uniqueIdIfSeveral + "() {\n" +
								 "	if (document.getElementById) document.getElementById(\"savedSpan" + uniqueIdIfSeveral + "\").style.visibility = \"hidden\" ;\n" +
								 "}\n" +
								 "if (window.setTimeout && document.getElementById) setTimeout(\"hideSaved" + uniqueIdIfSeveral + "()\", 4000) ;\n" +
								 "//-->\n" +
								 "</script>\n" ;
			}
			return "" ;
		}

		public String getSaveTextForAdminDocument( boolean doShow, String text ) {
			if (doShow) {
				String uniqueIdIfSeveral = System.currentTimeMillis() + "_" + doShow + "".hashCode() + "_" + text.hashCode() ;
				return
								 "<div style=\"display:none; color:#c00;\" id=\"savedSpan" + uniqueIdIfSeveral + "\"><b>" + text + "</b></div>\n" +
								 "<script type=\"text/javascript\">\n" +
								 "//<![CDATA[\n" +
								 "jQuery(document).ready(function($) {\n" +
								 "\t$('#savedSpan" + uniqueIdIfSeveral + "').slideDown('slow').delay(4000).slideUp('slow') ;\n" +
								 "}) ;\n" +
								 "//]]>\n" +
								 "</script>\n" ;
			}
			return "" ;
		}
}
