package com.imcode.imcms.addon.imsurvey;

import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.TextDocument;
import imcode.util.Utility;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.sql.*;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class FormEngineUtils {

    public static int getIntRequestParameter(String param, int defaultVal, HttpServletRequest request) {
        if (null != request.getParameter(param) && StringUtils.isNumeric(request.getParameter(param))) {
            try {
                return Integer.parseInt(request.getParameter(param));
            } catch (Exception ignore) {
            }
        }
        return defaultVal;
    }

    public static int[] getIntRequestParameterValues(String param, HttpServletRequest request) {
        if (null != request.getParameterValues(param)) {
            String[] arrStrings = request.getParameterValues(param);
            if (null != arrStrings) {
                for (int i = 0; i < arrStrings.length; i++) {
                    arrStrings[i] = arrStrings[i].replaceAll("[^\\d]+", "");
                    if ("".equals(arrStrings[i])) {
                        arrStrings[i] = "0";
                    }
                }
            }
            try {
                return Utility.convertStringArrayToIntArray(arrStrings);
            } catch (Exception ignore) {
            }
        }
        return new int[0];
    }

    public static void resortAllGroups(int changeIdOrZeroForNone, boolean moveChangeIdUp, TextDocument dataDoc, DBUtil dbUtil) {
        String sql = "SELECT id " +
                "FROM " + FormEngine.TABLE_PREFIX + "form_elements " +
                "WHERE meta_id = ? " +
                "ORDER BY tab_nbr, el_sort, id";

        String[][] options = dbUtil.sqlQueryMulti(sql, new String[]{dataDoc.getId() + ""});

        SortedMap<Integer, Integer> optionMap = new TreeMap<Integer, Integer>();

        int newSortNbr = 10;
        int theNbrAbove = 0;
        for (String[] option : options) {
            Integer item_id = new Integer(option[0]);
            if (changeIdOrZeroForNone > 0 && item_id == changeIdOrZeroForNone) {
                theNbrAbove = (moveChangeIdUp) ? newSortNbr - 15 : newSortNbr + 15;
            } else {
                optionMap.put(newSortNbr, item_id);
            }
            newSortNbr += 10;
        }
        optionMap.put(theNbrAbove, changeIdOrZeroForNone);

        newSortNbr = 10;

        for (Object o : optionMap.entrySet()) {
            Map.Entry e = (Map.Entry) o;
            sql = "UPDATE " + FormEngine.TABLE_PREFIX + "form_elements SET el_sort = ? WHERE id = ?";
            dbUtil.sqlUpdateQuery(sql, new String[]{newSortNbr + "", e.getValue().toString()});
            newSortNbr += 10;
        }
    }

    public static Integer createFormEngineElement(
            int surveyId,
            String elementType,
            int tabNumber,
            int elementCount,
            int rows,
            int elementSize,
            int elementRows,
            int maxLength,
            int isMultiple,
            String elementLabel,
            int isFullWidthLabel,
            int sortNumber,
            String exportLabel,
            int dependsOnId,
            String dependsOnValue,
            String dependsOnShow,
            DatabaseService databaseService) {

        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements\n" +
                    " (meta_id, el_type, tab_nbr, el_count, el_tablerows, el_size, el_rows, el_maxlength, el_multiple, el_label, el_label_fullwidth, el_sort, el_exportlabel, depends_on_id, depends_on_value, depends_on_show)\n" +
                    "VALUES\n" +
                    " (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS);

            ps.setInt(1, surveyId);
            ps.setString(2, elementType);
            ps.setInt(3, tabNumber);
            ps.setInt(4, elementCount);
            ps.setInt(5, rows);
            ps.setInt(6, elementSize);
            ps.setInt(7, elementRows);
            ps.setInt(8, maxLength);
            ps.setInt(9, isMultiple);
            ps.setString(10, elementLabel);
            ps.setInt(11, isFullWidthLabel);
            ps.setInt(12, sortNumber);
            ps.setString(13, exportLabel);
            ps.setInt(14, dependsOnId);
            ps.setString(15, dependsOnValue);
            ps.setString(16, dependsOnShow);
            ps.executeUpdate();

            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                return rs.getInt(1);
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }

        return null;
    }

    public static Integer addElementOption(int elementId, String optionValue, String optionText, boolean isSelected, String image, String link, String exportlabel, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(
                    "INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements_options" +
                            " (el_id, el_value, el_text, el_selected, image, link, el_export_label)" +
                            "VALUES(?, ?, ?, ?, ?, ?, ?)", PreparedStatement.RETURN_GENERATED_KEYS);
            ps.setInt(1, elementId);
            ps.setString(2, optionValue);
            ps.setString(3, optionText);
            ps.setBoolean(4, isSelected);
            ps.setString(5, image);
            ps.setString(6, link);
            ps.setString(7, exportlabel);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                return rs.getInt(1);
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }

        return null;
    }

}
