/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.scrive;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.FormEngine;
import com.imcode.imcms.addon.imsurvey.scrive.Document;
import com.imcode.imcms.addon.imsurvey.scrive.Field;
import com.imcode.imcms.addon.imsurvey.scrive.ScriveAuthInfo;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ScriveService {
    private static int FAILURE_HTTP_RESPONSE_CODE = 390;
    private String scriveBaseURL = "https://scrive.com";
    private ScriveAuthInfo authInfo;

    private ScriveService() {
    }

    private ScriveService(ScriveAuthInfo authInfo) {
        this.authInfo = authInfo;
    }

    public static ScriveService getInstance(ScriveAuthInfo authInfo) {
        if (authInfo == null || StringUtils.isBlank((String)authInfo.getConsumerKey()) || StringUtils.isBlank((String)authInfo.getSignature()) || StringUtils.isBlank((String)authInfo.getToken()) || StringUtils.isBlank((String)authInfo.getSecretToken())) {
            return null;
        }
        return new ScriveService(authInfo);
    }

    public boolean isSurveyInSyncWithScrive(int surveyId, DatabaseService databaseService) {
        Map<String, List<String>> surveyFields = this.getSurveyFields(surveyId, databaseService);
        for (String templateId : surveyFields.keySet()) {
            Document template;
            try {
                template = this.getDocument(templateId);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (template != null && !template.isDeleted()) {
                List<String> fields = surveyFields.get(template.getId());
                List<String> missingFields = this.getMissingFields(template, fields);
                if (missingFields.isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public List<String> getMissingFields(Document document, List<String> fieldNames) {
        ArrayList<String> missingFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            boolean hasField = false;
            for (Field field : document.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                hasField = true;
            }
            if (hasField) continue;
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getSurveyFields(int surveyId, DatabaseService databaseService) {
        HashMap<String, List<String>> surveyFields = new HashMap<String, List<String>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT COALESCE(el_fields.template_id, opt_field.template_id) AS template_id, COALESCE(el_fields.field_name, opt_field.field_name) AS field_name \nFROM " + FormEngine.TABLE_PREFIX + "form_elements el \n" + "LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \n" + "LEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \n" + "LEFT JOIN " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields opt_field ON opt_field.`option_id` = opt.id \n" + "WHERE el.meta_id = ?");
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                if (StringUtils.isEmpty((String)templateId) || StringUtils.isEmpty((String)fieldName)) continue;
                ArrayList<String> templateFields = (ArrayList<String>)surveyFields.get(templateId);
                if (templateFields == null) {
                    templateFields = new ArrayList<String>();
                    surveyFields.put(templateId, templateFields);
                }
                templateFields.add(fieldName);
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return surveyFields;
    }

    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props) throws Exception {
        int nbrPropsToSet = props.size();
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException("Scrive template id is either missing or invalid: " + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection(this.getScriveBaseURL() + "/api/v1/createfromtemplate/" + templateId, "POST");
        connection.setRequestProperty("Content-Type", "text/plain");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject documentToUpdate = null;
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String errorMessage = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(errorMessage);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            documentToUpdate = parsedReturn.getAsJsonObject();
            JsonPrimitive id = documentToUpdate.getAsJsonPrimitive("id");
            docId = id.getAsLong();
            this.changeDelivery(documentToUpdate, "mixed");
            JsonElement signaturesTest = documentToUpdate.get("signatories");
            if (null != signaturesTest && signaturesTest.isJsonArray()) {
                JsonArray signatures = signaturesTest.getAsJsonArray();
                if (signatures.size() == 2) {
                    JsonObject sign2 = signatures.get(1).getAsJsonObject();
                    this.changeDelivery(sign2, "api");
                    this.changeProperty("signsuccessredirect", sign2, signSuccessUrl);
                    JsonElement fieldsTest = sign2.get("fields");
                    if (null != fieldsTest && fieldsTest.isJsonArray()) {
                        JsonArray fields = fieldsTest.getAsJsonArray();
                        int valuesSet = 0;
                        for (int i = 0; i < fields.size(); ++i) {
                            String fieldName;
                            JsonElement elem2 = fields.get(i);
                            if (null == elem2 || !elem2.isJsonObject()) continue;
                            JsonObject field = elem2.getAsJsonObject();
                            JsonElement elemName = field.get("name");
                            JsonElement elemValue = field.get("value");
                            JsonElement elemType = field.get("type");
                            boolean hasPlacement = ScriveService.hasPlacement(field);
                            if (null == elemName || null == elemValue || null == elemType || !elemName.isJsonPrimitive() || !elemValue.isJsonPrimitive() || !elemType.isJsonPrimitive() || !hasPlacement || !props.containsKey(fieldName = elemName.getAsString())) continue;
                            boolean isCheckbox = "checkbox".equalsIgnoreCase(elemType.getAsString());
                            String newValue = StringUtils.defaultString((String)props.get(fieldName));
                            if (isCheckbox && !newValue.isEmpty()) {
                                newValue = "true";
                            }
                            this.changeValue(field, newValue);
                            ++valuesSet;
                        }
                        if (nbrPropsToSet > 0 && valuesSet != nbrPropsToSet) {
                            parserError = true;
                        }
                    } else {
                        parserError = true;
                    }
                } else {
                    parserError = true;
                }
            }
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception("Error template has changed! Can't create document.");
        }
        if (docId > 0L) {
            JsonElement signaturesTest;
            String urlParameters = "json=" + URLEncoder.encode(documentToUpdate.toString(), "UTF-8");
            connection = this.getHttpURLConnection(this.getScriveBaseURL() + "/api/v1/update/" + docId);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
            streamWriter.write(urlParameters);
            streamWriter.close();
            responseCode = connection.getResponseCode();
            if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            connection.disconnect();
            connection = this.getHttpURLConnection(this.getScriveBaseURL() + "/api/v1/ready/" + docId);
            responseCode = connection.getResponseCode();
            if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
            JsonElement parsedReturn2 = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (parsedReturn2.isJsonObject() && null != (signaturesTest = (documentToUpdate = parsedReturn2.getAsJsonObject()).get("signatories")) && signaturesTest.isJsonArray()) {
                JsonArray signatures = signaturesTest.getAsJsonArray();
                if (signatures.size() == 2) {
                    JsonObject sign2 = signatures.get(1).getAsJsonObject();
                    JsonPrimitive signLinkElement = sign2.getAsJsonPrimitive("signlink");
                    if (null != signLinkElement) {
                        return signLinkElement.getAsString();
                    }
                } else {
                    throw new Exception("Error not twp signing posts");
                }
            }
            connection.disconnect();
        }
        return null;
    }

    public List<Document> getTemplates() throws IOException {
        JsonElement templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection(this.getScriveBaseURL() + "/api/v1/list?documentType=Template&limit=1000", "GET");
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject() && null != (templateListElem = ((JsonObject)parsedReturn).get("list")) && templateListElem.isJsonArray()) {
            for (JsonElement templateElem : (JsonArray)templateListElem) {
                Document template;
                JsonObject templateObj;
                JsonElement templateFieldElem;
                if (null == templateElem || !templateElem.isJsonObject() || null == (templateFieldElem = (templateObj = (JsonObject)templateElem).get("fields")) || !templateFieldElem.isJsonObject()) continue;
                JsonObject templateFieldObj = (JsonObject)templateFieldElem;
                JsonPrimitive id = templateFieldObj.getAsJsonPrimitive("id");
                JsonPrimitive title = templateFieldObj.getAsJsonPrimitive("title");
                if (null == id || null == title || (template = this.getDocument(id.getAsString())) == null) continue;
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection(this.getScriveBaseURL() + "/api/v1/get/" + id, "GET");
        connection.setRequestProperty("Content-Type", "text/plain");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
        }
        return document;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonObject sign2;
            JsonElement fieldsTest;
            JsonArray signatures;
            JsonElement titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonElement idElem = jsonObject.get("id");
            if (idElem != null && idElem.isJsonPrimitive()) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.get("title")) != null && titleElem.isJsonPrimitive()) {
                document.setTitle(titleElem.getAsString());
            }
            boolean deleted = false;
            JsonElement deletedElem = jsonObject.get("deleted");
            if (deletedElem != null && deletedElem.isJsonPrimitive()) {
                deleted = deletedElem.getAsBoolean();
            }
            document.setDeleted(deleted);
            JsonElement signaturesTest = jsonObject.get("signatories");
            if (null != signaturesTest && signaturesTest.isJsonArray() && (signatures = signaturesTest.getAsJsonArray()).size() == 2 && null != (fieldsTest = (sign2 = signatures.get(1).getAsJsonObject()).get("fields")) && fieldsTest.isJsonArray()) {
                JsonArray fields = fieldsTest.getAsJsonArray();
                for (int i = 0; i < fields.size(); ++i) {
                    JsonElement elem2 = fields.get(i);
                    if (null == elem2 || !elem2.isJsonObject()) continue;
                    JsonObject field = elem2.getAsJsonObject();
                    JsonElement elemName = field.get("name");
                    JsonElement elemType = field.get("type");
                    boolean hasPlacement = ScriveService.hasPlacement(field);
                    if (null == elemName || null == elemType || !elemName.isJsonPrimitive() || !elemType.isJsonPrimitive() || !hasPlacement) continue;
                    boolean isCheckbox = "checkbox".equalsIgnoreCase(elemType.getAsString());
                    String fieldName = elemName.getAsString();
                    document.getFields().add(new Field(isCheckbox ? Field.Type.CHECKBOX : Field.Type.TEXT, fieldName));
                }
            }
        }
        return document;
    }

    public static boolean hasPlacement(JsonObject fieldElem) {
        JsonElement elemPlacement = fieldElem.get("placements");
        return elemPlacement != null && elemPlacement.isJsonArray() && elemPlacement.getAsJsonArray().size() > 0;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        String oauth_consumer_key = this.getAuthInfo().getConsumerKey();
        String oauth_signature = this.getAuthInfo().getSignature();
        String oauth_token = this.getAuthInfo().getToken();
        String oauth_token_secret = this.getAuthInfo().getSecretToken();
        StringBuilder authHead = new StringBuilder();
        authHead.append("OAuth realm=\"Scrive\", ");
        authHead.append("oauth_signature_method=\"PLAINTEXT\", ");
        authHead.append("oauth_consumer_key=\"").append(oauth_consumer_key).append("\", ");
        authHead.append("oauth_token=\"").append(oauth_token).append("\", ");
        authHead.append("oauth_signature=\"").append(oauth_signature).append("&").append(oauth_token_secret).append("\" ");
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", authHead.toString());
        connection.setRequestProperty("Charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    private void changeValue(JsonObject field, String data) {
        this.changeProperty("value", field, data);
    }

    private void changeDelivery(JsonObject parent, String data) {
        this.changeProperty("delivery", parent, data);
    }

    private void changeProperty(String property, JsonObject parent, String data) {
        parent.remove(property);
        parent.addProperty(property, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignFieldsToElement(int elementId, Map<String, List<String>> templateFields, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = databaseService.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement("DELETE FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields WHERE element_id = ?");
            ps.setInt(1, elementId);
            ps.executeUpdate();
            if (templateFields != null && !templateFields.isEmpty()) {
                ps = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "element_scrive_fields(element_id, template_id, field_name) VALUES(?, ?, ?)");
                for (String templateId : templateFields.keySet()) {
                    ps.setInt(1, elementId);
                    ps.setString(2, templateId);
                    List<String> fieldNames = templateFields.get(templateId);
                    if (fieldNames != null && !fieldNames.isEmpty()) {
                        for (String fieldName : fieldNames) {
                            ps.setString(3, fieldName);
                            ps.addBatch();
                        }
                        continue;
                    }
                    ps.setObject(3, null);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            connection.commit();
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, null);
        }
        catch (SQLException e) {
            try {
                DbUtils.rollback((Connection)connection);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignFieldsToElementOption(int optionId, Map<String, List<String>> templateFields, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = databaseService.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement("DELETE FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?");
            ps.setInt(1, optionId);
            ps.executeUpdate();
            ps = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields(option_id, template_id, field_name) VALUES(?, ?, ?)");
            for (String templateId : templateFields.keySet()) {
                for (String fieldName : templateFields.get(templateId)) {
                    ps.setInt(1, optionId);
                    ps.setString(2, templateId);
                    ps.setString(3, fieldName);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            connection.commit();
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, null);
        }
        catch (SQLException e) {
            try {
                DbUtils.rollback((Connection)connection);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields WHERE option_id = ?");
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getDocument(templateId);
                if (template == null) continue;
                for (Field field : template.getFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    ArrayList<Field> fields = (ArrayList<Field>)optionFields.get(template);
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT * FROM " + FormEngine.TABLE_PREFIX + "element_scrive_fields WHERE element_id = ?");
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                Document template = this.getDocument(templateId);
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                    templateFields.put(template, fields);
                }
                for (Field field : template.getFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    fields.add(field);
                }
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getElementOptionField(int optionId, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT scrive_field_name FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE id = ?");
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
                return string;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addElementOption(int elementId, String optionValue, String optionText, boolean isSelected, String image, String link, String exportlabel, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("INSERT INTO " + FormEngine.TABLE_PREFIX + "form_elements_options" + " (el_id, el_value, el_text, el_selected, image, link, el_export_label)" + "VALUES(?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setInt(1, elementId);
            ps.setString(2, optionValue);
            ps.setString(3, optionText);
            ps.setBoolean(4, isSelected);
            ps.setString(5, image);
            ps.setString(6, link);
            ps.setString(7, exportlabel);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                Integer n = rs.getInt(1);
                DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
                return n;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getElementOptionTemplateId(int optionId, DatabaseService databaseService) {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement("SELECT scrive_template_id FROM " + FormEngine.TABLE_PREFIX + "form_elements_options WHERE id = ?");
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
                return string;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)connection, ps, rs);
        }
        return null;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> scriveParams) throws Exception {
        String scringDocumentURI = this.getDocumentURI(backToSiteURL, templateId, scriveParams);
        if (scringDocumentURI == null) {
            return null;
        }
        return this.getScriveBaseURL() + scringDocumentURI;
    }

    public String getScriveBaseURL() {
        return this.scriveBaseURL;
    }

    public ScriveAuthInfo getAuthInfo() {
        return this.authInfo;
    }
}

