/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey;

import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RightsChecker {
    public static boolean userMayAdminDocument(Document doc, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        User currentUser = imcmsSystem.getCurrentUser();
        if (currentUser.isDefaultUser()) {
            return false;
        }
        if (currentUser.isSuperAdmin()) {
            return true;
        }
        try {
            if (doc.getPublisher().getId() == currentUser.getId()) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String client = "";
        try {
            DocumentService documentService = imcmsSystem.getDocumentService();
            CategoryType clientCategoryType = Utils.getClientCategoryType(documentService);
            Category clientCategory = doc.getCategoriesOfType(clientCategoryType)[0];
            client = clientCategory.getName();
        }
        catch (Exception e) {
            // empty catch block
        }
        return !(!client.isEmpty() && !client.equalsIgnoreCase(currentUser.getCompany()) || !currentUser.hasRole(Utils.getClientAdminRole(userService)) && !currentUser.hasRole(Utils.getServiceAdminRole(userService)));
    }
}

