/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.services;

import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.addon.imsurvey.services.ClientDetailsService;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class StaticClientDetailServiceImpl
implements ClientDetailsService {
    private String imSurveyUserLoginName = "imsurvey_babs";
    private String imSurveyDocumentAlias = "imsurvey_babs";
    private String imSurveyCategoryName = "imsurvey_babs";

    @Override
    public User getUser(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = cms.getUserService();
        DocumentService documentService = cms.getDocumentService();
        User clientUser = userService.getUser(this.imSurveyUserLoginName);
        if (clientUser == null) {
            try {
                clientUser = this.createUser(userService);
                this.setup(request, userService, documentService);
            }
            catch (SaveException e) {
                e.printStackTrace();
                throw new IllegalStateException("Setup failed with message: " + e.getMessage());
            }
        }
        return clientUser;
    }

    @Override
    public TextDocument getUserDoc(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = cms.getDocumentService();
        UserService userService = cms.getUserService();
        TextDocument clientDoc = documentService.getTextDocument(this.imSurveyDocumentAlias);
        if (clientDoc == null) {
            try {
                clientDoc = this.createDocument(documentService);
                this.setup(request, userService, documentService);
            }
            catch (SaveException e) {
                e.printStackTrace();
                throw new IllegalStateException("Setup failed with message: " + e.getMessage());
            }
        }
        return clientDoc;
    }

    @Override
    public Category getCategory(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = cms.getDocumentService();
        UserService userService = cms.getUserService();
        Category clientCategory = documentService.getCategory(Utils.getClientCategoryType(documentService), this.imSurveyCategoryName);
        if (clientCategory == null) {
            try {
                clientCategory = this.createCategory(documentService);
                this.setup(request, userService, documentService);
            }
            catch (SaveException e) {
                e.printStackTrace();
                throw new IllegalStateException("Setup failed with message: " + e.getMessage());
            }
        }
        return clientCategory;
    }

    private void setup(HttpServletRequest request, UserService userService, DocumentService documentService) throws SaveException {
        if (this.getUser(request) == null) {
            this.createUser(userService);
        }
        if (this.getCategory(request) == null) {
            this.createCategory(documentService);
        }
        if (this.getUserDoc(request) == null) {
            this.createDocument(documentService);
        }
    }

    private User createUser(UserService userService) throws SaveException {
        User user = userService.createNewUser(this.imSurveyUserLoginName, "admin");
        user.setCompany("babs");
        userService.saveUser(user);
        return user;
    }

    private Category createCategory(DocumentService documentService) throws IllegalStateException, SaveException {
        Category category = new Category(this.imSurveyCategoryName, Utils.getClientCategoryType(documentService));
        documentService.saveCategory(category);
        return category;
    }

    private TextDocument createDocument(DocumentService documentService) throws SaveException, IllegalStateException {
        int startDocId = Imcms.getServices().getSystemData().getStartDocument();
        Document startDoc = documentService.getDocument(startDocId);
        if (startDoc == null) {
            throw new IllegalStateException("Start document not found: " + startDocId);
        }
        TextDocument userDoc = documentService.createNewTextDocument(startDoc);
        userDoc.setAlias(this.imSurveyDocumentAlias);
        documentService.saveChanges((Document)userDoc);
        return userDoc;
    }

    public String getImSurveyUserLoginName() {
        return this.imSurveyUserLoginName;
    }

    public void setImSurveyUserLoginName(String imSurveyUserLoginName) {
        this.imSurveyUserLoginName = imSurveyUserLoginName;
    }

    public String getImSurveyDocumentAlias() {
        return this.imSurveyDocumentAlias;
    }

    public void setImSurveyDocumentAlias(String imSurveyDocumentAlias) {
        this.imSurveyDocumentAlias = imSurveyDocumentAlias;
    }

    public String getImSurveyCategoryName() {
        return this.imSurveyCategoryName;
    }

    public void setImSurveyCategoryName(String imSurveyCategoryName) {
        this.imSurveyCategoryName = imSurveyCategoryName;
    }
}

