package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.repository.ExifRepository;
import com.imcode.imcms.addon.imagearchive.service.ExifService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Set;

/**
 * Created by Serhii from Ubrainians for Imcode
 * on 02.09.16.
 */
@Service
@Transactional
public class ExifServiceImpl implements ExifService {

    @Autowired
    private ExifRepository exifRepository;

	public Set<String> getAllArtists() {
		return exifRepository.findAllWhereArtistExistSortedAsc();
	}

    public Exif getById(long id) {
        return exifRepository.findOne(id);
    }
}
