/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.repository.ImageRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.ImageService;
import com.imcode.imcms.addon.imagearchive.service.file.FileServiceImpl;
import com.imcode.imcms.addon.imagearchive.service.jpa.ExifServiceImpl;
import com.imcode.imcms.addon.imagearchive.service.jpa.KeywordServiceImpl;
import com.imcode.imcms.addon.imagearchive.util.PageResult;
import com.imcode.imcms.addon.imagearchive.util.Pagination;
import com.imcode.imcms.addon.imagearchive.util.exif.ExifData;
import com.imcode.imcms.addon.imagearchive.util.exif.ExifUtils;
import com.imcode.imcms.addon.imagearchive.util.exif.Flash;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.criteria.OrderImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ImageServiceImpl
implements ImageService {
    private static final Log log = LogFactory.getLog(ImageServiceImpl.class);
    @Autowired
    JpaTransactionManager transactionManager;
    @Autowired
    private Facade facade;
    @Autowired
    private ExifServiceImpl exifService;
    @Autowired
    private ImageRepository imageRepository;
    @Autowired
    private KeywordServiceImpl keywordsService;
    @Autowired
    private Config config;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Image findById(Long imageId) {
        Image image = (Image)this.imageRepository.findOne(imageId);
        if (image != null && image.getExif() == null) {
            Exif exif = this.exifService.getById(imageId);
            image.setExif(exif);
        }
        return image;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Exif findExifByPK(Long imageId) {
        Image image = this.imageRepository.findByIDAndFetchExif(imageId);
        if (image != null) {
            return image.getExif() == null ? this.exifService.getById(imageId) : image.getExif();
        }
        return null;
    }

    public Image createImage(File tempFile, ImageInfo imageInfo, String imageName, short status) {
        Image image = this.create(tempFile, imageInfo, imageName);
        image.setStatus(status);
        image = (Image)this.imageRepository.save(image);
        if (!this.facade.getFileService().storeImage(tempFile, image.getId().longValue(), false)) {
            return null;
        }
        return image;
    }

    private Image create(File tempFile, ImageInfo imageInfo, String imageName) {
        Image image = new Image();
        String copyright = "";
        String description = "";
        String artist = "";
        String manufacturer = null;
        String model = null;
        String compression = null;
        Double exposure = null;
        String exposureProgram = null;
        Float fStop = null;
        Date dateOriginal = null;
        Date dateDigitized = null;
        Flash flash = null;
        Float focalLength = null;
        String colorSpace = null;
        Integer xResolution = null;
        Integer yResolution = null;
        Integer resolutionUnit = null;
        Integer pixelXDimension = null;
        Integer pixelYDimension = null;
        Integer ISO = null;
        ExifData data = ExifUtils.getExifData((File)tempFile);
        if (data != null) {
            copyright = StringUtils.substring((String)data.getCopyright(), (int)0, (int)255);
            description = StringUtils.substring((String)data.getDescription(), (int)0, (int)255);
            artist = StringUtils.substring((String)data.getArtist(), (int)0, (int)255);
            xResolution = data.getxResolution();
            yResolution = data.getyResolution();
            manufacturer = data.getManufacturer();
            model = data.getModel();
            compression = data.getCompression();
            exposure = data.getExposure();
            exposureProgram = data.getExposureProgram();
            fStop = data.getfStop();
            flash = data.getFlash();
            focalLength = data.getFocalLength();
            colorSpace = data.getColorSpace();
            resolutionUnit = data.getResolutionUnit();
            pixelXDimension = data.getPixelXDimension();
            pixelYDimension = data.getPixelYDimension();
            dateOriginal = data.getDateOriginal();
            dateDigitized = data.getDateDigitized();
            ISO = data.getISO();
        }
        Exif originalExif = new Exif(xResolution, yResolution, description, artist, copyright, manufacturer, model, compression, exposure, exposureProgram, fStop, flash, focalLength, colorSpace, resolutionUnit, pixelXDimension, pixelYDimension, dateOriginal, dateDigitized, ISO);
        String uploadedBy = "";
        image.setUploadedBy(uploadedBy);
        image.setName(StringUtils.substring((String)imageName, (int)0, (int)255));
        image.setFormat(imageInfo.getFormat().getOrdinal());
        image.setFileSize((int)tempFile.length());
        image.setWidth(imageInfo.getWidth());
        image.setHeight(imageInfo.getHeight());
        image.setExif(originalExif);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Image> createImagesFromZip(File tempFile) {
        ZipFile zip = null;
        ArrayList<Image> createdImages = new ArrayList<Image>();
        try {
            zip = new ZipFile(tempFile, 1);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                BufferedOutputStream outputStream;
                InputStream inputStream;
                File entryFile;
                block19: {
                    ImageInfo imageInfo;
                    String fileName;
                    block18: {
                        String extension;
                        ZipEntry entry = entries.nextElement();
                        fileName = entry.getName();
                        Matcher matcher = FileServiceImpl.FILENAME_PATTERN.matcher(fileName);
                        if (fileName.startsWith("__MACOSX/") || !matcher.matches() || StringUtils.isEmpty((CharSequence)(fileName = matcher.group(1).trim())) || !FileServiceImpl.IMAGE_EXTENSIONS_SET.contains(extension = StringUtils.substringAfterLast((String)fileName, (String)".").toLowerCase())) continue;
                        entryFile = this.facade.getFileService().createTemporaryFile("zipEntryTmp");
                        inputStream = null;
                        outputStream = null;
                        inputStream = zip.getInputStream(entry);
                        outputStream = new BufferedOutputStream(FileUtils.openOutputStream((File)entryFile));
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        ((OutputStream)outputStream).flush();
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        imageInfo = ImageOp.getImageInfo((Config)this.config, (File)entryFile);
                        if (imageInfo != null && imageInfo.getFormat() != null && imageInfo.getWidth() >= 1 && imageInfo.getHeight() >= 1) break block18;
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        entryFile.delete();
                        continue;
                    }
                    try {
                        Image image = this.createImage(entryFile, imageInfo, fileName, (short)1);
                        if (image == null) break block19;
                        createdImages.add(image);
                    }
                    catch (Exception ex) {
                        try {
                            log.warn((Object)ex.getMessage(), (Throwable)ex);
                            entryFile.delete();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(outputStream);
                            IOUtils.closeQuietly((InputStream)inputStream);
                            entryFile.delete();
                            throw throwable;
                            return createdImages;
                        }
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        entryFile.delete();
                        continue;
                    }
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                entryFile.delete();
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return createdImages;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void createImages(List<Object[]> tuples) {
        for (Object[] tuple : tuples) {
            File tempFile = (File)tuple[0];
            ImageInfo imageInfo = (ImageInfo)tuple[1];
            String imageName = (String)tuple[2];
            this.createImage(tempFile, imageInfo, imageName, (short)1);
        }
    }

    public void deleteImage(Long imageId) {
        this.imageRepository.delete(imageId);
        this.facade.getFileService().deleteImage(imageId.longValue());
    }

    public void updateFullData(Image image, List<Long> categoryIds, List<String> imageKeywords) {
        image.setCategories(categoryIds);
        this.updateImageKeywordsWithoutSave(image, imageKeywords);
        this.imageRepository.save(image);
    }

    public void updateData(Image image, List<Long> categoryIds, List<String> imageKeywords) {
        this.updateFullData(image, categoryIds, imageKeywords);
    }

    private void updateImageCategories(Image image, List<Long> categoryIds) {
        image.setCategories(categoryIds);
        this.imageRepository.save(image);
    }

    private void updateImageKeywords(Image image, List<String> imageKeywords) {
        this.updateImageKeywordsWithoutSave(image, imageKeywords);
        this.imageRepository.save(image);
    }

    private Image updateImageKeywordsWithoutSave(Image image, List<String> imageKeywords) {
        LinkedList<Keyword> keywords = new LinkedList<Keyword>();
        for (String keywordString : imageKeywords) {
            Keyword keyword = this.keywordsService.createOrGet(keywordString);
            keywords.add(keyword);
        }
        image.setKeywords(keywords);
        return image;
    }

    public void archiveImage(Long imageId) {
        this.setStatus(imageId, (short)2);
    }

    private void setStatus(Long imageId, short status) {
        Image image = (Image)this.imageRepository.findOne(imageId);
        if (image != null) {
            image.setStatus(status);
            this.imageRepository.save(image);
        }
    }

    public void unarchiveImage(Long imageId) {
        this.setStatus(imageId, (short)1);
    }

    public List<Image> getAllImages() {
        return this.imageRepository.findAll();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PageResult<Image> searchImages(Pagination pag, SearchImageCommand command) {
        EntityManager entityManager = this.transactionManager.getEntityManagerFactory().createEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(Image.class);
        Root root = criteriaQuery.from(Image.class);
        Join keywordsJoin = root.join("keywords", JoinType.LEFT);
        Join exifJoin = root.join("exif", JoinType.LEFT);
        Predicate whereClause = null;
        if (command.getKeywordId() > 0L) {
            whereClause = builder.equal((Expression)keywordsJoin.get("id"), (Object)command.getKeywordId());
        }
        if (StringUtils.isNotBlank((CharSequence)command.getArtist())) {
            Predicate artistPredicate = builder.equal((Expression)exifJoin.get("artist"), (Object)command.getArtist());
            whereClause = this.andClauses(whereClause, artistPredicate, builder);
        }
        whereClause = this.getFreeTextClause(command, whereClause, (Root<Image>)root, (Join<Image, Exif>)exifJoin, builder);
        whereClause = this.getShowingClause(command, whereClause, (Root<Image>)root, builder);
        criteriaQuery.where((Expression)whereClause);
        Order ordering = this.resolveOrdering(command, (Root<Image>)root);
        criteriaQuery.orderBy(new Order[]{ordering});
        TypedQuery query = entityManager.createQuery(criteriaQuery.select((Selection)root).distinct(true));
        List<Image> images = query.getResultList();
        images = this.filterImagesByCategories(images, command);
        pag.update(images.size());
        if (command.getSortBy() == 0) {
            images = this.sortByArtist(images, command.getSortOrder());
        }
        images = this.applyPaging(images, pag);
        return new PageResult(images, pag);
    }

    private List<Image> sortByArtist(List<Image> images, short sortOrder) {
        for (Image image : images) {
            if (image.getExif() != null) continue;
            Exif exif = this.exifService.getById(image.getId());
            image.setExif(exif);
        }
        boolean descending = BooleanUtils.toBoolean((int)sortOrder);
        final int orderCoefficient = descending ? 1 : -1;
        Collections.sort(images, new Comparator<Image>(){

            @Override
            public int compare(Image image1, Image image2) {
                try {
                    String artist2;
                    Exif exif1 = image1.getExif();
                    Exif exif2 = image2.getExif();
                    String artist1 = exif1 == null ? "" : exif1.getArtist();
                    String string = artist2 = exif2 == null ? "" : exif2.getArtist();
                    int result = artist1.equals(artist2) ? 0 : ("".equals(artist1) ? 1 : ("".equals(artist2) ? -1 : artist1.compareTo(artist2)));
                    return result * orderCoefficient;
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        return images;
    }

    private List<Image> applyPaging(List<Image> images, Pagination pagination) {
        ArrayList<Image> pagedImages = new ArrayList<Image>();
        int startPosition = pagination.getStartPosition();
        int currentPage = pagination.getCurrentPage();
        int pageSize = pagination.getPageSize();
        int endPosition = (currentPage + 1) * pageSize;
        for (int i = 0; i < images.size(); ++i) {
            if (i < startPosition || i >= endPosition) continue;
            pagedImages.add(images.get(i));
        }
        return pagedImages;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private Predicate getFreeTextClause(SearchImageCommand command, Predicate existingPredicate, Root<Image> root, Join<Image, Exif> exifJoin, CriteriaBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)command.getFreetext())) {
            String formattedFreeText = "%" + command.getFreetext().trim() + "%";
            Predicate likePredicate = builder.like((Expression)root.get("name"), formattedFreeText);
            if (!command.isFileNamesOnly()) {
                likePredicate = builder.or(new Predicate[]{likePredicate, builder.like((Expression)root.get("altText"), formattedFreeText), builder.like((Expression)exifJoin.get("description"), formattedFreeText), builder.like((Expression)exifJoin.get("artist"), formattedFreeText), builder.like((Expression)exifJoin.get("copyright"), formattedFreeText), builder.like((Expression)exifJoin.get("manufacturer"), formattedFreeText), builder.like((Expression)exifJoin.get("model"), formattedFreeText), builder.like((Expression)exifJoin.get("compression"), formattedFreeText), builder.like((Expression)exifJoin.get("colorSpace"), formattedFreeText), builder.like((Expression)exifJoin.get("colorSpace"), formattedFreeText)});
            }
            existingPredicate = this.andClauses(existingPredicate, likePredicate, builder);
        }
        return existingPredicate;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private Predicate getShowingClause(SearchImageCommand command, Predicate existingPredicate, Root<Image> root, CriteriaBuilder builder) {
        Predicate showProperty;
        boolean showDeleted = false;
        if (command.getShow() != 0) {
            switch (command.getShow()) {
                case 2: {
                    showProperty = builder.equal((Expression)root.get("status"), (Object)2);
                    showDeleted = true;
                    break;
                }
                case 3: {
                    Predicate licensedBefore = builder.lessThanOrEqualTo((Expression)root.get("licenseDt"), (Comparable)new Date());
                    Predicate licenseEndsLater = builder.greaterThanOrEqualTo((Expression)root.get("licenseEndDt"), (Comparable)new Date());
                    showProperty = builder.and((Expression)licensedBefore, (Expression)licenseEndsLater);
                    break;
                }
                default: {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(new Date());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    Date today = cal.getTime();
                    showProperty = builder.greaterThanOrEqualTo((Expression)root.get("createdDt"), (Comparable)today);
                    break;
                }
            }
            existingPredicate = this.andClauses(existingPredicate, showProperty, builder);
        }
        if (!showDeleted) {
            showProperty = builder.notEqual((Expression)root.get("status"), (Object)2);
            existingPredicate = this.andClauses(existingPredicate, showProperty, builder);
        }
        return existingPredicate;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private Predicate andClauses(Predicate nullablePredicate, Predicate notNullPredicate, CriteriaBuilder builder) {
        return nullablePredicate == null ? notNullPredicate : builder.and((Expression)nullablePredicate, (Expression)notNullPredicate);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private Order resolveOrdering(SearchImageCommand command, Root<Image> root) {
        Path sortExpression;
        short sortBy = command.getSortBy();
        boolean ascending = !BooleanUtils.toBoolean((int)command.getSortOrder());
        switch (sortBy) {
            case 1: {
                sortExpression = root.get("name");
                break;
            }
            default: {
                sortExpression = root.get("createdDt");
            }
        }
        return new OrderImpl((Expression)sortExpression, ascending);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private List<Image> filterImagesByCategories(List<Image> images, SearchImageCommand command) {
        List categoryIds = command.getCategoryIds();
        boolean hasNoCategory = categoryIds.remove(-2L);
        if (hasNoCategory) {
            return categoryIds.size() > 0 ? this.containsOrHasEmptyCategories(images, categoryIds) : this.hasEmptyCategories(images);
        }
        return this.containsCategories(images, categoryIds);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private List<Image> containsCategories(List<Image> images, final List<Long> categoryIds) {
        CollectionUtils.filter(images, (org.apache.commons.collections4.Predicate)new org.apache.commons.collections4.Predicate<Image>(){

            public boolean evaluate(Image image) {
                List categories = image.getCategories();
                return CollectionUtils.containsAny((Collection)categories, (Collection)categoryIds);
            }
        });
        return images;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private List<Image> hasEmptyCategories(List<Image> images) {
        CollectionUtils.filter(images, (org.apache.commons.collections4.Predicate)new org.apache.commons.collections4.Predicate<Image>(){

            public boolean evaluate(Image image) {
                List categories = image.getCategories();
                return categories.size() == 0;
            }
        });
        return images;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    private List<Image> containsOrHasEmptyCategories(List<Image> images, final List<Long> categoryIds) {
        CollectionUtils.filter(images, (org.apache.commons.collections4.Predicate)new org.apache.commons.collections4.Predicate<Image>(){

            public boolean evaluate(Image image) {
                List categories = image.getCategories();
                boolean containsAny = CollectionUtils.containsAny((Collection)categories, (Collection)categoryIds);
                boolean hasNoCategories = categories.size() == 0;
                return containsAny || hasNoCategories;
            }
        });
        return images;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Keyword> findAvailableKeywords(Long imageId) {
        List<Keyword> allKeywords = this.keywordsService.getKeywords();
        List<Keyword> imageKeywords = this.findImageKeywords(imageId);
        allKeywords.removeAll(imageKeywords);
        return allKeywords;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Keyword> findImageKeywords(Long imageId) {
        Image image = (Image)this.imageRepository.findOne(imageId);
        return image.getKeywords();
    }

    public File uploadFile(byte[] data) {
        File tempFile = this.facade.getFileService().createTemporaryFile("img_upload_" + Math.round(Math.random() * 100000.0));
        try {
            FileOutputStream output = new FileOutputStream(tempFile);
            IOUtils.write((byte[])data, (OutputStream)output);
        }
        catch (IOException e) {
            return null;
        }
        return tempFile;
    }
}

