/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.file;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.comparators.FileComparator;
import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.service.FileService;
import com.imcode.imcms.addon.imagearchive.service.file.ThumbSize;
import com.imcode.imcms.addon.imagearchive.util.image.Color;
import com.imcode.imcms.addon.imagearchive.util.image.Format;
import com.imcode.imcms.addon.imagearchive.util.image.Gravity;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FileServiceImpl
implements FileService {
    private static final Log log = LogFactory.getLog(FileServiceImpl.class);
    public static final String[] IMAGE_EXTENSIONS = new String[]{"ai", "bmp", "eps", "gif", "jpeg", "jpg", "pct", "pdf", "pic", "pict", "png", "ps", "psd", "svg", "tif", "tiff", "xcf", "AI", "BMP", "EPC", "GIF", "JPEG", "JPG", "PCT", "PDF", "PIC", "PICT", "PNG", "PS", "PSD", "SVG", "TIF", "TIFF", "XCF"};
    public static final Set<String> IMAGE_EXTENSIONS_SET = new HashSet<String>(Arrays.asList(IMAGE_EXTENSIONS));
    public static final Pattern FILENAME_PATTERN = Pattern.compile("^.*?/?([^/\\:]+?)$");
    public static final String OSX_RESOURCE_FORK_PREFIX = "__MACOSX/";
    private static final String IMAGE_ORIGINAL_INFIX = "orig";
    private static final String IMAGE_FULL_INFIX = "full";
    private static final String IMAGE_SMALL_THUMB_INFIX = ThumbSize.SMALL.getName();
    private static final String IMAGE_MEDIUM_THUMB_INFIX = ThumbSize.MEDIUM.getName();
    private Map<LibrariesDto, List<File>> libraryToFiles = new HashMap<LibrariesDto, List<File>>();
    @Autowired
    private Config config;

    public File createTemporaryFile(String prefix) {
        try {
            return File.createTempFile(prefix, ".tmp", this.config.getTempPath());
        }
        catch (IOException ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public boolean deleteTemporaryFile(File prefix) {
        return prefix.delete();
    }

    public File getImageRootPath(long imageId) {
        return new File(this.config.getStoragePath(), Long.toString(imageId));
    }

    public File getImageFile(long imageId, String infix, boolean temporary) {
        StringBuilder filenameBuilder = new StringBuilder();
        filenameBuilder.append(imageId);
        filenameBuilder.append("_");
        filenameBuilder.append(infix);
        if (temporary) {
            filenameBuilder.append("_tmp");
        }
        return new File(this.getImageRootPath(imageId), filenameBuilder.toString());
    }

    public File getImageOriginalFile(long imageId, boolean temporary) {
        return this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, temporary);
    }

    public File getImageFullFile(long imageId, boolean temporary) {
        return this.getImageFile(imageId, IMAGE_FULL_INFIX, temporary);
    }

    public boolean storeImage(File tempFile, long imageId, boolean temporary) {
        log.debug((Object)(FileService.class.getSimpleName() + ".storeImage"));
        log.debug((Object)("Temp file path : " + tempFile));
        log.debug((Object)("Image Id : " + imageId));
        log.debug((Object)("Is Temporary : " + temporary));
        File originalFile = this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, temporary);
        log.debug((Object)originalFile);
        log.debug((Object)("Is original file exist? - " + originalFile.exists()));
        File fullFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, temporary);
        log.debug((Object)fullFile);
        File thumbSmallFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, temporary);
        log.debug((Object)thumbSmallFile);
        File thumbMedFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, temporary);
        log.debug((Object)thumbMedFile);
        try {
            originalFile.getParentFile().mkdirs();
            FileUtils.copyFile((File)tempFile, (File)originalFile);
            new ImageOp(this.config).input(originalFile).outputFormat(Format.JPEG).processToFile(fullFile);
            this.generateThumbnail(fullFile, thumbSmallFile, ThumbSize.SMALL);
            this.generateThumbnail(fullFile, thumbMedFile, ThumbSize.MEDIUM);
            log.debug((Object)"done");
            return true;
        }
        catch (IOException ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
            thumbSmallFile.delete();
            thumbMedFile.delete();
            fullFile.delete();
            originalFile.delete();
            return false;
        }
    }

    private void generateThumbnail(File inputFile, File outputFile, ThumbSize thumbnailSize) {
        new ImageOp(this.config).input(inputFile).resizeProportional(thumbnailSize.getWidth(), thumbnailSize.getHeight(), Color.WHITE, Gravity.CENTER).outputFormat(Format.JPEG).processToFile(outputFile);
    }

    public void rotateImage(long imageId, int angle, boolean temporary) {
        File fullFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, temporary);
        File thumbSmallFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, temporary);
        File thumbMedFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, temporary);
        new ImageOp(this.config).input(fullFile).rotate(angle).processToFile(fullFile);
        this.generateThumbnail(fullFile, thumbSmallFile, ThumbSize.SMALL);
        this.generateThumbnail(fullFile, thumbMedFile, ThumbSize.MEDIUM);
    }

    public void copyTemporaryImageToCurrent(long imageId) {
        File originalFile = this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, false);
        File fullFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, false);
        File thumbSmallFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, false);
        File thumbMedFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, false);
        File originalTempFile = this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, true);
        File fullTempFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, true);
        File thumbSmallTempFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, true);
        File thumbMedTempFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, true);
        try {
            FileUtils.copyFile((File)originalTempFile, (File)originalFile);
            FileUtils.copyFile((File)fullTempFile, (File)fullFile);
            FileUtils.copyFile((File)thumbSmallTempFile, (File)thumbSmallFile);
            FileUtils.copyFile((File)thumbMedTempFile, (File)thumbMedFile);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void createTemporaryCopyOfCurrentImage(long imageId) {
        File originalFile = this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, false);
        File fullFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, false);
        File thumbSmallFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, false);
        File thumbMedFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, false);
        File originalTempFile = this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, true);
        File fullTempFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, true);
        File thumbSmallTempFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, true);
        File thumbMedTempFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, true);
        try {
            FileUtils.copyFile((File)originalFile, (File)originalTempFile);
            FileUtils.copyFile((File)fullFile, (File)fullTempFile);
            FileUtils.copyFile((File)thumbSmallFile, (File)thumbSmallTempFile);
            FileUtils.copyFile((File)thumbMedFile, (File)thumbMedTempFile);
        }
        catch (Exception ex) {
            FileUtils.deleteQuietly((File)originalTempFile);
            FileUtils.deleteQuietly((File)fullTempFile);
            FileUtils.deleteQuietly((File)thumbSmallTempFile);
            FileUtils.deleteQuietly((File)thumbMedTempFile);
            throw new RuntimeException(ex);
        }
    }

    public void deleteTemporaryImage(long imageId) {
        File originalTempFile = this.getImageFile(imageId, IMAGE_ORIGINAL_INFIX, true);
        File fullTempFile = this.getImageFile(imageId, IMAGE_FULL_INFIX, true);
        File thumbSmallTempFile = this.getImageFile(imageId, IMAGE_SMALL_THUMB_INFIX, true);
        File thumbMedTempFile = this.getImageFile(imageId, IMAGE_MEDIUM_THUMB_INFIX, true);
        originalTempFile.delete();
        fullTempFile.delete();
        thumbSmallTempFile.delete();
        thumbMedTempFile.delete();
    }

    public void deleteImage(long imageId) {
        File rootPath = new File(this.config.getStoragePath(), Long.toString(imageId));
        try {
            FileUtils.deleteDirectory((File)rootPath);
        }
        catch (Exception ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Object[] getImageThumbnail(long imageId, ThumbSize thumbSize, boolean temporary) {
        try {
            String temp = temporary ? "_tmp" : "";
            File rootPath = new File(this.config.getStoragePath(), Long.toString(imageId));
            File thumbFile = new File(rootPath, String.format("%d_%s%s", imageId, thumbSize.getName(), temp));
            if (!thumbFile.exists()) {
                return null;
            }
            return new Object[]{thumbFile.length(), FileUtils.openInputStream((File)thumbFile)};
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public byte[] getThumbnail(long imageId, ThumbSize thumbSize, boolean temporary) {
        try {
            String temp = temporary ? "_tmp" : "";
            File rootPath = new File(this.config.getStoragePath(), Long.toString(imageId));
            File thumbFile = new File(rootPath, String.format("%d_%s%s", imageId, thumbSize.getName(), temp));
            if (!thumbFile.exists()) {
                return null;
            }
            return FileCopyUtils.copyToByteArray((File)thumbFile);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<File> getSubdirs(File file, FileFilter filter) {
        if (file == null) {
            return Collections.emptyList();
        }
        File[] subDirsTmp = file.listFiles(filter);
        if (subDirsTmp == null) {
            subDirsTmp = new File[]{};
        }
        List<File> subdirs = Arrays.asList(subDirsTmp);
        subdirs = new ArrayList<File>(subdirs);
        ArrayList<File> deepSubdirs = new ArrayList<File>();
        for (File subdir : subdirs) {
            deepSubdirs.addAll(this.getSubdirs(subdir, filter));
        }
        subdirs.addAll(deepSubdirs);
        return subdirs;
    }

    public List<File> listLibraryEntries(LibrariesDto library) {
        File libraryFile = new File(library.getFilepath(), library.getFolderNm());
        if (!libraryFile.exists() && !libraryFile.isDirectory()) {
            return Collections.emptyList();
        }
        if (!this.libraryToFiles.containsKey(library)) {
            ArrayList unsortedFiles = new ArrayList(FileUtils.listFiles((File)libraryFile, (String[])IMAGE_EXTENSIONS, (boolean)false));
            Collections.sort(unsortedFiles, new FileComparator());
            UnmodifiableList files = new UnmodifiableList(unsortedFiles);
            this.libraryToFiles.put(library, (List<File>)files);
        }
        return this.libraryToFiles.get(library);
    }

    public boolean storeImageToLibrary(LibrariesDto library, File tempFile, String fileName) {
        File imageFile = this.getLibraryFile(library, fileName);
        try {
            FileUtils.copyFile((File)tempFile, (File)imageFile);
            return true;
        }
        catch (Exception ex) {
            imageFile.delete();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeZipToLibrary(LibrariesDto library, File tempFile) {
        File parent = new File(library.getFilepath());
        File rootPath = new File(parent, library.getFolderNm());
        ZipFile zip = null;
        try {
            zip = new ZipFile(tempFile, 1);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String extension;
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName();
                Matcher matcher = FILENAME_PATTERN.matcher(fileName);
                if (fileName.startsWith(OSX_RESOURCE_FORK_PREFIX) || !matcher.matches() || StringUtils.isEmpty((CharSequence)(fileName = matcher.group(1).trim())) || !IMAGE_EXTENSIONS_SET.contains(extension = StringUtils.substringAfterLast((String)fileName, (String)".").toLowerCase())) continue;
                File entryFile = new File(rootPath, fileName);
                InputStream inputStream = null;
                BufferedOutputStream outputStream = null;
                try {
                    inputStream = zip.getInputStream(entry);
                    outputStream = new BufferedOutputStream(FileUtils.openOutputStream((File)entryFile));
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (Exception ex) {
                    try {
                        log.warn((Object)ex.getMessage(), (Throwable)ex);
                        entryFile.delete();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    continue;
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return false;
    }

    public void deleteFileFromLibrary(LibrariesDto library, String fileName) {
        File file = this.getLibraryFile(library, fileName);
        if (file.delete()) {
            this.libraryToFiles.remove(library);
        }
    }

    public File getImageFileFromLibrary(LibrariesDto library, String fileName) {
        File file = this.getLibraryFile(library, fileName);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private File getLibraryFile(LibrariesDto library, String fileName) {
        File parent = new File(library.getFilepath());
        return new File(parent, String.format("%s/%s", library.getFolderNm(), fileName));
    }
}

