package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.repository.ExifRepository;
import com.imcode.imcms.addon.imagearchive.service.ExifService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by Serhii from Ubrainians for Imcode
 * on 02.09.16.
 */
@Service
@Transactional
public class ExifServiceImpl implements ExifService {

    @Autowired
    private ExifRepository exifRepository;

    public Set<String> getAllArtists() {
        Set<String> artists = new HashSet<String>();
        List<Exif> allWithPresentedArtist = exifRepository.findAll();

        CollectionUtils.filter(allWithPresentedArtist, new Predicate<Exif>() {
            public boolean evaluate(Exif exif) {
                return !exif.getArtist().isEmpty();
            }
        });

        for (Exif exif : allWithPresentedArtist) {
            artists.add(exif.getArtist());
        }

        return artists;
    }
}
