package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class Facade {
    private final Config config;
    private final ExifService exifService;
    private final ImcmsImageService imcmsImageService;
    private final MessageSource messageSource;
    private final FileService fileService;
    private final ImageService imageService;
    private final KeywordService keywordService;

    @Autowired
    public Facade(ImcmsImageService imcmsImageService,
                  @Qualifier("remoteImageService") ImageService imageService,
                  @Qualifier("remoteKeywordService") KeywordService keywordService,
                  @Qualifier("remoteFileService") FileService fileService,
                  @Qualifier("remoteExifService") ExifService exifService,
                  MessageSource messageSource,
                  Config config) {

        this.imcmsImageService = imcmsImageService;
        this.imageService = imageService;
        this.keywordService = keywordService;
        this.fileService = fileService;
        this.messageSource = messageSource;
        this.exifService = exifService;
        this.config = config;
    }

    public ExifService getExifService() {
        return exifService;
    }

    public Config getConfig() {
        return config;
    }

    public FileService getFileService() {
        return fileService;
    }

    public ImageService getImageService() {
        return imageService;
    }

    public KeywordService getKeywordService() {
        return keywordService;
    }

    public ImcmsImageService getImcmsImageService() {
        return imcmsImageService;
    }

    public MessageSource getMessageSource() {
        return messageSource;
    }
}
