package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryType;
import com.imcode.imcms.addon.imagearchive.repository.CategoryTypeRepository;
import com.imcode.imcms.addon.imagearchive.service.CategoryTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Created by Serhii from Ubrainians for Imcode
 * on 05.09.16.
 */
@Service
public class CategoryTypeServiceImpl implements CategoryTypeService {

    @Autowired
    private CategoryTypeRepository categoryTypeRepository;

    @Transactional
    public Collection<CategoryType> getCategoryTypes() {
        return categoryTypeRepository.findAll();
    }

    @Transactional
    public Collection<Category> getCategoriesOfTypes(Collection<CategoryType> categoryTypes) {
        Collection<Category> result = new ArrayList<Category>();

        for (CategoryType categoryType : categoryTypes) {
            Collection<Category> categoriesOfType = getCategoriesOfType(categoryType);
            result.addAll(categoriesOfType);
        }

        return result;
    }

    @Transactional
    public Collection<Category> getCategoriesOfType(CategoryType categoryType) {
        return getCategoriesOfType(categoryType.getId());
    }

    @Transactional
    public Collection<Category> getCategoriesOfType(Integer id) {
        CategoryType categoryType = categoryTypeRepository.findOne(id);
        return categoryType.getCategories();
    }

    @Transactional
    public Collection<Long> getCategoryIdsOfTypes(Collection<CategoryType> categoryTypes) {
        Collection<Long> categoryIds = new ArrayList<Long>();
        Collection<Category> categoriesOfTypes = getCategoriesOfTypes(categoryTypes);

        for (Category categoriesOfType : categoriesOfTypes) {
            Long id = categoriesOfType.getId();
            categoryIds.add(id);
        }

        return categoryIds;
    }
}
