/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.repository.KeywordsRepository;
import com.imcode.imcms.addon.imagearchive.service.KeywordService;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KeywordServiceImpl
implements KeywordService {
    @Autowired
    private KeywordsRepository keywordsRepository;

    public Keyword createKeyword(String newKeywordName) throws KeywordExistsException {
        if (this.existsKeyword(newKeywordName)) {
            throw new KeywordExistsException();
        }
        Keyword keyword = new Keyword();
        keyword.setName(newKeywordName);
        this.keywordsRepository.save(keyword);
        return keyword;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Keyword> getKeywords() {
        List keywords = this.keywordsRepository.findAll();
        return keywords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void deleteKeyword(Long keywordId) {
        if (!this.keywordsRepository.exists(keywordId)) {
            return;
        }
        this.removeKeywordImages(keywordId);
        try {
            this.keywordsRepository.delete(keywordId);
        }
        catch (Exception ignore) {
            Keyword keyword = (Keyword)this.keywordsRepository.getOne(keywordId);
            this.keywordsRepository.save(keyword);
        }
        finally {
            try {
                this.keywordsRepository.flush();
            }
            catch (Exception exception) {}
        }
    }

    @Transactional
    private void removeKeywordImages(Long keywordId) {
        Keyword keyword = (Keyword)this.keywordsRepository.getOne(keywordId);
        keyword.getImages().clear();
        this.keywordsRepository.save(keyword);
        this.keywordsRepository.flush();
    }

    public void updateKeyword(Long keywordId, String keywordName) throws KeywordExistsException {
        Keyword keyword = (Keyword)this.keywordsRepository.findOne(keywordId);
        if (keyword != null) {
            keyword.setName(keywordName);
            this.keywordsRepository.save(keyword);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean existsKeyword(String newKeywordName) {
        return this.keywordsRepository.findByName(newKeywordName) != null;
    }

    public List<Keyword> findKeywordsByNameLike(String text) {
        return this.keywordsRepository.findByNameLike(text);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Keyword getKeyword(Long id) {
        return (Keyword)this.keywordsRepository.findOne(id);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Keyword findByName(String name) {
        return this.keywordsRepository.findByName(name);
    }

    public Keyword createOrGet(String name) {
        try {
            return this.createKeyword(name);
        }
        catch (KeywordExistsException e) {
            return this.findByName(name);
        }
    }

    public List<Keyword> findByName(List<String> names) {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        for (String name : names) {
            Keyword keyword = this.findByName(name);
            if (keyword == null) continue;
            keywords.add(keyword);
        }
        return keywords;
    }
}

