package com.imcode.imcms.addon.imagearchive.repository;

import com.imcode.imcms.addon.imagearchive.entity.Image;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * Created by vitaly on 24.04.15.
 */
public interface ImageRepository extends JpaRepository<Image, Long> {
    @Query("SELECT i FROM Image i JOIN FETCH i.exif WHERE i.id = :id")
    Image findByIDAndFetchExif(@Param("id") Long id);

    //@Query("SELECT count(i) FROM Image i LEFT OUTER JOIN Category c ON i.")
//    public int countImageWithCategoies(Iterable<Category> categories)
    @Query("SELECT i FROM Image i WHERE (SELECT c FROM Category c WHERE c.id = :id) MEMBER OF i.categories OR (:id = -2 AND i.categories IS EMPTY) OR :id = -1")
    List<Image> findImageWithCategoryId(@Param("id") Long id);
}
