/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.filter.SubDirectoriesFileFilter;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRepository;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRolesRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class LibraryServiceImpl
implements LibraryService {
    private static final Log log = LogFactory.getLog(LibraryServiceImpl.class);
    @Autowired
    private Facade facade;
    @Autowired
    private LibraryRepository libraryRepository;
    @Autowired
    private LibraryRolesRepository libraryRolesRepository;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Library findLibraryById(Long libraryId) {
        return (Library)this.libraryRepository.findOne(libraryId);
    }

    public void syncLibraryFolders() {
        this.syncOldLibraryFolders((short)1);
        this.syncOldLibraryFolders((short)0);
    }

    private void syncOldLibraryFolders(short typeOldLibrary) {
        String folderNm;
        Object[] oldLibraryFiles = this.facade.getConfig().getImcmsOldLibraryPaths();
        HashSet files = new HashSet();
        for (File file : oldLibraryFiles) {
            List tmp = this.facade.getFileService().getSubdirs(file, (FileFilter)new SubDirectoriesFileFilter());
            files.addAll(tmp);
        }
        CollectionUtils.addAll(files, (Object[])oldLibraryFiles);
        if (files.isEmpty()) {
            this.libraryRepository.deleteByLibraryType(typeOldLibrary);
        }
        List<Library> existingLibraries = this.libraryRepository.findByLibraryType(typeOldLibrary);
        LinkedList<Library> toDelete = new LinkedList<Library>();
        for (Library library : existingLibraries) {
            folderNm = library.getFolderNm();
            String filepath = library.getFilepath();
            File file = new File(filepath, folderNm);
            if (!files.contains(file)) {
                toDelete.add(library);
                continue;
            }
            files.remove(file);
        }
        if (!toDelete.isEmpty()) {
            for (Library library : toDelete) {
                try {
                    LibraryRoles libraryRoles = (LibraryRoles)this.libraryRolesRepository.findOne(Integer.valueOf(library.getId().intValue()));
                    this.libraryRolesRepository.delete(libraryRoles);
                    this.libraryRepository.delete(library);
                }
                catch (Exception e) {
                    log.error((Object)String.format(new Date() + ": Error deleting library %s", library.toString()), (Throwable)e);
                }
            }
        }
        for (File file : files) {
            String filePath;
            folderNm = file.getName();
            if (this.libraryRepository.findByFolderNameAndFilePath(folderNm, filePath = StringUtils.substring((String)folderNm, (int)0, (int)120)) == null) continue;
            Library lib = new Library();
            lib.setFolderNm(folderNm);
            lib.setLibraryNm(filePath);
            lib.setFilepath(file.getParent());
            lib.setLibraryType(typeOldLibrary);
            try {
                this.libraryRepository.save(lib);
            }
            catch (Exception e) {
                log.error((Object)String.format(new Date() + ": Library already exist,  %s", lib.toString()), (Throwable)e);
            }
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Library> findLibraries() {
        return this.libraryRepository.findAll();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<LibraryRolesDto> findLibraryRoles(Long libraryId) {
        return Collections.emptyList();
    }

    public void updateLibraryRoles(int libraryId, String libraryNm, List<LibraryRolesDto> libraryRoles) {
    }

    public List<LibrariesDto> librariesToDto(List<Library> libraries) {
        LinkedList<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();
        for (Library library : libraries) {
            LibrariesDto librariesDto = this.convertToLibraryDto(library);
            librariesDtos.add(librariesDto);
        }
        return librariesDtos;
    }

    public LibrariesDto convertToLibraryDto(Library library) {
        LibrariesDto librariesDto = new LibrariesDto();
        librariesDto.setId(library.getId());
        librariesDto.setLibraryNm(library.getLibraryNm());
        librariesDto.setFilepath(library.getFilepath());
        librariesDto.setFolderNm(library.getFolderNm());
        return librariesDto;
    }

    public LibrariesDto findLibraryDtoById(Long id) {
        return this.convertToLibraryDto((Library)this.libraryRepository.findOne(id));
    }

    public List<LibrariesDto> findLibraryDtos() {
        return this.librariesToDto(this.libraryRepository.findAll());
    }
}

