/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.command.ChangeImageDataCommand;
import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.json.UploadResponse;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRepository;
import com.imcode.imcms.addon.imagearchive.repository.ExifRepository;
import com.imcode.imcms.addon.imagearchive.repository.ImageRepository;
import com.imcode.imcms.addon.imagearchive.repository.KeywordsRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.ImageService;
import com.imcode.imcms.addon.imagearchive.service.file.FileServiceImpl;
import com.imcode.imcms.addon.imagearchive.util.Pagination;
import com.imcode.imcms.addon.imagearchive.util.exif.ExifData;
import com.imcode.imcms.addon.imagearchive.util.exif.ExifUtils;
import com.imcode.imcms.addon.imagearchive.util.exif.Flash;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import com.imcode.imcms.addon.imagearchive.validator.ChangeImageDataValidator;
import com.imcode.imcms.addon.imagearchive.validator.ImageUploadValidator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ImageServiceImpl
implements ImageService {
    private static final Log log = LogFactory.getLog(ImageServiceImpl.class);
    @Autowired
    JpaTransactionManager transactionManager;
    @Autowired
    private Facade facade;
    @Autowired
    private ImageRepository imageRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private KeywordsRepository keywordsRepository;
    @Autowired
    private ExifRepository exifRepository;
    @Autowired
    private Config config;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Image findById(Long imageId) {
        return (Image)this.imageRepository.findOne(imageId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Image findById(Long imageId, List<Long> categoryIds) {
        Image image = this.findById(imageId);
        if (image != null) {
            List categories = image.getCategories();
            if (categories == null || categories.size() <= 0) {
                return image;
            }
            for (Category category : categories) {
                if (!categoryIds.contains(category.getId())) continue;
                return image;
            }
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Exif findExifByPK(Long imageId) {
        Image image = this.imageRepository.findByIDAndFetchExif(imageId);
        if (image != null) {
            return image.getExif();
        }
        return null;
    }

    public Image createImage(File tempFile, ImageInfo imageInfo, String imageName, short status) {
        Image image = this.create(tempFile, imageInfo, imageName);
        image.setStatus(status);
        image = (Image)this.imageRepository.save(image);
        if (!this.facade.getFileService().storeImage(tempFile, image.getId().longValue(), false)) {
            return null;
        }
        return image;
    }

    private Image create(File tempFile, ImageInfo imageInfo, String imageName) {
        Image image = new Image();
        String copyright = "";
        String description = "";
        String artist = "";
        String manufacturer = null;
        String model = null;
        String compression = null;
        Double exposure = null;
        String exposureProgram = null;
        Float fStop = null;
        Date dateOriginal = null;
        Date dateDigitized = null;
        Flash flash = null;
        Float focalLength = null;
        String colorSpace = null;
        Integer xResolution = null;
        Integer yResolution = null;
        Integer resolutionUnit = null;
        Integer pixelXDimension = null;
        Integer pixelYDimension = null;
        Integer ISO = null;
        ExifData data = ExifUtils.getExifData((File)tempFile);
        if (data != null) {
            copyright = StringUtils.substring((String)data.getCopyright(), (int)0, (int)255);
            description = StringUtils.substring((String)data.getDescription(), (int)0, (int)255);
            artist = StringUtils.substring((String)data.getArtist(), (int)0, (int)255);
            xResolution = data.getxResolution();
            yResolution = data.getyResolution();
            manufacturer = data.getManufacturer();
            model = data.getModel();
            compression = data.getCompression();
            exposure = data.getExposure();
            exposureProgram = data.getExposureProgram();
            fStop = data.getfStop();
            flash = data.getFlash();
            focalLength = data.getFocalLength();
            colorSpace = data.getColorSpace();
            resolutionUnit = data.getResolutionUnit();
            pixelXDimension = data.getPixelXDimension();
            pixelYDimension = data.getPixelYDimension();
            dateOriginal = data.getDateOriginal();
            dateDigitized = data.getDateDigitized();
            ISO = data.getISO();
        }
        Exif originalExif = new Exif(xResolution, yResolution, description, artist, copyright, manufacturer, model, compression, exposure, exposureProgram, fStop, flash, focalLength, colorSpace, resolutionUnit, pixelXDimension, pixelYDimension, dateOriginal, dateDigitized, ISO);
        String uploadedBy = "";
        image.setUploadedBy(uploadedBy);
        image.setName(StringUtils.substring((String)imageName, (int)0, (int)255));
        image.setFormat(imageInfo.getFormat().getOrdinal());
        image.setFileSize((int)tempFile.length());
        image.setWidth(imageInfo.getWidth());
        image.setHeight(imageInfo.getHeight());
        image.setExif(originalExif);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Image> createImagesFromZip(File tempFile) {
        ZipFile zip = null;
        ArrayList<Image> createdImages = new ArrayList<Image>();
        try {
            zip = new ZipFile(tempFile, 1);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                BufferedOutputStream outputStream;
                InputStream inputStream;
                File entryFile;
                block19: {
                    ImageInfo imageInfo;
                    String fileName;
                    block18: {
                        String extension;
                        ZipEntry entry = entries.nextElement();
                        fileName = entry.getName();
                        Matcher matcher = FileServiceImpl.FILENAME_PATTERN.matcher(fileName);
                        if (fileName.startsWith("__MACOSX/") || !matcher.matches() || StringUtils.isEmpty((CharSequence)(fileName = matcher.group(1).trim())) || !FileServiceImpl.IMAGE_EXTENSIONS_SET.contains(extension = StringUtils.substringAfterLast((String)fileName, (String)".").toLowerCase())) continue;
                        entryFile = this.facade.getFileService().createTemporaryFile("zipEntryTmp");
                        inputStream = null;
                        outputStream = null;
                        inputStream = zip.getInputStream(entry);
                        outputStream = new BufferedOutputStream(FileUtils.openOutputStream((File)entryFile));
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        ((OutputStream)outputStream).flush();
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        imageInfo = ImageOp.getImageInfo((Config)this.config, (File)entryFile);
                        if (imageInfo != null && imageInfo.getFormat() != null && imageInfo.getWidth() >= 1 && imageInfo.getHeight() >= 1) break block18;
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        entryFile.delete();
                        continue;
                    }
                    try {
                        Image image = this.createImage(entryFile, imageInfo, fileName, (short)1);
                        if (image == null) break block19;
                        createdImages.add(image);
                    }
                    catch (Exception ex) {
                        try {
                            log.warn((Object)ex.getMessage(), (Throwable)ex);
                            entryFile.delete();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(outputStream);
                            IOUtils.closeQuietly((InputStream)inputStream);
                            entryFile.delete();
                            throw throwable;
                            return createdImages;
                        }
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        entryFile.delete();
                        continue;
                    }
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                entryFile.delete();
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return createdImages;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void createImages(List<Object[]> tuples) {
        for (Object[] tuple : tuples) {
            File tempFile = (File)tuple[0];
            ImageInfo imageInfo = (ImageInfo)tuple[1];
            String imageName = (String)tuple[2];
            this.createImage(tempFile, imageInfo, imageName, (short)1);
        }
    }

    public void deleteImage(Long imageId) {
        this.imageRepository.delete(imageId);
        this.facade.getFileService().deleteImage(imageId.longValue());
    }

    public void updateFullData(Image image, List<Long> categoryIds, List<String> imageKeywords) {
        List categories = this.categoryRepository.findAll(categoryIds);
        LinkedList<Keyword> keywords = new LinkedList<Keyword>();
        for (String keywordString : imageKeywords) {
            Keyword keyword = (Keyword)this.keywordsRepository.save(new Keyword(keywordString));
            keywords.add(keyword);
        }
        image.setCategories(categories);
        image.setKeywords(keywords);
        this.imageRepository.save(image);
    }

    public void updateData(Image image, List<Long> categoryIds, List<String> imageKeywords) {
        this.updateFullData(image, categoryIds, imageKeywords);
    }

    private void updateImageCategories(Image image, List<Long> categoryIds) {
        List categories = this.categoryRepository.findAll(categoryIds);
        image.setCategories(categories);
        this.imageRepository.save(image);
    }

    private void updateImageKeywords(Image image, List<String> imageKeywords) {
        LinkedList<Keyword> keywords = new LinkedList<Keyword>();
        for (String keywordString : imageKeywords) {
            Keyword keyword = (Keyword)this.keywordsRepository.save(new Keyword(keywordString));
            keywords.add(keyword);
        }
        image.setKeywords(keywords);
        this.imageRepository.save(image);
    }

    public void archiveImage(Long imageId) {
        this.setStatus(imageId, (short)2);
    }

    private void setStatus(Long imageId, short status) {
        Image image = (Image)this.imageRepository.findOne(imageId);
        if (image != null) {
            image.setStatus(status);
            this.imageRepository.save(image);
        }
    }

    public void unarchiveImage(Long imageId) {
        this.setStatus(imageId, (short)1);
    }

    public List<Image> getAllImages() {
        return this.imageRepository.findAll();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Long searchImagesCount(List<Long> categoryIds) {
        HashSet imageSet = new HashSet();
        List categories = this.categoryRepository.findAll(categoryIds);
        for (Category category : categories) {
            imageSet.addAll(category.getImages());
        }
        return imageSet.size();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Image> searchImages(SearchImageCommand command) {
        return this.searchImages(null, command);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Image> searchImages(Pagination pag, SearchImageCommand command) {
        Predicate whereClause;
        PageRequest pageRequest = pag != null ? new PageRequest(pag.getCurrentPage(), pag.getPageSize()) : null;
        EntityManager entityManager = this.transactionManager.getEntityManagerFactory().createEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(Image.class);
        Root root = criteriaQuery.from(Image.class);
        Join categoriesJoin = root.join("categories", JoinType.LEFT);
        Join keywordsJoin = root.join("keywords", JoinType.LEFT);
        Join exifJoin = root.join("exif", JoinType.LEFT);
        List categoryIds = command.getCategoryIds();
        boolean hasNoCategory = categoryIds.remove((Object)-2);
        Predicate predicate = hasNoCategory ? (categoryIds.size() > 0 ? builder.or((Expression)categoriesJoin.get("id").in((Collection)command.getCategoryIds()), (Expression)builder.isEmpty((Expression)root.get("categories"))) : builder.isEmpty((Expression)root.get("categories"))) : (whereClause = categoriesJoin.get("id").in((Collection)command.getCategoryIds()));
        if (command.getKeywordId() > 0L) {
            Predicate keywordPredicate = builder.equal((Expression)keywordsJoin.get("id"), (Object)command.getKeywordId());
            whereClause = builder.and((Expression)keywordPredicate, (Expression)whereClause);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{command.getFreetext()})) {
            String formattedFreeText = "%" + command.getFreetext().trim() + "%";
            Predicate likePredicate = builder.like((Expression)root.get("name"), formattedFreeText);
            if (!command.isFileNamesOnly()) {
                likePredicate = builder.or(new Predicate[]{likePredicate, builder.like((Expression)root.get("altText"), formattedFreeText), builder.like((Expression)exifJoin.get("description"), formattedFreeText), builder.like((Expression)exifJoin.get("artist"), formattedFreeText), builder.like((Expression)exifJoin.get("copyright"), formattedFreeText), builder.like((Expression)exifJoin.get("manufacturer"), formattedFreeText), builder.like((Expression)exifJoin.get("model"), formattedFreeText), builder.like((Expression)exifJoin.get("compression"), formattedFreeText), builder.like((Expression)exifJoin.get("colorSpace"), formattedFreeText), builder.like((Expression)exifJoin.get("colorSpace"), formattedFreeText)});
            }
            whereClause = builder.and((Expression)whereClause, (Expression)likePredicate);
        }
        if (command.getShow() != 0) {
            Predicate showProperty = null;
            switch (command.getShow()) {
                case 1: {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(new Date());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    Date today = cal.getTime();
                    showProperty = builder.greaterThanOrEqualTo((Expression)root.get("createdDt"), (Comparable)today);
                    break;
                }
                case 2: {
                    showProperty = builder.equal((Expression)root.get("status"), (Object)2);
                    break;
                }
                case 3: {
                    Predicate licensedBefore = builder.lessThanOrEqualTo((Expression)root.get("licenseDt"), (Comparable)new Date());
                    Predicate licenseEndsLater = builder.greaterThanOrEqualTo((Expression)root.get("licenseEndDt"), (Comparable)new Date());
                    showProperty = builder.and((Expression)licensedBefore, (Expression)licenseEndsLater);
                    break;
                }
            }
            if (showProperty != null) {
                whereClause = builder.and((Expression)whereClause, showProperty);
            }
        }
        criteriaQuery.where((Expression)whereClause);
        TypedQuery query = entityManager.createQuery(criteriaQuery.select((Selection)root).distinct(true));
        if (pageRequest != null) {
            query.setFirstResult(pageRequest.getOffset()).setMaxResults(pageRequest.getPageSize());
        }
        return query.getResultList();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Category> findImageCategories(Long imageId) {
        Image image = (Image)this.imageRepository.findOne(imageId);
        LinkedList<Category> categories = new LinkedList<Category>();
        if (image != null) {
            return image.getCategories();
        }
        return categories;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Category> findAvailableImageCategories(Long imageId) {
        return this.findImageCategories(imageId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<String> findAvailableKeywords(Long imageId) {
        return this.findImageKeywords(imageId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<String> findImageKeywords(Long imageId) {
        List keywords;
        Image image = (Image)this.imageRepository.findOne(imageId);
        LinkedList<String> keywordStrings = new LinkedList<String>();
        if (image != null && (keywords = image.getKeywords()) != null) {
            for (Keyword keyword : image.getKeywords()) {
                keywordStrings.add(keyword.getName());
            }
        }
        return keywordStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadHandler(byte[] file, String fileName, Integer fileCount, BindingResult result, ChangeImageDataCommand changeData, BindingResult dataResult) {
        FieldError error;
        ArrayList<String> errors;
        MockMultipartFile multipartFile = new MockMultipartFile(fileName, file);
        ImageUploadValidator validator = new ImageUploadValidator(this.facade);
        ValidationUtils.invokeValidator((Validator)validator, (Object)multipartFile, (Errors)result);
        if ((fileCount > 0 || validator.isZipFile()) && changeData.isSubmitted()) {
            ChangeImageDataValidator dataValidator = new ChangeImageDataValidator(this.facade);
            ValidationUtils.invokeValidator((Validator)dataValidator, (Object)changeData, (Errors)dataResult);
        }
        UploadResponse uploadResponse = new UploadResponse();
        if (!result.hasErrors() && !dataResult.hasErrors()) {
            try {
                if (validator.isZipFile()) {
                    List images = this.facade.getImageService().createImagesFromZip(validator.getTempFile());
                    if (changeData.isSubmitted()) {
                        for (Image image : images) {
                            if (image == null) continue;
                            changeData.setImageNm(image.getName());
                            changeData.toImage(image);
                            this.facade.getImageService().updateData(image, changeData.getCategoryIds(), changeData.getImageKeywordNames());
                        }
                    }
                } else {
                    Image image;
                    if (fileCount > 1) {
                        image = this.facade.getImageService().createImage(validator.getTempFile(), validator.getImageInfo(), validator.getImageName(), (short)1);
                    } else {
                        image = this.facade.getImageService().createImage(validator.getTempFile(), validator.getImageInfo(), validator.getImageName(), (short)0);
                        if (changeData.isSubmitted() && image != null) {
                            changeData.toImage(image);
                            this.facade.getImageService().updateData(image, changeData.getCategoryIds(), changeData.getImageKeywordNames());
                        }
                    }
                    if (image == null) {
                        result.rejectValue("file", "addImage.invalidImageError");
                    } else if (changeData.isSubmitted()) {
                        changeData.setImageNm(image.getName());
                        changeData.toImage(image);
                        this.facade.getImageService().updateData(image, changeData.getCategoryIds(), changeData.getImageKeywordNames());
                    }
                }
            }
            catch (Exception ex) {
                log.fatal((Object)ex.getMessage(), (Throwable)ex);
                result.rejectValue("file", "addImage.invalidImageError");
            }
            finally {
                validator.getTempFile().delete();
            }
        }
        if (result.hasErrors()) {
            errors = new ArrayList();
            for (Object errorObj : result.getFieldErrors()) {
                error = (FieldError)errorObj;
                errors.add(this.facade.getMessageSource().getMessage(error.getCode(), error.getArguments(), null));
            }
            uploadResponse.setImageErrors(errors);
        }
        if (dataResult.hasErrors()) {
            errors = new HashMap();
            for (Object errorObj : dataResult.getFieldErrors()) {
                error = (FieldError)errorObj;
                errors.put(error.getField(), this.facade.getMessageSource().getMessage(error.getCode(), error.getArguments(), null));
            }
            uploadResponse.setDataErrors((Map<String, String>)((Object)errors));
        }
    }

    public File uploadFile(byte[] data) {
        File tempFile = this.facade.getFileService().createTemporaryFile("img_upload_" + Math.round(Math.random() * 100000.0));
        try {
            FileOutputStream output = new FileOutputStream(tempFile);
            IOUtils.write((byte[])data, (OutputStream)output);
        }
        catch (IOException e) {
            return null;
        }
        return tempFile;
    }
}

