package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AccessCodeFilter implements Filter {
    private static final Log log = LogFactory.getLog(AccessCodeFilter.class);
    private static final String CODE_PARAMETER = "code";
    private static final char CODE_SEPARATOR = ';';


    private FilterConfig filterConfig = null;
    private Facade facade;
    private Config config;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = context.getBean(Facade.class);
        this.config = context.getBean(Config.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
//        fixUTF8(request, response);

        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;

        //Getting hash code of query string
        String code = httpRequest.getParameter(CODE_PARAMETER);
        //Copy param map
        Map params = new HashMap<String, String[]>();
        params.putAll(httpRequest.getParameterMap());
        //Kick out the code param
        params.remove(CODE_PARAMETER);
        String queryString = Utils.buildQueryStringMulti(params) + CODE_SEPARATOR + config.getAccessCode();
        //Getting md5 of query string with access code
        String queryMd5 = Utils.md5Custom(queryString);

        //send error if hash code not equals
        if (code == null || !code.equalsIgnoreCase(queryMd5)) {
            httpResponse.sendError(HttpServletResponse.SC_UNAUTHORIZED);
            return;
        }

        chain.doFilter(httpRequest, httpResponse);
    }


//    private void fixUTF8(ServletRequest request, ServletResponse response) throws IOException {
//        request.setCharacterEncoding("UTF-8");
//        response.setCharacterEncoding("UTF-8");
//    }

    public void destroy() {
    }

    public static void main(String[] args) {
        Map m1 = new HashMap();
        Map m2 = new HashMap();
        m1.put(1, 1);
        m1.put(2, 2);
        m1.put(3, 3);
        m1.put(4, 4);

        m2.putAll(m1);
        System.out.println(m2);


    }
}
