package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.repository.KeywordsRepository;
import com.imcode.imcms.addon.imagearchive.service.KeywordService;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class KeywordServiceImpl implements KeywordService {
    @Autowired
//    @Qualifier("hibernateTemplate")
//    private HibernateTemplate template;
    private KeywordsRepository keywordsRepository;

    public Keyword createKeyword(final String newKeywordName) throws KeywordExistsException {
//        return (Keyword) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
        if (existsKeyword(newKeywordName)) {
            throw new KeywordExistsException();
        }

        Keyword keyword = new Keyword();
        keyword.setName(newKeywordName);
        keywordsRepository.save(keyword);
//                session.persist(keyword);
//                session.flush();
        return keyword;
//            }

//        });
    }

    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Keyword> getKeywords() {
        List<Keyword> keywords = keywordsRepository.findAll();
        return keywords;
//        List<String> strings = new LinkedList<String>();
//
//        for (Keyword keyword :keywords) {
//            strings.add(keyword.getName());
//        }
//
//        return strings;
//        return (List<Keyword>) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                Criteria crit = session.createCriteria(Keyword.class, "k");
//                crit.addOrder(Order.asc("k.keywordNm"));
//                return crit.list();
//            }
//        });
    }

    @Transactional
    public void deleteKeyword(final Long keywordId) {
        if (!keywordsRepository.exists(keywordId)) return;
        Keyword keyword = keywordsRepository.getOne(keywordId);
        keyword.getImages().clear();
        keywordsRepository.save(keyword);
        keywordsRepository.delete(keywordId);
        keywordsRepository.flush();
//        template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                session.createQuery("DELETE FROM ImageKeywords ik WHERE ik.keywordId = :keywordId")
//                        .setLong("keywordId", keywordId)
//                        .executeUpdate();
//
//                session.createQuery("DELETE FROM Keywords k WHERE k.id = :keywordId")
//                        .setLong("keywordId", keywordId)
//                        .executeUpdate();
//
//                return null;
//            }
//        });
    }

    public void updateKeyword(final Long keywordId, final String keywordName) throws KeywordExistsException {
        Keyword keyword = keywordsRepository.findOne(keywordId);
        if (keyword != null) {
//            throw new KeywordExistsException();
            keyword.setName(keywordName);
            keywordsRepository.save(keyword);
        }

//        template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                if (existsKeyword(keywordId, keywordName)) {
//                    throw new KeywordExistsException();
//                }
//
//                session.createQuery(
//                        "UPDATE Keywords k SET k.keywordNm = :keywordName WHERE k.id = :keywordId")
//                        .setString("keywordName", keywordName)
//                        .setLong("keywordId", keywordId)
//                        .executeUpdate();
//
//                return null;
//            }
//        });
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean existsKeyword(final String newKeywordName) {
        return keywordsRepository.findByName(newKeywordName) != null;
//        return (Boolean) template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return ((Number) session.createCriteria(Keyword.class, "k")
//                        .add(Restrictions.sqlRestriction("{alias}.keyword_nm COLLATE utf8_bin = ?", newKeywordName, Hibernate.STRING))
//                        .setProjection(Projections.rowCount())
//                        .list().get(0)).longValue() > 0L;
//            }
//        });
    }

    //    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public boolean existsKeyword(final long keywordId, final String newKeywordName) {
//        return (Boolean) template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return ((Number) session.createCriteria(Keyword.class, "k")
//                        .add(Restrictions.sqlRestriction("{alias}.keyword_nm COLLATE utf8_bin = ?", newKeywordName, Hibernate.STRING))
//                        .add(Restrictions.ne("k.id", keywordId))
//                        .setProjection(Projections.rowCount())
//                        .list().get(0)).longValue() > 0L;
//            }
//        });
//    }
    public List<Keyword> findKeywordsByNameLike(String text) {
        return keywordsRepository.findByNameLike(text);
    }
}
