package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRepository;
import com.imcode.imcms.addon.imagearchive.service.CategoryService;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class CategoryServiceImpl implements CategoryService {
    @Autowired
    private CategoryRepository repository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean existsCategory(final String categoryName) {
        return repository.findByName(categoryName) != null;
    }

    public Category createCategory(final String categoryName) throws CategoryExistsException {
        if (repository.findByName(categoryName) != null) {
            throw new CategoryExistsException();
        }

        Category category = new Category(categoryName);

        return repository.save(category);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Category getCategory(final Long categoryId) {
        return repository.findOne(categoryId);
    }

    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Category> getCategories() {
        return repository.findAll();
    }

    public void deleteCategory(final Long categoryId) {
        repository.delete(categoryId);
    }

    public void updateCategory(final Long categoryId, final String categoryName) throws CategoryExistsException {
        Category existsCategory = repository.findOne(categoryId);

        if (existsCategory != null && repository.findByName(categoryName) == null) {
            existsCategory.setName(categoryName);
            repository.save(existsCategory);
        }
    }
}
