package com.imcode.imcms.addon.imagearchive.tag.func;

import com.imcode.imcms.addon.imagearchive.dto.LibraryEntryDto;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.jsp.PageContext;
import java.util.List;

public class Functions {
    public static boolean isInArchive(LibraryEntryDto img, PageContext pageContext) {
        if(img == null) {
            return false;
        }

        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(pageContext.getServletContext());
        Facade facade = (Facade) context.getBean("facade");

        List<Image> archiveImages = facade.getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (image.getName().equals(img.getFileName()) && image.getFileSize() == img.getFileSize()) {
                return true;
            }
        }

        return false;
    }
}
