/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.validator;

import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.tag.func.Functions;
import com.imcode.imcms.addon.imagearchive.util.ValidatorUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class SearchImageValidator
implements Validator {
    private Facade facade;

    public SearchImageValidator(Facade facade) {
        this.facade = facade;
    }

    public boolean supports(Class clazz) {
        return SearchImageCommand.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        short sortBy;
        SearchImageCommand command = (SearchImageCommand)target;
        short show = command.getShow();
        if (show < 0 || show > 3) {
            command.setShow((short)0);
        }
        List categoryIds = command.getCategoryIds();
        int[] permissions = new int[]{};
        if (categoryIds != null && !SearchImageCommand.CATEGORY_ALL.equals(categoryIds) && !SearchImageCommand.CATEGORY_NO_CATEGORY.equals(categoryIds)) {
            ArrayList unavailableCategoryIds = new ArrayList();
            if (unavailableCategoryIds.size() > 0) {
                errors.rejectValue("categoryIds", "searchImage.categoryPermissionError", (Object[])new String[]{Functions.join(unavailableCategoryIds, ", ")}, null);
            }
        } else if (SearchImageCommand.CATEGORY_NO_CATEGORY.equals(categoryIds)) {
            command.setCategoryIds(SearchImageCommand.CATEGORY_ALL);
        }
        ValidatorUtils.rejectValueIfLonger("freetext", 120, "fieldLengthError", errors);
        command.setFreetext(StringUtils.trimToNull((String)command.getFreetext()));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String licenseDt = StringUtils.trimToNull((String)command.getLicenseDt());
        Date licenseDate = null;
        if (licenseDt != null) {
            try {
                licenseDate = df.parse(licenseDt);
            }
            catch (ParseException ex) {
                errors.rejectValue("licenseDt", "invalidStartDateError");
            }
        }
        command.setLicenseDate(licenseDate);
        String licenseEndDt = StringUtils.trimToNull((String)command.getLicenseEndDt());
        Date licenseEndDate = null;
        if (licenseEndDt != null) {
            try {
                licenseEndDate = df.parse(licenseEndDt);
            }
            catch (ParseException ex) {
                errors.rejectValue("licenseEndDt", "invalidEndDateError");
            }
        }
        command.setLicenseEndDate(licenseEndDate);
        String activeDt = StringUtils.trimToNull((String)command.getActiveDt());
        Date activeDate = null;
        if (activeDt != null) {
            try {
                activeDate = df.parse(activeDt);
            }
            catch (ParseException ex) {
                errors.rejectValue("activeDt", "invalidStartDateError");
            }
        }
        command.setActiveDate(activeDate);
        String activeEndDt = StringUtils.trimToNull((String)command.getActiveEndDt());
        Date activeEndDate = null;
        if (activeEndDt != null) {
            try {
                activeEndDate = df.parse(activeEndDt);
            }
            catch (ParseException ex) {
                errors.rejectValue("activeEndDt", "invalidEndDateError");
            }
        }
        command.setActiveEndDate(activeEndDate);
        int resultsPerPage = command.getResultsPerPage();
        if (resultsPerPage < 10 || resultsPerPage > 100) {
            command.setResultsPerPage(10);
        }
        if ((sortBy = command.getSortBy()) < 0 || sortBy > 2) {
            command.setSortBy((short)0);
        }
        String artist = StringUtils.trimToNull((String)command.getArtist());
        command.setArtist(artist);
    }
}

