package com.imcode.imcms.addon.imagearchive.util;

import org.springframework.web.servlet.ModelAndView;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by vitaly on 28.04.15.
 */
public class FakeModelAndView {
    private String view = "";
    private Map<String, Node> model = new HashMap<String, Node>();

//    @JsonDeserialize()


    public FakeModelAndView() {
    }

    public FakeModelAndView(String view) {
        this.view = view;
    }

    public FakeModelAndView(ModelAndView modelAndView) {
        this.view = modelAndView.getViewName();
        this.model = new HashMap<String, Node>();

        for (Map.Entry<String, Object> entry :modelAndView.getModel().entrySet()) {
            model.put(entry.getKey(), new Node(entry.getValue()));
        }

    }

    public void addObject(String key, Object value) {
        model.put(key, new Node(value));
    }

    public String getView() {
        return view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public Map<String, Node> getModel() {
        return model;
    }

    public void setModel(Map<String, Node> model) {
        this.model = model;
    }

    public ModelAndView toModelAndView() {
        return new ModelAndView(view, model);
    }
}
