package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileFilter;
import java.util.*;

@Service
@Transactional
public class LibraryServiceImpl implements LibraryService {
	private static final Log log = LogFactory.getLog(LibraryServiceImpl.class);

	@Autowired
    private Facade facade;

    @Autowired
    private LibraryRepository libraryRepository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Library findLibraryById(final Long libraryId) {
        return libraryRepository.findOne(libraryId);
    }

    public void syncLibraryFolders() {
        syncOldLibraryFolders(Library.TYPE_OLD_LIBRARY);
        syncOldLibraryFolders(Library.TYPE_STANDARD);
    }

    private void syncOldLibraryFolders(short typeOldLibrary) {
        File[] oldLibraryFiles = facade.getConfig().getImcmsOldLibraryPaths();
        Set<File> files = new HashSet<File>();
        for (File f : oldLibraryFiles) {
            List<File> tmp = facade.getFileService().getSubdirs(f, new FileFilter() {
                public boolean accept(File file) {
                    String name = file.getName();

                    return file.isDirectory() && name.length() <= 255;
                }
            });

            files.addAll(tmp);
        }

        CollectionUtils.addAll(files, oldLibraryFiles);

        if (files.isEmpty()) {
            libraryRepository.deleteByLibraryType(typeOldLibrary);
        }

        List<Library> existingLibraries = libraryRepository.findByLibraryType(typeOldLibrary);
        List<Library> toDelete = new LinkedList<Library>();

        for (Library lib : existingLibraries) {
            String folderNm = lib.getFolderNm();
            String filepath = lib.getFilepath();
            File file = new File(filepath, folderNm);

            if (!files.contains(file)) {
                toDelete.add(lib);
            } else {
                files.remove(file);
            }
        }

        if (!toDelete.isEmpty()) {
			toDelete.forEach(library -> {
				String libInfo = "";
				try {
					libInfo = library.toString();
					libraryRepository.delete(library);
					log.debug("Deleted library " + libInfo);
				} catch (Exception e) {
					log.debug("Error deleting library " + libInfo);
				}
			});
//            libraryRepository.delete(toDelete);
		}

        for (File file : files) {
            String folderNm = file.getName();

            Library lib = new Library();
            lib.setFolderNm(folderNm);
            lib.setLibraryNm(StringUtils.substring(folderNm, 0, 120));
            lib.setFilepath(file.getParent());
            lib.setLibraryType(typeOldLibrary);

            libraryRepository.save(lib);
        }
    }

    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Library> findLibraries() {
        return libraryRepository.findAll();
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<LibraryRolesDto> findLibraryRoles(final Long libraryId) {
        return Collections.emptyList();
    }

    public void updateLibraryRoles(final int libraryId, final String libraryNm,
                                   final List<LibraryRolesDto> libraryRoles) {
    }

    public List<LibrariesDto> libruariesToDto(List<Library> libraries) {
        List<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();

        for (Library library : libraries) {
            LibrariesDto librariesDto = convertToLibruaryDto(library);
            librariesDtos.add(librariesDto);
        }

        return librariesDtos;
    }

    public LibrariesDto convertToLibruaryDto(Library library) {
        LibrariesDto librariesDto = new LibrariesDto();
        librariesDto.setId(library.getId());
        librariesDto.setLibraryNm(library.getLibraryNm());
        librariesDto.setFilepath(library.getFilepath());
        librariesDto.setFolderNm(library.getFolderNm());

        return librariesDto;
    }

    public LibrariesDto findLibruaryDtoById(Long id) {
        return convertToLibruaryDto(libraryRepository.findOne(id));
    }

    public List<LibrariesDto> findLibruaryDtos() {
        return libruariesToDto(libraryRepository.findAll());
    }
}
