/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.service.Facade;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

public class AccessFilter
implements Filter {
    private static final Log log = LogFactory.getLog(AccessFilter.class);
    private FilterConfig filterConfig = null;
    private Facade facade;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = (Facade)context.getBean(Facade.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.fixUTF8(request, response);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.setRequestUrl(httpRequest);
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void setLocale(HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"Looking for locale...");
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("locale");
        if (locale != null) {
            log.debug((Object)("Using locale " + locale.getDisplayLanguage()));
            return;
        }
        BidiMap languages = this.facade.getConfig().getLanguages();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("im_lang")) continue;
                if (!languages.containsValue((Object)cookie.getValue())) break;
                locale = new Locale(cookie.getValue());
                break;
            }
        }
        if (locale == null) {
            String lang = "sv";
            locale = new Locale(lang);
        }
        log.debug((Object)("Using locale " + locale.getDisplayLanguage()));
        session.setAttribute("locale", (Object)locale);
        session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)locale);
        request.setAttribute("locale", (Object)locale);
    }

    private void setRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url = url + "?" + queryString;
        }
        request.setAttribute("requestUrl", (Object)url);
    }

    private void fixUTF8(ServletRequest request, ServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    public void destroy() {
    }
}

