/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.tag;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class LibraryChildren
extends TagSupport {
    private LibrariesDto library;
    private LibrariesDto currentLibrary;
    private List<LibrariesDto> libraries;

    public int doStartTag() throws JspException {
        String path = this.getLibrary().getFilepath();
        if (path != null) {
            File file = new File(path, this.getLibrary().getFolderNm());
            try {
                JspWriter out = this.pageContext.getOut();
                LibrariesDto lib = this.getLibrary();
                String currentLibraryClass = "";
                if (this.getCurrentLibrary().getId() == lib.getId()) {
                    currentLibraryClass = " class='currentLibrary'";
                }
                out.print("<li data-library-id='" + lib.getId() + "'>" + "<span" + currentLibraryClass + ">" + lib.getLibraryNm() + "</span>");
                this.getSubdirs(file, new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String name = file.getName();
                        return file.isDirectory() && name.length() <= 255;
                    }
                }, out);
                out.print("</li>");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private void getSubdirs(File file, FileFilter filter, JspWriter output) throws IOException {
        if (file == null) {
            return;
        }
        File[] subDirsTmp = file.listFiles(filter);
        if (subDirsTmp == null) {
            subDirsTmp = new File[]{};
        }
        List<File> subdirs = Arrays.asList(subDirsTmp);
        subdirs = new ArrayList<File>(subdirs);
        for (File subdir : subdirs) {
            LibrariesDto subLib = this.matchPathToLibrary(subdir);
            if (subLib == null) {
                return;
            }
            output.print("<ul>");
            String currentLibraryClass = "";
            if (this.getCurrentLibrary().getId() == subLib.getId()) {
                currentLibraryClass = " class='currentLibrary'";
            }
            output.print("<li data-library-id='" + subLib.getId() + "'>" + "<span" + currentLibraryClass + ">" + subdir.getName() + "</span>");
            this.getSubdirs(subdir, filter, output);
            output.print("</li>");
            output.print("</ul>");
        }
    }

    private LibrariesDto matchPathToLibrary(File path) {
        for (LibrariesDto lib : this.getLibraries()) {
            File f;
            if (lib.getFilepath() == null || !path.equals(f = new File(lib.getFilepath(), lib.getFolderNm()))) continue;
            return lib;
        }
        return null;
    }

    public LibrariesDto getLibrary() {
        return this.library;
    }

    public void setLibrary(LibrariesDto library) {
        this.library = library;
    }

    public LibrariesDto getCurrentLibrary() {
        return this.currentLibrary;
    }

    public void setCurrentLibrary(LibrariesDto currentLibrary) {
        this.currentLibrary = currentLibrary;
    }

    public List<LibrariesDto> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<LibrariesDto> libraries) {
        this.libraries = libraries;
    }
}

