<%@ include file="/WEB-INF/includes/taglibs.jspf" %>
<spring:message var="notAvailable" code="changeData.notAvailable"/>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.manufacturer" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:out value="${image.originalExif.manufacturer}" default="${notAvailable}"/>
    </span>
</div>
<div class="clearfix infoRow">
    <span class="infoLabel">
        <spring:message code="changeData.exif.model" htmlEscape="true"/>
    </span>
    <span class='infoValue'><c:out value="${image.originalExif.model}" default="${notAvailable}"/></span>
</div>
<div class="clearfix infoRow odd">
    <span class="infoLabel">
        <spring:message code="changeData.exif.compression" htmlEscape="true"/>
    </span>
    <span class='infoValue'><c:out value="${image.originalExif.compression}" default="${notAvailable}"/></span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.xResolution" htmlEscape="true"/>
    </span>
    <span class='infoValue'>
        <c:out value="${image.originalExif.xResolution}" default="${notAvailable}"/>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.yResolution" htmlEscape="true"/>
    </span>
    <span class='infoValue'>
        <c:out value="${image.originalExif.yResolution}" default="${notAvailable}"/>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.resolutionUnits" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${empty image.originalExif.resolutionUnit}">
                <c:out value="${notAvailable}"/>
            </c:when>
            <c:otherwise>
                <c:out value="${2 eq image.originalExif.resolutionUnit ? 'Inches' : 'Centimeters'}"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.exposure" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:set var="exposureValue" value="${image.originalExif.exposure}"/>
        <c:choose>
            <c:when test="${empty exposureValue}">
                <spring:message code="changeData.notAvailable" htmlEscape="true"/>
            </c:when>
            <c:otherwise>
                <c:out value="${im:doubleToFractionsString(exposureValue)} sec."/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.fNumber" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${empty image.originalExif.fStop}">
                <spring:message code="changeData.notAvailable" htmlEscape="true"/>
            </c:when>
            <c:otherwise>
                <c:out value="f/${image.originalExif.fStop}"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.exposureProgram" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:out value="${image.originalExif.exposureProgram}" default="${notAvailable}"/>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.datetimeDigitized" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${not empty image.originalExif.dateDigitized}">
                <fmt:formatDate value="${image.originalExif.dateDigitized}" pattern="yyyy:MM:dd HH:mm:ss"/>
            </c:when>
            <c:otherwise>
                <spring:message code="changeData.notAvailable" htmlEscape="true"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.datetimeOriginal" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${not empty image.originalExif.dateOriginal}">
                <fmt:formatDate value="${image.originalExif.dateOriginal}" pattern="yyyy:MM:dd HH:mm:ss"/>
            </c:when>
            <c:otherwise>
                <spring:message code="changeData.notAvailable" htmlEscape="true"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.flash" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${'NOT_FIRED' eq image.originalExif.flash}">
                <spring:message code="changeData.exif.flashNotFired" htmlEscape="true"/>
            </c:when>
            <c:when test="${'FIRED' eq image.originalExif.flash}">
                <spring:message code="changeData.exif.flashFired" htmlEscape="true"/>
            </c:when>
            <c:when test="${'FIRED_WITH_RED_EYES_REDUCTION' eq image.originalExif.flash}">
                <spring:message code="changeData.exif.flashFiredWithRedEyeReduction" htmlEscape="true"/>
            </c:when>
            <c:otherwise>
                <spring:message code="changeData.notAvailable" htmlEscape="true"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.focalLength" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${empty image.originalExif.focalLength}">
                <spring:message code="changeData.notAvailable" htmlEscape="true"/>
            </c:when>
            <c:otherwise>
                <c:out value="${image.originalExif.focalLength} m.m."/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.colorSpace" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:out value="${image.originalExif.colorSpace}" default="${notAvailable}"/>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.pixelXDimension" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:out value="${image.originalExif.pixelXDimension}" default="${notAvailable}"/>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.exif.pixelYDimension" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:out value="${image.originalExif.pixelYDimension}" default="${notAvailable}"/>
    </span>
</div>
<div class="clearfix infoRow odd">
    <span class="infoLabel">
        <spring:message code="changeData.exif.ISO" htmlEscape="true"/>
    </span>
    <span class="infoValue"><c:out value="${image.originalExif.ISO}" default="${notAvailable}"/></span>
</div>