package com.imcode.imcms.addon.imagearchive.util;

import java.beans.PropertyEditorSupport;
import java.io.File;

import org.apache.commons.lang3.StringUtils;

import com.imcode.imcms.addon.imagearchive.Config;

public class FileEditor extends PropertyEditorSupport {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty(text)) {
            setValue(null);
            
            return;
        }
        
        File file = new File(text);
        
        if (!file.isAbsolute()) {
            file = new File(Config.getApplicationPath(), text);
        }
        
        setValue(file);
    }
}
